% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_delete_document_classifier}
\alias{comprehend_delete_document_classifier}
\title{Deletes a previously created document classifier Only those classifiers
that are in terminated states (IN_ERROR, TRAINED) will be deleted}
\usage{
comprehend_delete_document_classifier(DocumentClassifierArn)
}
\arguments{
\item{DocumentClassifierArn}{[required] The Amazon Resource Name (ARN) that identifies the document classifier.}
}
\description{
Deletes a previously created document classifier

Only those classifiers that are in terminated states (IN\\_ERROR,
TRAINED) will be deleted. If an active inference job is using the model,
a \code{ResourceInUseException} will be returned.

This is an asynchronous action that puts the classifier into a DELETING
state, and it is then removed by a background job. Once removed, the
classifier disappears from your account and is no longer available for
use.
}
\section{Request syntax}{
\preformatted{svc$delete_document_classifier(
  DocumentClassifierArn = "string"
)
}
}

\keyword{internal}
