% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_language_models}
\alias{transcribeservice_list_language_models}
\title{Provides more information about the custom language models you've
created}
\usage{
transcribeservice_list_language_models(StatusEquals, NameContains,
  NextToken, MaxResults)
}
\arguments{
\item{StatusEquals}{When specified, returns only custom language models with the specified
status. Language models are ordered by creation date, with the newest
models first. If you don't specify a status, Amazon Transcribe returns
all custom language models ordered by date.}

\item{NameContains}{When specified, the custom language model names returned contain the
substring you've specified.}

\item{NextToken}{When included, fetches the next set of jobs if the result of the
previous request was truncated.}

\item{MaxResults}{The maximum number of language models to return in the response. If
there are fewer results in the list, the response contains only the
actual results.}
}
\description{
Provides more information about the custom language models you've
created. You can use the information in this list to find a specific
custom language model. You can then use the operation to get more
information about it.
}
\section{Request syntax}{
\preformatted{svc$list_language_models(
  StatusEquals = "IN_PROGRESS"|"FAILED"|"COMPLETED",
  NameContains = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
