% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_list_document_classifiers}
\alias{comprehend_list_document_classifiers}
\title{Gets a list of the document classifiers that you have created}
\usage{
comprehend_list_document_classifiers(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{Filters the jobs that are returned. You can filter jobs on their name,
status, or the date and time that they were submitted. You can only set
one filter at a time.}

\item{NextToken}{Identifies the next page of results to return.}

\item{MaxResults}{The maximum number of results to return in each page. The default is
100.}
}
\value{
A list with the following syntax:\preformatted{list(
  DocumentClassifierPropertiesList = list(
    list(
      DocumentClassifierArn = "string",
      LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt"|"ar"|"hi"|"ja"|"ko"|"zh"|"zh-TW",
      Status = "SUBMITTED"|"TRAINING"|"DELETING"|"STOP_REQUESTED"|"STOPPED"|"IN_ERROR"|"TRAINED",
      Message = "string",
      SubmitTime = as.POSIXct(
        "2015-01-01"
      ),
      EndTime = as.POSIXct(
        "2015-01-01"
      ),
      TrainingStartTime = as.POSIXct(
        "2015-01-01"
      ),
      TrainingEndTime = as.POSIXct(
        "2015-01-01"
      ),
      InputDataConfig = list(
        DataFormat = "COMPREHEND_CSV"|"AUGMENTED_MANIFEST",
        S3Uri = "string",
        LabelDelimiter = "string",
        AugmentedManifests = list(
          list(
            S3Uri = "string",
            AttributeNames = list(
              "string"
            )
          )
        )
      ),
      OutputDataConfig = list(
        S3Uri = "string",
        KmsKeyId = "string"
      ),
      ClassifierMetadata = list(
        NumberOfLabels = 123,
        NumberOfTrainedDocuments = 123,
        NumberOfTestDocuments = 123,
        EvaluationMetrics = list(
          Accuracy = 123.0,
          Precision = 123.0,
          Recall = 123.0,
          F1Score = 123.0,
          MicroPrecision = 123.0,
          MicroRecall = 123.0,
          MicroF1Score = 123.0,
          HammingLoss = 123.0
        )
      ),
      DataAccessRoleArn = "string",
      VolumeKmsKeyId = "string",
      VpcConfig = list(
        SecurityGroupIds = list(
          "string"
        ),
        Subnets = list(
          "string"
        )
      ),
      Mode = "MULTI_CLASS"|"MULTI_LABEL"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the document classifiers that you have created.
}
\section{Request syntax}{
\preformatted{svc$list_document_classifiers(
  Filter = list(
    Status = "SUBMITTED"|"TRAINING"|"DELETING"|"STOP_REQUESTED"|"STOPPED"|"IN_ERROR"|"TRAINED",
    SubmitTimeBefore = as.POSIXct(
      "2015-01-01"
    ),
    SubmitTimeAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
