% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_model_packages}
\alias{sagemaker_list_model_packages}
\title{Lists the model packages that have been created}
\usage{
sagemaker_list_model_packages(CreationTimeAfter, CreationTimeBefore,
  MaxResults, NameContains, ModelApprovalStatus, ModelPackageGroupName,
  ModelPackageType, NextToken, SortBy, SortOrder)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only model packages created after the specified
time (timestamp).}

\item{CreationTimeBefore}{A filter that returns only model packages created before the specified
time (timestamp).}

\item{MaxResults}{The maximum number of model packages to return in the response.}

\item{NameContains}{A string in the model package name. This filter returns only model
packages whose name contains the specified string.}

\item{ModelApprovalStatus}{A filter that returns only the model packages with the specified
approval status.}

\item{ModelPackageGroupName}{A filter that returns only model versions that belong to the specified
model group.}

\item{ModelPackageType}{A filter that returns onlyl the model packages of the specified type.
This can be one of the following values.
\itemize{
\item \code{VERSIONED} - List only versioned models.
\item \code{UNVERSIONED} - List only unversioined models.
\item \code{BOTH} - List both versioned and unversioned models.
}}

\item{NextToken}{If the response to a previous
\code{\link[=sagemaker_list_model_packages]{list_model_packages}} request was
truncated, the response includes a \code{NextToken}. To retrieve the next set
of model packages, use the token in the next request.}

\item{SortBy}{The parameter by which to sort the results. The default is
\code{CreationTime}.}

\item{SortOrder}{The sort order for the results. The default is \code{Ascending}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ModelPackageSummaryList = list(
    list(
      ModelPackageName = "string",
      ModelPackageGroupName = "string",
      ModelPackageVersion = 123,
      ModelPackageArn = "string",
      ModelPackageDescription = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      ModelPackageStatus = "Pending"|"InProgress"|"Completed"|"Failed"|"Deleting",
      ModelApprovalStatus = "Approved"|"Rejected"|"PendingManualApproval"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the model packages that have been created.
}
\section{Request syntax}{
\preformatted{svc$list_model_packages(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NameContains = "string",
  ModelApprovalStatus = "Approved"|"Rejected"|"PendingManualApproval",
  ModelPackageGroupName = "string",
  ModelPackageType = "Versioned"|"Unversioned"|"Both",
  NextToken = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
