% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_list_terminologies}
\alias{translate_list_terminologies}
\title{Provides a list of custom terminologies associated with your account}
\usage{
translate_list_terminologies(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{If the result of the request to ListTerminologies was truncated, include
the NextToken to fetch the next group of custom terminologies.}

\item{MaxResults}{The maximum number of custom terminologies returned per list request.}
}
\value{
A list with the following syntax:\preformatted{list(
  TerminologyPropertiesList = list(
    list(
      Name = "string",
      Description = "string",
      Arn = "string",
      SourceLanguageCode = "string",
      TargetLanguageCodes = list(
        "string"
      ),
      EncryptionKey = list(
        Type = "KMS",
        Id = "string"
      ),
      SizeBytes = 123,
      TermCount = 123,
      CreatedAt = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdatedAt = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Provides a list of custom terminologies associated with your account.
}
\section{Request syntax}{
\preformatted{svc$list_terminologies(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
