# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemaker_service.R
NULL

#' Adds or overwrites one or more tags for the specified Amazon SageMaker
#' resource
#'
#' Adds or overwrites one or more tags for the specified Amazon SageMaker
#' resource. You can add tags to notebook instances, training jobs,
#' hyperparameter tuning jobs, batch transform jobs, models, labeling jobs,
#' work teams, endpoint configurations, and endpoints.
#' 
#' Each tag consists of a key and an optional value. Tag keys must be
#' unique per resource. For more information about tags, see For more
#' information, see [AWS Tagging
#' Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' 
#' Tags that you add to a hyperparameter tuning job by calling this API are
#' also added to any training jobs that the hyperparameter tuning job
#' launches after you call this API, but not to training jobs that the
#' hyperparameter tuning job launched before you called this API. To make
#' sure that the tags associated with a hyperparameter tuning job are also
#' added to all training jobs that the hyperparameter tuning job launches,
#' add the tags when you first create the tuning job by specifying them in
#' the `Tags` parameter of CreateHyperParameterTuningJob
#'
#' @usage
#' sagemaker_add_tags(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource that you want to tag.
#' @param Tags &#91;required&#93; An array of `Tag` objects. Each tag is a key-value pair. Only the `key`
#' parameter is required. If you don\'t specify a value, Amazon SageMaker
#' sets the value to an empty string.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_add_tags
sagemaker_add_tags <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "AddTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$add_tags_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .sagemaker$add_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$add_tags <- sagemaker_add_tags

#' Create a machine learning algorithm that you can use in Amazon SageMaker
#' and list in the AWS Marketplace
#'
#' Create a machine learning algorithm that you can use in Amazon SageMaker
#' and list in the AWS Marketplace.
#'
#' @usage
#' sagemaker_create_algorithm(AlgorithmName, AlgorithmDescription,
#'   TrainingSpecification, InferenceSpecification, ValidationSpecification,
#'   CertifyForMarketplace)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm.
#' @param AlgorithmDescription A description of the algorithm.
#' @param TrainingSpecification &#91;required&#93; Specifies details about training jobs run by this algorithm, including
#' the following:
#' 
#' -   The Amazon ECR path of the container and the version digest of the
#'     algorithm.
#' 
#' -   The hyperparameters that the algorithm supports.
#' 
#' -   The instance types that the algorithm supports for training.
#' 
#' -   Whether the algorithm supports distributed training.
#' 
#' -   The metrics that the algorithm emits to Amazon CloudWatch.
#' 
#' -   Which metrics that the algorithm emits can be used as the objective
#'     metric for hyperparameter tuning jobs.
#' 
#' -   The input channels that the algorithm supports for training data.
#'     For example, an algorithm might support `train`, `validation`, and
#'     `test` channels.
#' @param InferenceSpecification Specifies details about inference jobs that the algorithm runs,
#' including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the algorithm supports for transform jobs
#'     and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the algorithm supports for
#'     inference.
#' @param ValidationSpecification Specifies configurations for one or more training jobs and that Amazon
#' SageMaker runs to test the algorithm\'s training code and, optionally,
#' one or more batch transform jobs that Amazon SageMaker runs to test the
#' algorithm\'s inference code.
#' @param CertifyForMarketplace Whether to certify the algorithm so that it can be listed in AWS
#' Marketplace.
#'
#' @section Request syntax:
#' ```
#' svc$create_algorithm(
#'   AlgorithmName = "string",
#'   AlgorithmDescription = "string",
#'   TrainingSpecification = list(
#'     TrainingImage = "string",
#'     TrainingImageDigest = "string",
#'     SupportedHyperParameters = list(
#'       list(
#'         Name = "string",
#'         Description = "string",
#'         Type = "Integer"|"Continuous"|"Categorical"|"FreeText",
#'         Range = list(
#'           IntegerParameterRangeSpecification = list(
#'             MinValue = "string",
#'             MaxValue = "string"
#'           ),
#'           ContinuousParameterRangeSpecification = list(
#'             MinValue = "string",
#'             MaxValue = "string"
#'           ),
#'           CategoricalParameterRangeSpecification = list(
#'             Values = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         IsTunable = TRUE|FALSE,
#'         IsRequired = TRUE|FALSE,
#'         DefaultValue = "string"
#'       )
#'     ),
#'     SupportedTrainingInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"
#'     ),
#'     SupportsDistributedTraining = TRUE|FALSE,
#'     MetricDefinitions = list(
#'       list(
#'         Name = "string",
#'         Regex = "string"
#'       )
#'     ),
#'     TrainingChannels = list(
#'       list(
#'         Name = "string",
#'         Description = "string",
#'         IsRequired = TRUE|FALSE,
#'         SupportedContentTypes = list(
#'           "string"
#'         ),
#'         SupportedCompressionTypes = list(
#'           "None"|"Gzip"
#'         ),
#'         SupportedInputModes = list(
#'           "Pipe"|"File"
#'         )
#'       )
#'     ),
#'     SupportedTuningJobObjectiveMetrics = list(
#'       list(
#'         Type = "Maximize"|"Minimize",
#'         MetricName = "string"
#'       )
#'     )
#'   ),
#'   InferenceSpecification = list(
#'     Containers = list(
#'       list(
#'         ContainerHostname = "string",
#'         Image = "string",
#'         ImageDigest = "string",
#'         ModelDataUrl = "string",
#'         ProductId = "string"
#'       )
#'     ),
#'     SupportedTransformInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
#'     ),
#'     SupportedRealtimeInferenceInstanceTypes = list(
#'       "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"
#'     ),
#'     SupportedContentTypes = list(
#'       "string"
#'     ),
#'     SupportedResponseMIMETypes = list(
#'       "string"
#'     )
#'   ),
#'   ValidationSpecification = list(
#'     ValidationRole = "string",
#'     ValidationProfiles = list(
#'       list(
#'         ProfileName = "string",
#'         TrainingJobDefinition = list(
#'           TrainingInputMode = "Pipe"|"File",
#'           HyperParameters = list(
#'             "string"
#'           ),
#'           InputDataConfig = list(
#'             list(
#'               ChannelName = "string",
#'               DataSource = list(
#'                 S3DataSource = list(
#'                   S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                   S3Uri = "string",
#'                   S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'                   AttributeNames = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               ContentType = "string",
#'               CompressionType = "None"|"Gzip",
#'               RecordWrapperType = "None"|"RecordIO",
#'               InputMode = "Pipe"|"File",
#'               ShuffleConfig = list(
#'                 Seed = 123
#'               )
#'             )
#'           ),
#'           OutputDataConfig = list(
#'             KmsKeyId = "string",
#'             S3OutputPath = "string"
#'           ),
#'           ResourceConfig = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge",
#'             InstanceCount = 123,
#'             VolumeSizeInGB = 123,
#'             VolumeKmsKeyId = "string"
#'           ),
#'           StoppingCondition = list(
#'             MaxRuntimeInSeconds = 123
#'           )
#'         ),
#'         TransformJobDefinition = list(
#'           MaxConcurrentTransforms = 123,
#'           MaxPayloadInMB = 123,
#'           BatchStrategy = "MultiRecord"|"SingleRecord",
#'           Environment = list(
#'             "string"
#'           ),
#'           TransformInput = list(
#'             DataSource = list(
#'               S3DataSource = list(
#'                 S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                 S3Uri = "string"
#'               )
#'             ),
#'             ContentType = "string",
#'             CompressionType = "None"|"Gzip",
#'             SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'           ),
#'           TransformOutput = list(
#'             S3OutputPath = "string",
#'             Accept = "string",
#'             AssembleWith = "None"|"Line",
#'             KmsKeyId = "string"
#'           ),
#'           TransformResources = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'             InstanceCount = 123,
#'             VolumeKmsKeyId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   CertifyForMarketplace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_algorithm
sagemaker_create_algorithm <- function(AlgorithmName, AlgorithmDescription = NULL, TrainingSpecification, InferenceSpecification = NULL, ValidationSpecification = NULL, CertifyForMarketplace = NULL) {
  op <- new_operation(
    name = "CreateAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_algorithm_input(AlgorithmName = AlgorithmName, AlgorithmDescription = AlgorithmDescription, TrainingSpecification = TrainingSpecification, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, CertifyForMarketplace = CertifyForMarketplace)
  output <- .sagemaker$create_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_algorithm <- sagemaker_create_algorithm

#' Creates a Git repository as a resource in your Amazon SageMaker account
#'
#' Creates a Git repository as a resource in your Amazon SageMaker account.
#' You can associate the repository with notebook instances so that you can
#' use Git source control for the notebooks you create. The Git repository
#' is a resource in your Amazon SageMaker account, so it can be associated
#' with more than one notebook instance, and it persists independently from
#' the lifecycle of any notebook instances it is associated with.
#' 
#' The repository can be hosted either in [AWS
#' CodeCommit](http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository.
#'
#' @usage
#' sagemaker_create_code_repository(CodeRepositoryName, GitConfig)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param GitConfig &#91;required&#93; Specifies details about the repository, including the URL where the
#' repository is located, the default branch, and credentials to use to
#' access the repository.
#'
#' @section Request syntax:
#' ```
#' svc$create_code_repository(
#'   CodeRepositoryName = "string",
#'   GitConfig = list(
#'     RepositoryUrl = "string",
#'     Branch = "string",
#'     SecretArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_code_repository
sagemaker_create_code_repository <- function(CodeRepositoryName, GitConfig) {
  op <- new_operation(
    name = "CreateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$create_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_code_repository <- sagemaker_create_code_repository

#' Starts a model compilation job
#'
#' Starts a model compilation job. After the model has been compiled,
#' Amazon SageMaker saves the resulting model artifacts to an Amazon Simple
#' Storage Service (Amazon S3) bucket that you specify.
#' 
#' If you choose to host your model using Amazon SageMaker hosting
#' services, you can use the resulting model artifacts as part of the
#' model. You can also use the artifacts with AWS IoT Greengrass. In that
#' case, deploy them as an ML resource.
#' 
#' In the request body, you provide the following:
#' 
#' -   A name for the compilation job
#' 
#' -   Information about the input model artifacts
#' 
#' -   The output location for the compiled model and the device (target)
#'     that the model runs on
#' 
#' -   `The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker assumes to perform the model compilation job`
#' 
#' You can also provide a `Tag` to track the model compilation job\'s
#' resource use and costs. The response body contains the
#' `CompilationJobArn` for the compiled job.
#' 
#' To stop a model compilation job, use StopCompilationJob. To get
#' information about a particular model compilation job, use
#' DescribeCompilationJob. To get information about multiple model
#' compilation jobs, use ListCompilationJobs.
#'
#' @usage
#' sagemaker_create_compilation_job(CompilationJobName, RoleArn,
#'   InputConfig, OutputConfig, StoppingCondition)
#'
#' @param CompilationJobName &#91;required&#93; A name for the model compilation job. The name must be unique within the
#' AWS Region and within your AWS account.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that enables Amazon
#' SageMaker to perform tasks on your behalf.
#' 
#' During model compilation, Amazon SageMaker needs your permission to:
#' 
#' -   Read input data from an S3 bucket
#' 
#' -   Write model artifacts to an S3 bucket
#' 
#' -   Write logs to Amazon CloudWatch Logs
#' 
#' -   Publish metrics to Amazon CloudWatch
#' 
#' You grant permissions for all of these tasks to an IAM role. To pass
#' this role to Amazon SageMaker, the caller of this API must have the
#' `iam:PassRole` permission. For more information, see [Amazon SageMaker
#' Roles.](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html)
#' @param InputConfig &#91;required&#93; Provides information about the location of input model artifacts, the
#' name and shape of the expected data inputs, and the framework in which
#' the model was trained.
#' @param OutputConfig &#91;required&#93; Provides information about the output location for the compiled model
#' and the target device the model runs on.
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model compilation job can run. When the
#' job reaches the time limit, Amazon SageMaker ends the compilation job.
#' Use this API to cap model training costs.
#'
#' @section Request syntax:
#' ```
#' svc$create_compilation_job(
#'   CompilationJobName = "string",
#'   RoleArn = "string",
#'   InputConfig = list(
#'     S3Uri = "string",
#'     DataInputConfig = "string",
#'     Framework = "TENSORFLOW"|"MXNET"|"ONNX"|"PYTORCH"|"XGBOOST"
#'   ),
#'   OutputConfig = list(
#'     S3OutputLocation = "string",
#'     TargetDevice = "lambda"|"ml_m4"|"ml_m5"|"ml_c4"|"ml_c5"|"ml_p2"|"ml_p3"|"jetson_tx1"|"jetson_tx2"|"jetson_nano"|"rasp3b"|"deeplens"|"rk3399"|"rk3288"|"sbe_c"
#'   ),
#'   StoppingCondition = list(
#'     MaxRuntimeInSeconds = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_compilation_job
sagemaker_create_compilation_job <- function(CompilationJobName, RoleArn, InputConfig, OutputConfig, StoppingCondition) {
  op <- new_operation(
    name = "CreateCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_compilation_job_input(CompilationJobName = CompilationJobName, RoleArn = RoleArn, InputConfig = InputConfig, OutputConfig = OutputConfig, StoppingCondition = StoppingCondition)
  output <- .sagemaker$create_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_compilation_job <- sagemaker_create_compilation_job

#' Creates an endpoint using the endpoint configuration specified in the
#' request
#'
#' Creates an endpoint using the endpoint configuration specified in the
#' request. Amazon SageMaker uses the endpoint to provision resources and
#' deploy models. You create the endpoint configuration with the
#' [CreateEndpointConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html)
#' API.
#' 
#' Use this API only for hosting models using Amazon SageMaker hosting
#' services.
#' 
#' You must not delete an `EndpointConfig` in use by an endpoint that is
#' live or while the `UpdateEndpoint` or `CreateEndpoint` operations are
#' being performed on the endpoint. To update an endpoint, you must create
#' a new `EndpointConfig`.
#' 
#' The endpoint name must be unique within an AWS Region in your AWS
#' account.
#' 
#' When it receives the request, Amazon SageMaker creates the endpoint,
#' launches the resources (ML compute instances), and deploys the model(s)
#' on them.
#' 
#' When Amazon SageMaker receives the request, it sets the endpoint status
#' to `Creating`. After it creates the endpoint, it sets the status to
#' `InService`. Amazon SageMaker can then process incoming requests for
#' inferences. To check the status of an endpoint, use the
#' [DescribeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
#' API.
#' 
#' For an example, see [Exercise 1: Using the K-Means Algorithm Provided by
#' Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/ex1.html).
#' 
#' If any of the models hosted at this endpoint get model data from an
#' Amazon S3 location, Amazon SageMaker uses AWS Security Token Service to
#' download model artifacts from the S3 path you provided. AWS STS is
#' activated in your IAM user account by default. If you previously
#' deactivated AWS STS for a region, you need to reactivate AWS STS for
#' that region. For more information, see [Activating and Deactivating AWS
#' STS i an AWS
#' Region](http://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *AWS Identity and Access Management User Guide*.
#'
#' @usage
#' sagemaker_create_endpoint(EndpointName, EndpointConfigName, Tags)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint. The name must be unique within an AWS Region
#' in your AWS account.
#' @param EndpointConfigName &#91;required&#93; The name of an endpoint configuration. For more information, see
#' [CreateEndpointConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpointConfig.html).
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)in
#' the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_endpoint(
#'   EndpointName = "string",
#'   EndpointConfigName = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint
sagemaker_create_endpoint <- function(EndpointName, EndpointConfigName, Tags = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName, Tags = Tags)
  output <- .sagemaker$create_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint <- sagemaker_create_endpoint

#' Creates an endpoint configuration that Amazon SageMaker hosting services
#' uses to deploy models
#'
#' Creates an endpoint configuration that Amazon SageMaker hosting services
#' uses to deploy models. In the configuration, you identify one or more
#' models, created using the `CreateModel` API, to deploy and the resources
#' that you want Amazon SageMaker to provision. Then you call the
#' [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
#' API.
#' 
#' Use this API only if you want to use Amazon SageMaker hosting services
#' to deploy models into production.
#' 
#' In the request, you define one or more `ProductionVariant`s, each of
#' which identifies a model. Each `ProductionVariant` parameter also
#' describes the resources that you want Amazon SageMaker to provision.
#' This includes the number and type of ML compute instances to deploy.
#' 
#' If you are hosting multiple models, you also assign a `VariantWeight` to
#' specify how much traffic you want to allocate to each model. For
#' example, suppose that you want to host two models, A and B, and you
#' assign traffic weight 2 for model A and 1 for model B. Amazon SageMaker
#' distributes two-thirds of the traffic to Model A, and one-third to model
#' B.
#'
#' @usage
#' sagemaker_create_endpoint_config(EndpointConfigName, ProductionVariants,
#'   Tags, KmsKeyId)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration. You specify this name in a
#' [CreateEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateEndpoint.html)
#' request.
#' @param ProductionVariants &#91;required&#93; An list of `ProductionVariant` objects, one for each model that you want
#' to host at this endpoint.
#' @param Tags A list of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a AWS Key Management Service key that
#' Amazon SageMaker uses to encrypt data on the storage volume attached to
#' the ML compute instance that hosts the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$create_endpoint_config(
#'   EndpointConfigName = "string",
#'   ProductionVariants = list(
#'     list(
#'       VariantName = "string",
#'       ModelName = "string",
#'       InitialInstanceCount = 123,
#'       InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge",
#'       InitialVariantWeight = 123.0,
#'       AcceleratorType = "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_endpoint_config
sagemaker_create_endpoint_config <- function(EndpointConfigName, ProductionVariants, Tags = NULL, KmsKeyId = NULL) {
  op <- new_operation(
    name = "CreateEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_endpoint_config_input(EndpointConfigName = EndpointConfigName, ProductionVariants = ProductionVariants, Tags = Tags, KmsKeyId = KmsKeyId)
  output <- .sagemaker$create_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_endpoint_config <- sagemaker_create_endpoint_config

#' Starts a hyperparameter tuning job
#'
#' Starts a hyperparameter tuning job. A hyperparameter tuning job finds
#' the best version of a model by running many training jobs on your
#' dataset using the algorithm you choose and values for hyperparameters
#' within ranges that you specify. It then chooses the hyperparameter
#' values that result in a model that performs the best, as measured by an
#' objective metric that you choose.
#'
#' @usage
#' sagemaker_create_hyper_parameter_tuning_job(HyperParameterTuningJobName,
#'   HyperParameterTuningJobConfig, TrainingJobDefinition, WarmStartConfig,
#'   Tags)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job. This name is the prefix for the names of all
#' training jobs that this tuning job launches. The name must be unique
#' within the same AWS account and AWS Region. The name must have \{ \} to \{
#' \} characters. Valid characters are a-z, A-Z, 0-9, and : + = @ \\_ \% -
#' (hyphen). The name is not case sensitive.
#' @param HyperParameterTuningJobConfig &#91;required&#93; The HyperParameterTuningJobConfig object that describes the tuning job,
#' including the search strategy, the objective metric used to evaluate
#' training jobs, ranges of parameters to search, and resource limits for
#' the tuning job. For more information, see automatic-model-tuning
#' @param TrainingJobDefinition The HyperParameterTrainingJobDefinition object that describes the
#' training jobs that this tuning job launches, including static
#' hyperparameters, input data configuration, output data configuration,
#' resource configuration, and stopping condition.
#' @param WarmStartConfig Specifies the configuration for starting the hyperparameter tuning job
#' using one or more previous tuning jobs as a starting point. The results
#' of previous tuning jobs are used to inform which combinations of
#' hyperparameters to search over in the new tuning job.
#' 
#' All training jobs launched by the new hyperparameter tuning job are
#' evaluated by using the objective metric. If you specify
#' `IDENTICAL_DATA_AND_ALGORITHM` as the `WarmStartType` value for the warm
#' start configuration, the training job that performs the best in the new
#' tuning job is compared to the best training jobs from the parent tuning
#' jobs. From these, the training job that performs the best as measured by
#' the objective metric is returned as the overall best training job.
#' 
#' All training jobs launched by parent hyperparameter tuning jobs and the
#' new hyperparameter tuning jobs count against the limit of training jobs
#' for the tuning job.
#' @param Tags An array of key-value pairs. You can use tags to categorize your AWS
#' resources in different ways, for example, by purpose, owner, or
#' environment. For more information, see [AWS Tagging
#' Strategies](https://aws.amazon.com/answers/account-management/aws-tagging-strategies/).
#' 
#' Tags that you specify for the tuning job are also added to all training
#' jobs that the tuning job launches.
#'
#' @section Request syntax:
#' ```
#' svc$create_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string",
#'   HyperParameterTuningJobConfig = list(
#'     Strategy = "Bayesian"|"Random",
#'     HyperParameterTuningJobObjective = list(
#'       Type = "Maximize"|"Minimize",
#'       MetricName = "string"
#'     ),
#'     ResourceLimits = list(
#'       MaxNumberOfTrainingJobs = 123,
#'       MaxParallelTrainingJobs = 123
#'     ),
#'     ParameterRanges = list(
#'       IntegerParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       ContinuousParameterRanges = list(
#'         list(
#'           Name = "string",
#'           MinValue = "string",
#'           MaxValue = "string",
#'           ScalingType = "Auto"|"Linear"|"Logarithmic"|"ReverseLogarithmic"
#'         )
#'       ),
#'       CategoricalParameterRanges = list(
#'         list(
#'           Name = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       )
#'     ),
#'     TrainingJobEarlyStoppingType = "Off"|"Auto"
#'   ),
#'   TrainingJobDefinition = list(
#'     StaticHyperParameters = list(
#'       "string"
#'     ),
#'     AlgorithmSpecification = list(
#'       TrainingImage = "string",
#'       TrainingInputMode = "Pipe"|"File",
#'       AlgorithmName = "string",
#'       MetricDefinitions = list(
#'         list(
#'           Name = "string",
#'           Regex = "string"
#'         )
#'       )
#'     ),
#'     RoleArn = "string",
#'     InputDataConfig = list(
#'       list(
#'         ChannelName = "string",
#'         DataSource = list(
#'           S3DataSource = list(
#'             S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'             S3Uri = "string",
#'             S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'             AttributeNames = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         ContentType = "string",
#'         CompressionType = "None"|"Gzip",
#'         RecordWrapperType = "None"|"RecordIO",
#'         InputMode = "Pipe"|"File",
#'         ShuffleConfig = list(
#'           Seed = 123
#'         )
#'       )
#'     ),
#'     VpcConfig = list(
#'       SecurityGroupIds = list(
#'         "string"
#'       ),
#'       Subnets = list(
#'         "string"
#'       )
#'     ),
#'     OutputDataConfig = list(
#'       KmsKeyId = "string",
#'       S3OutputPath = "string"
#'     ),
#'     ResourceConfig = list(
#'       InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge",
#'       InstanceCount = 123,
#'       VolumeSizeInGB = 123,
#'       VolumeKmsKeyId = "string"
#'     ),
#'     StoppingCondition = list(
#'       MaxRuntimeInSeconds = 123
#'     ),
#'     EnableNetworkIsolation = TRUE|FALSE,
#'     EnableInterContainerTrafficEncryption = TRUE|FALSE
#'   ),
#'   WarmStartConfig = list(
#'     ParentHyperParameterTuningJobs = list(
#'       list(
#'         HyperParameterTuningJobName = "string"
#'       )
#'     ),
#'     WarmStartType = "IdenticalDataAndAlgorithm"|"TransferLearning"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_hyper_parameter_tuning_job
sagemaker_create_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, HyperParameterTuningJobConfig, TrainingJobDefinition = NULL, WarmStartConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, HyperParameterTuningJobConfig = HyperParameterTuningJobConfig, TrainingJobDefinition = TrainingJobDefinition, WarmStartConfig = WarmStartConfig, Tags = Tags)
  output <- .sagemaker$create_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_hyper_parameter_tuning_job <- sagemaker_create_hyper_parameter_tuning_job

#' Creates a job that uses workers to label the data objects in your input
#' dataset
#'
#' Creates a job that uses workers to label the data objects in your input
#' dataset. You can use the labeled data to train machine learning models.
#' 
#' You can select your workforce from one of three providers:
#' 
#' -   A private workforce that you create. It can include employees,
#'     contractors, and outside experts. Use a private workforce when want
#'     the data to stay within your organization or when a specific set of
#'     skills is required.
#' 
#' -   One or more vendors that you select from the AWS Marketplace.
#'     Vendors provide expertise in specific areas.
#' 
#' -   The Amazon Mechanical Turk workforce. This is the largest workforce,
#'     but it should only be used for public data or data that has been
#'     stripped of any personally identifiable information.
#' 
#' You can also use *automated data labeling* to reduce the number of data
#' objects that need to be labeled by a human. Automated data labeling uses
#' *active learning* to determine if a data object can be labeled by
#' machine or if it needs to be sent to a human worker. For more
#' information, see [Using Automated Data
#' Labeling](http://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html).
#' 
#' The data objects to be labeled are contained in an Amazon S3 bucket. You
#' create a *manifest file* that describes the location of each object. For
#' more information, see [Using Input and Output
#' Data](http://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html).
#' 
#' The output can be used as the manifest file for another labeling job or
#' as training data for your machine learning models.
#'
#' @usage
#' sagemaker_create_labeling_job(LabelingJobName, LabelAttributeName,
#'   InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri,
#'   StoppingConditions, LabelingJobAlgorithmsConfig, HumanTaskConfig, Tags)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job. This name is used to identify the job in a
#' list of labeling jobs.
#' @param LabelAttributeName &#91;required&#93; The attribute name to use for the label in the output manifest file.
#' This is the key for the key/value pair formed with the label that a
#' worker assigns to the object. The name can\'t end with \"-metadata\". If
#' you are running a semantic segmentation labeling job, the attribute name
#' must end with \"-ref\". If you are running any other kind of labeling
#' job, the attribute name must not end with \"-ref\".
#' @param InputConfig &#91;required&#93; Input data for the labeling job, such as the Amazon S3 location of the
#' data objects and the location of the manifest file that describes the
#' data objects.
#' @param OutputConfig &#91;required&#93; The location of the output data and the AWS Key Management Service key
#' ID for the key used to encrypt the output data, if any.
#' @param RoleArn &#91;required&#93; The Amazon Resource Number (ARN) that Amazon SageMaker assumes to
#' perform tasks on your behalf during data labeling. You must grant this
#' role the necessary permissions so that Amazon SageMaker can successfully
#' complete data labeling.
#' @param LabelCategoryConfigS3Uri The S3 URL of the file that defines the categories used to label the
#' data objects.
#' 
#' The file is a JSON structure in the following format:
#' 
#' `\{`
#' 
#' ` "document-version": "2018-11-28"`
#' 
#' ` "labels": \\[`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label 1</i>"`
#' 
#' ` \},`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label 2</i>"`
#' 
#' ` \},`
#' 
#' ` ...`
#' 
#' ` \{`
#' 
#' ` "label": "<i>label n</i>"`
#' 
#' ` \}`
#' 
#' ` \\]`
#' 
#' `\}`
#' @param StoppingConditions A set of conditions for stopping the labeling job. If any of the
#' conditions are met, the job is automatically stopped. You can use these
#' conditions to control the cost of data labeling.
#' @param LabelingJobAlgorithmsConfig Configures the information required to perform automated data labeling.
#' @param HumanTaskConfig &#91;required&#93; Configures the information required for human workers to complete a
#' labeling task.
#' @param Tags An array of key/value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_labeling_job(
#'   LabelingJobName = "string",
#'   LabelAttributeName = "string",
#'   InputConfig = list(
#'     DataSource = list(
#'       S3DataSource = list(
#'         ManifestS3Uri = "string"
#'       )
#'     ),
#'     DataAttributes = list(
#'       ContentClassifiers = list(
#'         "FreeOfPersonallyIdentifiableInformation"|"FreeOfAdultContent"
#'       )
#'     )
#'   ),
#'   OutputConfig = list(
#'     S3OutputPath = "string",
#'     KmsKeyId = "string"
#'   ),
#'   RoleArn = "string",
#'   LabelCategoryConfigS3Uri = "string",
#'   StoppingConditions = list(
#'     MaxHumanLabeledObjectCount = 123,
#'     MaxPercentageOfInputDatasetLabeled = 123
#'   ),
#'   LabelingJobAlgorithmsConfig = list(
#'     LabelingJobAlgorithmSpecificationArn = "string",
#'     InitialActiveLearningModelArn = "string",
#'     LabelingJobResourceConfig = list(
#'       VolumeKmsKeyId = "string"
#'     )
#'   ),
#'   HumanTaskConfig = list(
#'     WorkteamArn = "string",
#'     UiConfig = list(
#'       UiTemplateS3Uri = "string"
#'     ),
#'     PreHumanTaskLambdaArn = "string",
#'     TaskKeywords = list(
#'       "string"
#'     ),
#'     TaskTitle = "string",
#'     TaskDescription = "string",
#'     NumberOfHumanWorkersPerDataObject = 123,
#'     TaskTimeLimitInSeconds = 123,
#'     TaskAvailabilityLifetimeInSeconds = 123,
#'     MaxConcurrentTaskCount = 123,
#'     AnnotationConsolidationConfig = list(
#'       AnnotationConsolidationLambdaArn = "string"
#'     ),
#'     PublicWorkforceTaskPrice = list(
#'       AmountInUsd = list(
#'         Dollars = 123,
#'         Cents = 123,
#'         TenthFractionsOfACent = 123
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_labeling_job
sagemaker_create_labeling_job <- function(LabelingJobName, LabelAttributeName, InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri = NULL, StoppingConditions = NULL, LabelingJobAlgorithmsConfig = NULL, HumanTaskConfig, Tags = NULL) {
  op <- new_operation(
    name = "CreateLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_labeling_job_input(LabelingJobName = LabelingJobName, LabelAttributeName = LabelAttributeName, InputConfig = InputConfig, OutputConfig = OutputConfig, RoleArn = RoleArn, LabelCategoryConfigS3Uri = LabelCategoryConfigS3Uri, StoppingConditions = StoppingConditions, LabelingJobAlgorithmsConfig = LabelingJobAlgorithmsConfig, HumanTaskConfig = HumanTaskConfig, Tags = Tags)
  output <- .sagemaker$create_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_labeling_job <- sagemaker_create_labeling_job

#' Creates a model in Amazon SageMaker
#'
#' Creates a model in Amazon SageMaker. In the request, you name the model
#' and describe a primary container. For the primary container, you specify
#' the docker image containing inference code, artifacts (from prior
#' training), and custom environment map that the inference code uses when
#' you deploy the model for predictions.
#' 
#' Use this API to create a model if you want to use Amazon SageMaker
#' hosting services or run a batch transform job.
#' 
#' To host your model, you create an endpoint configuration with the
#' `CreateEndpointConfig` API, and then create an endpoint with the
#' `CreateEndpoint` API. Amazon SageMaker then deploys all of the
#' containers that you defined for the model in the hosting environment.
#' 
#' To run a batch transform using your model, you start a job with the
#' `CreateTransformJob` API. Amazon SageMaker uses your model and your
#' dataset to get inferences which are then saved to a specified S3
#' location.
#' 
#' In the `CreateModel` request, you must define a container with the
#' `PrimaryContainer` parameter.
#' 
#' In the request, you also provide an IAM role that Amazon SageMaker can
#' assume to access model artifacts and docker image for deployment on ML
#' compute hosting instances or for batch transform jobs. In addition, you
#' also use the IAM role to manage permissions the inference code needs.
#' For example, if the inference code access any other AWS resources, you
#' grant necessary permissions via this role.
#'
#' @usage
#' sagemaker_create_model(ModelName, PrimaryContainer, Containers,
#'   ExecutionRoleArn, Tags, VpcConfig, EnableNetworkIsolation)
#'
#' @param ModelName &#91;required&#93; The name of the new model.
#' @param PrimaryContainer The location of the primary docker image containing inference code,
#' associated artifacts, and custom environment map that the inference code
#' uses when the model is deployed for predictions.
#' @param Containers Specifies the containers in the inference pipeline.
#' @param ExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
#' assume to access model artifacts and docker image for deployment on ML
#' compute instances or for batch transform jobs. Deploying on ML compute
#' instances is part of model hosting. For more information, see [Amazon
#' SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param VpcConfig A
#' [VpcConfig](https://docs.aws.amazon.com/sagemaker/latest/dg/API_VpcConfig.html)
#' object that specifies the VPC that you want your model to connect to.
#' Control access to and from your model container by configuring the VPC.
#' `VpcConfig` is used in hosting services and in batch transform. For more
#' information, see [Protect Endpoints by Using an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html)
#' and [Protect Data in Batch Transform Jobs by Using an Amazon Virtual
#' Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html).
#' @param EnableNetworkIsolation Isolates the model container. No inbound or outbound network calls can
#' be made to or from the model container.
#' 
#' The Semantic Segmentation built-in algorithm does not support network
#' isolation.
#'
#' @section Request syntax:
#' ```
#' svc$create_model(
#'   ModelName = "string",
#'   PrimaryContainer = list(
#'     ContainerHostname = "string",
#'     Image = "string",
#'     ModelDataUrl = "string",
#'     Environment = list(
#'       "string"
#'     ),
#'     ModelPackageName = "string"
#'   ),
#'   Containers = list(
#'     list(
#'       ContainerHostname = "string",
#'       Image = "string",
#'       ModelDataUrl = "string",
#'       Environment = list(
#'         "string"
#'       ),
#'       ModelPackageName = "string"
#'     )
#'   ),
#'   ExecutionRoleArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   ),
#'   EnableNetworkIsolation = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model
sagemaker_create_model <- function(ModelName, PrimaryContainer = NULL, Containers = NULL, ExecutionRoleArn, Tags = NULL, VpcConfig = NULL, EnableNetworkIsolation = NULL) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_input(ModelName = ModelName, PrimaryContainer = PrimaryContainer, Containers = Containers, ExecutionRoleArn = ExecutionRoleArn, Tags = Tags, VpcConfig = VpcConfig, EnableNetworkIsolation = EnableNetworkIsolation)
  output <- .sagemaker$create_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model <- sagemaker_create_model

#' Creates a model package that you can use to create Amazon SageMaker
#' models or list on AWS Marketplace
#'
#' Creates a model package that you can use to create Amazon SageMaker
#' models or list on AWS Marketplace. Buyers can subscribe to model
#' packages listed on AWS Marketplace to create models in Amazon SageMaker.
#' 
#' To create a model package by specifying a Docker container that contains
#' your inference code and the Amazon S3 location of your model artifacts,
#' provide values for `InferenceSpecification`. To create a model from an
#' algorithm resource that you created or subscribed to in AWS Marketplace,
#' provide a value for `SourceAlgorithmSpecification`.
#'
#' @usage
#' sagemaker_create_model_package(ModelPackageName,
#'   ModelPackageDescription, InferenceSpecification,
#'   ValidationSpecification, SourceAlgorithmSpecification,
#'   CertifyForMarketplace)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#' @param ModelPackageDescription A description of the model package.
#' @param InferenceSpecification Specifies details about inference jobs that can be run with models based
#' on this model package, including the following:
#' 
#' -   The Amazon ECR paths of containers that contain the inference code
#'     and model artifacts.
#' 
#' -   The instance types that the model package supports for transform
#'     jobs and real-time endpoints used for inference.
#' 
#' -   The input and output content formats that the model package supports
#'     for inference.
#' @param ValidationSpecification Specifies configurations for one or more transform jobs that Amazon
#' SageMaker runs to test the model package.
#' @param SourceAlgorithmSpecification Details about the algorithm that was used to create the model package.
#' @param CertifyForMarketplace Whether to certify the model package for listing on AWS Marketplace.
#'
#' @section Request syntax:
#' ```
#' svc$create_model_package(
#'   ModelPackageName = "string",
#'   ModelPackageDescription = "string",
#'   InferenceSpecification = list(
#'     Containers = list(
#'       list(
#'         ContainerHostname = "string",
#'         Image = "string",
#'         ImageDigest = "string",
#'         ModelDataUrl = "string",
#'         ProductId = "string"
#'       )
#'     ),
#'     SupportedTransformInstanceTypes = list(
#'       "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"
#'     ),
#'     SupportedRealtimeInferenceInstanceTypes = list(
#'       "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.large"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.large"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"
#'     ),
#'     SupportedContentTypes = list(
#'       "string"
#'     ),
#'     SupportedResponseMIMETypes = list(
#'       "string"
#'     )
#'   ),
#'   ValidationSpecification = list(
#'     ValidationRole = "string",
#'     ValidationProfiles = list(
#'       list(
#'         ProfileName = "string",
#'         TransformJobDefinition = list(
#'           MaxConcurrentTransforms = 123,
#'           MaxPayloadInMB = 123,
#'           BatchStrategy = "MultiRecord"|"SingleRecord",
#'           Environment = list(
#'             "string"
#'           ),
#'           TransformInput = list(
#'             DataSource = list(
#'               S3DataSource = list(
#'                 S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'                 S3Uri = "string"
#'               )
#'             ),
#'             ContentType = "string",
#'             CompressionType = "None"|"Gzip",
#'             SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'           ),
#'           TransformOutput = list(
#'             S3OutputPath = "string",
#'             Accept = "string",
#'             AssembleWith = "None"|"Line",
#'             KmsKeyId = "string"
#'           ),
#'           TransformResources = list(
#'             InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'             InstanceCount = 123,
#'             VolumeKmsKeyId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   SourceAlgorithmSpecification = list(
#'     SourceAlgorithms = list(
#'       list(
#'         ModelDataUrl = "string",
#'         AlgorithmName = "string"
#'       )
#'     )
#'   ),
#'   CertifyForMarketplace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_model_package
sagemaker_create_model_package <- function(ModelPackageName, ModelPackageDescription = NULL, InferenceSpecification = NULL, ValidationSpecification = NULL, SourceAlgorithmSpecification = NULL, CertifyForMarketplace = NULL) {
  op <- new_operation(
    name = "CreateModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_model_package_input(ModelPackageName = ModelPackageName, ModelPackageDescription = ModelPackageDescription, InferenceSpecification = InferenceSpecification, ValidationSpecification = ValidationSpecification, SourceAlgorithmSpecification = SourceAlgorithmSpecification, CertifyForMarketplace = CertifyForMarketplace)
  output <- .sagemaker$create_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_model_package <- sagemaker_create_model_package

#' Creates an Amazon SageMaker notebook instance
#'
#' Creates an Amazon SageMaker notebook instance. A notebook instance is a
#' machine learning (ML) compute instance running on a Jupyter notebook.
#' 
#' In a `CreateNotebookInstance` request, specify the type of ML compute
#' instance that you want to run. Amazon SageMaker launches the instance,
#' installs common libraries that you can use to explore datasets for model
#' training, and attaches an ML storage volume to the notebook instance.
#' 
#' Amazon SageMaker also provides a set of example notebooks. Each notebook
#' demonstrates how to use Amazon SageMaker with a specific algorithm or
#' with a machine learning framework.
#' 
#' After receiving the request, Amazon SageMaker does the following:
#' 
#' 1.  Creates a network interface in the Amazon SageMaker VPC.
#' 
#' 2.  (Option) If you specified `SubnetId`, Amazon SageMaker creates a
#'     network interface in your own VPC, which is inferred from the subnet
#'     ID that you provide in the input. When creating this network
#'     interface, Amazon SageMaker attaches the security group that you
#'     specified in the request to the network interface that it creates in
#'     your VPC.
#' 
#' 3.  Launches an EC2 instance of the type specified in the request in the
#'     Amazon SageMaker VPC. If you specified `SubnetId` of your VPC,
#'     Amazon SageMaker specifies both network interfaces when launching
#'     this instance. This enables inbound traffic from your own VPC to the
#'     notebook instance, assuming that the security groups allow it.
#' 
#' After creating the notebook instance, Amazon SageMaker returns its
#' Amazon Resource Name (ARN).
#' 
#' After Amazon SageMaker creates the notebook instance, you can connect to
#' the Jupyter server and work in Jupyter notebooks. For example, you can
#' write code to explore a dataset that you can use for model training,
#' train a model, host models by creating Amazon SageMaker endpoints, and
#' validate hosted models.
#' 
#' For more information, see [How It
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
#'
#' @usage
#' sagemaker_create_notebook_instance(NotebookInstanceName, InstanceType,
#'   SubnetId, SecurityGroupIds, RoleArn, KmsKeyId, Tags,
#'   LifecycleConfigName, DirectInternetAccess, VolumeSizeInGB,
#'   AcceleratorTypes, DefaultCodeRepository, AdditionalCodeRepositories,
#'   RootAccess)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the new notebook instance.
#' @param InstanceType &#91;required&#93; The type of ML compute instance to launch for the notebook instance.
#' @param SubnetId The ID of the subnet in a VPC to which you would like to have a
#' connectivity from your ML compute instance.
#' @param SecurityGroupIds The VPC security group IDs, in the form sg-xxxxxxxx. The security groups
#' must be for the same VPC as specified in the subnet.
#' @param RoleArn &#91;required&#93; When you send any requests to AWS resources from the notebook instance,
#' Amazon SageMaker assumes this role to perform tasks on your behalf. You
#' must grant this role necessary permissions so Amazon SageMaker can
#' perform these tasks. The policy must allow the Amazon SageMaker service
#' principal (sagemaker.amazonaws.com) permissions to assume this role. For
#' more information, see [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param KmsKeyId The Amazon Resource Name (ARN) of a AWS Key Management Service key that
#' Amazon SageMaker uses to encrypt data on the storage volume attached to
#' your notebook instance. The KMS key you provide must be enabled. For
#' information, see [Enabling and Disabling
#' Keys](http://docs.aws.amazon.com/kms/latest/developerguide/enabling-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' @param Tags A list of tags to associate with the notebook instance. You can add tags
#' later by using the `CreateTags` API.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DirectInternetAccess Sets whether Amazon SageMaker provides internet access to the notebook
#' instance. If you set this to `Disabled` this notebook instance will be
#' able to access resources only in your VPC, and will not be able to
#' connect to Amazon SageMaker training and endpoint services unless your
#' configure a NAT Gateway in your VPC.
#' 
#' For more information, see [Notebook Instances Are Internet-Enabled by
#' Default](https://docs.aws.amazon.com/sagemaker/latest/dg/appendix-additional-considerations.html#appendix-notebook-and-internet-access).
#' You can set the value of this parameter to `Disabled` only if you set a
#' value for the `SubnetId` parameter.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB.
#' @param AcceleratorTypes A list of Elastic Inference (EI) instance types to associate with this
#' notebook instance. Currently, only one instance type can be associated
#' with a notebook instance. For more information, see [Using Elastic
#' Inference in Amazon
#' SageMaker](http://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DefaultCodeRepository A Git repository to associate with the notebook instance as its default
#' code repository. This can be either the name of a Git repository stored
#' as a resource in your account, or the URL of a Git repository in [AWS
#' CodeCommit](http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [AWS
#' CodeCommit](http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' Lifecycle configurations need root access to be able to set up a
#' notebook instance. Because of this, lifecycle configurations associated
#' with a notebook instance always run with root access even if you disable
#' root access for users.
#'
#' @section Request syntax:
#' ```
#' svc$create_notebook_instance(
#'   NotebookInstanceName = "string",
#'   InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge",
#'   SubnetId = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   RoleArn = "string",
#'   KmsKeyId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   LifecycleConfigName = "string",
#'   DirectInternetAccess = "Enabled"|"Disabled",
#'   VolumeSizeInGB = 123,
#'   AcceleratorTypes = list(
#'     "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"
#'   ),
#'   DefaultCodeRepository = "string",
#'   AdditionalCodeRepositories = list(
#'     "string"
#'   ),
#'   RootAccess = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance
sagemaker_create_notebook_instance <- function(NotebookInstanceName, InstanceType, SubnetId = NULL, SecurityGroupIds = NULL, RoleArn, KmsKeyId = NULL, Tags = NULL, LifecycleConfigName = NULL, DirectInternetAccess = NULL, VolumeSizeInGB = NULL, AcceleratorTypes = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, RootAccess = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, SubnetId = SubnetId, SecurityGroupIds = SecurityGroupIds, RoleArn = RoleArn, KmsKeyId = KmsKeyId, Tags = Tags, LifecycleConfigName = LifecycleConfigName, DirectInternetAccess = DirectInternetAccess, VolumeSizeInGB = VolumeSizeInGB, AcceleratorTypes = AcceleratorTypes, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, RootAccess = RootAccess)
  output <- .sagemaker$create_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance <- sagemaker_create_notebook_instance

#' Creates a lifecycle configuration that you can associate with a notebook
#' instance
#'
#' Creates a lifecycle configuration that you can associate with a notebook
#' instance. A *lifecycle configuration* is a collection of shell scripts
#' that run when you create or start a notebook instance.
#' 
#' Each lifecycle configuration script has a limit of 16384 characters.
#' 
#' The value of the `$PATH` environment variable that is available to both
#' scripts is `/sbin:bin:/usr/sbin:/usr/bin`.
#' 
#' View CloudWatch Logs for notebook instance lifecycle configurations in
#' log group `/aws/sagemaker/NotebookInstances` in log stream
#' `\\[notebook-instance-name\\]/\\[LifecycleConfigHook\\]`.
#' 
#' Lifecycle configuration scripts cannot run for longer than 5 minutes. If
#' a script runs for longer than 5 minutes, it fails and the notebook
#' instance is not created or started.
#' 
#' For information about notebook instance lifestyle configurations, see
#' [Step 2.1: (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#'
#' @usage
#' sagemaker_create_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName, OnCreate, OnStart)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate A shell script that runs only once, when you create a notebook instance.
#' The shell script must be a base64-encoded string.
#' @param OnStart A shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance. The shell script must
#' be a base64-encoded string.
#'
#' @section Request syntax:
#' ```
#' svc$create_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string",
#'   OnCreate = list(
#'     list(
#'       Content = "string"
#'     )
#'   ),
#'   OnStart = list(
#'     list(
#'       Content = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_notebook_instance_lifecycle_config
sagemaker_create_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "CreateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$create_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_notebook_instance_lifecycle_config <- sagemaker_create_notebook_instance_lifecycle_config

#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance
#'
#' Returns a URL that you can use to connect to the Jupyter server from a
#' notebook instance. In the Amazon SageMaker console, when you choose
#' `Open` next to a notebook instance, Amazon SageMaker opens a new tab
#' showing the Jupyter server home page from the notebook instance. The
#' console uses this API to get the URL and show the page.
#' 
#' IAM authorization policies for this API are also enforced for every HTTP
#' request and WebSocket frame that attempts to connect to the notebook
#' instance.For example, you can restrict access to this API and to the URL
#' that it returns to a list of IP addresses that you specify. Use the
#' `NotIpAddress` condition operator and the `aws:SourceIP` condition
#' context key to specify the list of IP addresses that you want to have
#' access to the notebook instance. For more information, see [Limit Access
#' to a Notebook Instance by IP
#' Address](https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-ip-filter.html).
#' 
#' The URL that you get from a call to is valid only for 5 minutes. If you
#' try to use the URL after the 5-minute limit expires, you are directed to
#' the AWS console sign-in page.
#'
#' @usage
#' sagemaker_create_presigned_notebook_instance_url(NotebookInstanceName,
#'   SessionExpirationDurationInSeconds)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance.
#' @param SessionExpirationDurationInSeconds The duration of the session, in seconds. The default is 12 hours.
#'
#' @section Request syntax:
#' ```
#' svc$create_presigned_notebook_instance_url(
#'   NotebookInstanceName = "string",
#'   SessionExpirationDurationInSeconds = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_presigned_notebook_instance_url
sagemaker_create_presigned_notebook_instance_url <- function(NotebookInstanceName, SessionExpirationDurationInSeconds = NULL) {
  op <- new_operation(
    name = "CreatePresignedNotebookInstanceUrl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_presigned_notebook_instance_url_input(NotebookInstanceName = NotebookInstanceName, SessionExpirationDurationInSeconds = SessionExpirationDurationInSeconds)
  output <- .sagemaker$create_presigned_notebook_instance_url_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_presigned_notebook_instance_url <- sagemaker_create_presigned_notebook_instance_url

#' Starts a model training job
#'
#' Starts a model training job. After training completes, Amazon SageMaker
#' saves the resulting model artifacts to an Amazon S3 location that you
#' specify.
#' 
#' If you choose to host your model using Amazon SageMaker hosting
#' services, you can use the resulting model artifacts as part of the
#' model. You can also use the artifacts in a machine learning service
#' other than Amazon SageMaker, provided that you know how to use them for
#' inferences.
#' 
#' In the request body, you provide the following:
#' 
#' -   `AlgorithmSpecification` - Identifies the training algorithm to use.
#' 
#' -   `HyperParameters` - Specify these algorithm-specific parameters to
#'     enable the estimation of model parameters during training.
#'     Hyperparameters can be tuned to optimize this learning process. For
#'     a list of hyperparameters for each training algorithm provided by
#'     Amazon SageMaker, see
#'     [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' -   `InputDataConfig` - Describes the training dataset and the Amazon S3
#'     location where it is stored.
#' 
#' -   `OutputDataConfig` - Identifies the Amazon S3 location where you
#'     want Amazon SageMaker to save the results of model training.
#' 
#' -   `ResourceConfig` - Identifies the resources, ML compute instances,
#'     and ML storage volumes to deploy for model training. In distributed
#'     training, you specify more than one instance.
#' 
#' -   `RoleARN` - The Amazon Resource Number (ARN) that Amazon SageMaker
#'     assumes to perform tasks on your behalf during model training. You
#'     must grant this role the necessary permissions so that Amazon
#'     SageMaker can successfully complete model training.
#' 
#' -   `StoppingCondition` - Sets a time limit for training. Use this
#'     parameter to cap model training costs.
#' 
#' For more information about Amazon SageMaker, see [How It
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/how-it-works.html).
#'
#' @usage
#' sagemaker_create_training_job(TrainingJobName, HyperParameters,
#'   AlgorithmSpecification, RoleArn, InputDataConfig, OutputDataConfig,
#'   ResourceConfig, VpcConfig, StoppingCondition, Tags,
#'   EnableNetworkIsolation, EnableInterContainerTrafficEncryption)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job. The name must be unique within an AWS
#' Region in an AWS account.
#' @param HyperParameters Algorithm-specific parameters that influence the quality of the model.
#' You set hyperparameters before you start the learning process. For a
#' list of hyperparameters for each training algorithm provided by Amazon
#' SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' 
#' You can specify a maximum of 100 hyperparameters. Each hyperparameter is
#' a key-value pair. Each key and value is limited to 256 characters, as
#' specified by the `Length Constraint`.
#' @param AlgorithmSpecification &#91;required&#93; The registry path of the Docker image that contains the training
#' algorithm and algorithm-specific metadata, including the input mode. For
#' more information about algorithms provided by Amazon SageMaker, see
#' [Algorithms](https://docs.aws.amazon.com/sagemaker/latest/dg/algos.html).
#' For information about providing your own algorithms, see [Using Your Own
#' Algorithms with Amazon
#' SageMaker](https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms.html).
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) of an IAM role that Amazon SageMaker can
#' assume to perform tasks on your behalf.
#' 
#' During model training, Amazon SageMaker needs your permission to read
#' input data from an S3 bucket, download a Docker image that contains
#' training code, write model artifacts to an S3 bucket, write logs to
#' Amazon CloudWatch Logs, and publish metrics to Amazon CloudWatch. You
#' grant permissions for all of these tasks to an IAM role. For more
#' information, see [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param InputDataConfig An array of `Channel` objects. Each channel is a named input source.
#' `InputDataConfig` describes the input data and its location.
#' 
#' Algorithms can accept input data from one or more channels. For example,
#' an algorithm might have two channels of input data, `training_data` and
#' `validation_data`. The configuration for each channel provides the S3
#' location where the input data is stored. It also provides information
#' about the stored data: the MIME type, compression method, and whether
#' the data is wrapped in RecordIO format.
#' 
#' Depending on the input mode that the algorithm supports, Amazon
#' SageMaker either copies input data files from an S3 bucket to a local
#' directory in the Docker container, or makes it available as input
#' streams.
#' @param OutputDataConfig &#91;required&#93; Specifies the path to the S3 bucket where you want to store model
#' artifacts. Amazon SageMaker creates subfolders for the artifacts.
#' @param ResourceConfig &#91;required&#93; The resources, including the ML compute instances and ML storage
#' volumes, to use for model training.
#' 
#' ML storage volumes store model artifacts and incremental states.
#' Training algorithms might also use ML storage volumes for scratch space.
#' If you want Amazon SageMaker to use the ML storage volume to store the
#' training data, choose `File` as the `TrainingInputMode` in the algorithm
#' specification. For distributed training algorithms, specify an instance
#' count greater than 1.
#' @param VpcConfig A VpcConfig object that specifies the VPC that you want your training
#' job to connect to. Control access to and from your training container by
#' configuring the VPC. For more information, see [Protect Training Jobs by
#' Using an Amazon Virtual Private
#' Cloud](https://docs.aws.amazon.com/sagemaker/latest/dg/train-vpc.html).
#' @param StoppingCondition &#91;required&#93; Specifies a limit to how long a model training job can run. When the job
#' reaches the time limit, Amazon SageMaker ends the training job. Use this
#' API to cap model training costs.
#' 
#' To stop a job, Amazon SageMaker sends the algorithm the `SIGTERM`
#' signal, which delays job termination for 120 seconds. Algorithms can use
#' this 120-second window to save the model artifacts, so the results of
#' training are not lost.
#' @param Tags An array of key-value pairs. For more information, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#' @param EnableNetworkIsolation Isolates the training container. No inbound or outbound network calls
#' can be made, except for calls between peers within a training cluster
#' for distributed training. If you enable network isolation for training
#' jobs that are configured to use a VPC, Amazon SageMaker downloads and
#' uploads customer data and model artifacts through the specified VPC, but
#' the training container does not have network access.
#' 
#' The Semantic Segmentation built-in algorithm does not support network
#' isolation.
#' @param EnableInterContainerTrafficEncryption To encrypt all communications between ML compute instances in
#' distributed training, choose `True`. Encryption provides greater
#' security for distributed training, but training might take longer. How
#' long it takes depends on the amount of communication between compute
#' instances, especially if you use a deep learning algorithm in
#' distributed training. For more information, see [Protect Communications
#' Between ML Compute Instances in a Distributed Training
#' Job](https://docs.aws.amazon.com/sagemaker/latest/dg/train-encrypt.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_training_job(
#'   TrainingJobName = "string",
#'   HyperParameters = list(
#'     "string"
#'   ),
#'   AlgorithmSpecification = list(
#'     TrainingImage = "string",
#'     AlgorithmName = "string",
#'     TrainingInputMode = "Pipe"|"File",
#'     MetricDefinitions = list(
#'       list(
#'         Name = "string",
#'         Regex = "string"
#'       )
#'     )
#'   ),
#'   RoleArn = "string",
#'   InputDataConfig = list(
#'     list(
#'       ChannelName = "string",
#'       DataSource = list(
#'         S3DataSource = list(
#'           S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'           S3Uri = "string",
#'           S3DataDistributionType = "FullyReplicated"|"ShardedByS3Key",
#'           AttributeNames = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ContentType = "string",
#'       CompressionType = "None"|"Gzip",
#'       RecordWrapperType = "None"|"RecordIO",
#'       InputMode = "Pipe"|"File",
#'       ShuffleConfig = list(
#'         Seed = 123
#'       )
#'     )
#'   ),
#'   OutputDataConfig = list(
#'     KmsKeyId = "string",
#'     S3OutputPath = "string"
#'   ),
#'   ResourceConfig = list(
#'     InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge",
#'     InstanceCount = 123,
#'     VolumeSizeInGB = 123,
#'     VolumeKmsKeyId = "string"
#'   ),
#'   VpcConfig = list(
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     Subnets = list(
#'       "string"
#'     )
#'   ),
#'   StoppingCondition = list(
#'     MaxRuntimeInSeconds = 123
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   EnableNetworkIsolation = TRUE|FALSE,
#'   EnableInterContainerTrafficEncryption = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_training_job
sagemaker_create_training_job <- function(TrainingJobName, HyperParameters = NULL, AlgorithmSpecification, RoleArn, InputDataConfig = NULL, OutputDataConfig, ResourceConfig, VpcConfig = NULL, StoppingCondition, Tags = NULL, EnableNetworkIsolation = NULL, EnableInterContainerTrafficEncryption = NULL) {
  op <- new_operation(
    name = "CreateTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_training_job_input(TrainingJobName = TrainingJobName, HyperParameters = HyperParameters, AlgorithmSpecification = AlgorithmSpecification, RoleArn = RoleArn, InputDataConfig = InputDataConfig, OutputDataConfig = OutputDataConfig, ResourceConfig = ResourceConfig, VpcConfig = VpcConfig, StoppingCondition = StoppingCondition, Tags = Tags, EnableNetworkIsolation = EnableNetworkIsolation, EnableInterContainerTrafficEncryption = EnableInterContainerTrafficEncryption)
  output <- .sagemaker$create_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_training_job <- sagemaker_create_training_job

#' Starts a transform job
#'
#' Starts a transform job. A transform job uses a trained model to get
#' inferences on a dataset and saves these results to an Amazon S3 location
#' that you specify.
#' 
#' To perform batch transformations, you create a transform job and use the
#' data that you have readily available.
#' 
#' In the request body, you provide the following:
#' 
#' -   `TransformJobName` - Identifies the transform job. The name must be
#'     unique within an AWS Region in an AWS account.
#' 
#' -   `ModelName` - Identifies the model to use. `ModelName` must be the
#'     name of an existing Amazon SageMaker model in the same AWS Region
#'     and AWS account. For information on creating a model, see
#'     CreateModel.
#' 
#' -   `TransformInput` - Describes the dataset to be transformed and the
#'     Amazon S3 location where it is stored.
#' 
#' -   `TransformOutput` - Identifies the Amazon S3 location where you want
#'     Amazon SageMaker to save the results from the transform job.
#' 
#' -   `TransformResources` - Identifies the ML compute instances for the
#'     transform job.
#' 
#' For more information about how batch transformation works Amazon
#' SageMaker, see [How It
#' Works](https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform.html).
#'
#' @usage
#' sagemaker_create_transform_job(TransformJobName, ModelName,
#'   MaxConcurrentTransforms, MaxPayloadInMB, BatchStrategy, Environment,
#'   TransformInput, TransformOutput, TransformResources, DataProcessing,
#'   Tags)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job. The name must be unique within an AWS
#' Region in an AWS account.
#' @param ModelName &#91;required&#93; The name of the model that you want to use for the transform job.
#' `ModelName` must be the name of an existing Amazon SageMaker model
#' within an AWS Region in an AWS account.
#' @param MaxConcurrentTransforms The maximum number of parallel requests that can be sent to each
#' instance in a transform job. If `MaxConcurrentTransforms` is set to `0`
#' or left unset, Amazon SageMaker checks the optional execution-parameters
#' to determine the optimal settings for your chosen algorithm. If the
#' execution-parameters endpoint is not enabled, the default value is `1`.
#' For more information on execution-parameters, see [How Containers Serve
#' Requests](http://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests).
#' For built-in algorithms, you don\'t need to set a value for
#' `MaxConcurrentTransforms`.
#' @param MaxPayloadInMB The maximum allowed size of the payload, in MB. A *payload* is the data
#' portion of a record (without metadata). The value in `MaxPayloadInMB`
#' must be greater than, or equal to, the size of a single record. To
#' estimate the size of a record in MB, divide the size of your dataset by
#' the number of records. To ensure that the records fit within the maximum
#' payload size, we recommend using a slightly larger value. The default
#' value is `6` MB.
#' 
#' For cases where the payload might be arbitrarily large and is
#' transmitted using HTTP chunked encoding, set the value to `0`. This
#' feature works only in supported algorithms. Currently, Amazon SageMaker
#' built-in algorithms do not support HTTP chunked encoding.
#' @param BatchStrategy Specifies the number of records to include in a mini-batch for an HTTP
#' inference request. A *record* is a single unit of input data that
#' inference can be made on. For example, a single line in a CSV file is a
#' record.
#' 
#' To enable the batch strategy, you must set `SplitType` to `Line`,
#' `RecordIO`, or `TFRecord`.
#' 
#' To use only one record when making an HTTP invocation request to a
#' container, set `BatchStrategy` to `SingleRecord` and `SplitType` to
#' `Line`.
#' 
#' To fit as many records in a mini-batch as can fit within the
#' `MaxPayloadInMB` limit, set `BatchStrategy` to `MultiRecord` and
#' `SplitType` to `Line`.
#' @param Environment The environment variables to set in the Docker container. We support up
#' to 16 key and values entries in the map.
#' @param TransformInput &#91;required&#93; Describes the input source and the way the transform job consumes it.
#' @param TransformOutput &#91;required&#93; Describes the results of the transform job.
#' @param TransformResources &#91;required&#93; Describes the resources, including ML instance types and ML instance
#' count, to use for the transform job.
#' @param DataProcessing The data structure used for combining the input data and inference in
#' the output file. For more information, see [Batch Transform I/O
#' Join](http://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-io-join.html).
#' @param Tags (Optional) An array of key-value pairs. For more information, see [Using
#' Cost Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_transform_job(
#'   TransformJobName = "string",
#'   ModelName = "string",
#'   MaxConcurrentTransforms = 123,
#'   MaxPayloadInMB = 123,
#'   BatchStrategy = "MultiRecord"|"SingleRecord",
#'   Environment = list(
#'     "string"
#'   ),
#'   TransformInput = list(
#'     DataSource = list(
#'       S3DataSource = list(
#'         S3DataType = "ManifestFile"|"S3Prefix"|"AugmentedManifestFile",
#'         S3Uri = "string"
#'       )
#'     ),
#'     ContentType = "string",
#'     CompressionType = "None"|"Gzip",
#'     SplitType = "None"|"Line"|"RecordIO"|"TFRecord"
#'   ),
#'   TransformOutput = list(
#'     S3OutputPath = "string",
#'     Accept = "string",
#'     AssembleWith = "None"|"Line",
#'     KmsKeyId = "string"
#'   ),
#'   TransformResources = list(
#'     InstanceType = "ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.m5.large"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge",
#'     InstanceCount = 123,
#'     VolumeKmsKeyId = "string"
#'   ),
#'   DataProcessing = list(
#'     InputFilter = "string",
#'     OutputFilter = "string",
#'     JoinSource = "Input"|"None"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_transform_job
sagemaker_create_transform_job <- function(TransformJobName, ModelName, MaxConcurrentTransforms = NULL, MaxPayloadInMB = NULL, BatchStrategy = NULL, Environment = NULL, TransformInput, TransformOutput, TransformResources, DataProcessing = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_transform_job_input(TransformJobName = TransformJobName, ModelName = ModelName, MaxConcurrentTransforms = MaxConcurrentTransforms, MaxPayloadInMB = MaxPayloadInMB, BatchStrategy = BatchStrategy, Environment = Environment, TransformInput = TransformInput, TransformOutput = TransformOutput, TransformResources = TransformResources, DataProcessing = DataProcessing, Tags = Tags)
  output <- .sagemaker$create_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_transform_job <- sagemaker_create_transform_job

#' Creates a new work team for labeling your data
#'
#' Creates a new work team for labeling your data. A work team is defined
#' by one or more Amazon Cognito user pools. You must first create the user
#' pools before you can create a work team.
#' 
#' You cannot create more than 25 work teams in an account and region.
#'
#' @usage
#' sagemaker_create_workteam(WorkteamName, MemberDefinitions, Description,
#'   NotificationConfiguration, Tags)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team. Use this name to identify the work team.
#' @param MemberDefinitions &#91;required&#93; A list of `MemberDefinition` objects that contains objects that identify
#' the Amazon Cognito user pool that makes up the work team. For more
#' information, see [Amazon Cognito User
#' Pools](http://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools.html).
#' 
#' All of the `CognitoMemberDefinition` objects that make up the member
#' definition must have the same `ClientId` and `UserPool` values.
#' @param Description &#91;required&#93; A description of the work team.
#' @param NotificationConfiguration Configures notification of workers regarding available or expiring work
#' items.
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_workteam(
#'   WorkteamName = "string",
#'   MemberDefinitions = list(
#'     list(
#'       CognitoMemberDefinition = list(
#'         UserPool = "string",
#'         UserGroup = "string",
#'         ClientId = "string"
#'       )
#'     )
#'   ),
#'   Description = "string",
#'   NotificationConfiguration = list(
#'     NotificationTopicArn = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_create_workteam
sagemaker_create_workteam <- function(WorkteamName, MemberDefinitions, Description, NotificationConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$create_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration, Tags = Tags)
  output <- .sagemaker$create_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$create_workteam <- sagemaker_create_workteam

#' Removes the specified algorithm from your account
#'
#' Removes the specified algorithm from your account.
#'
#' @usage
#' sagemaker_delete_algorithm(AlgorithmName)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_algorithm(
#'   AlgorithmName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_algorithm
sagemaker_delete_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DeleteAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$delete_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_algorithm <- sagemaker_delete_algorithm

#' Deletes the specified Git repository from your account
#'
#' Deletes the specified Git repository from your account.
#'
#' @usage
#' sagemaker_delete_code_repository(CodeRepositoryName)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_code_repository(
#'   CodeRepositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_code_repository
sagemaker_delete_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DeleteCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$delete_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_code_repository <- sagemaker_delete_code_repository

#' Deletes an endpoint
#'
#' Deletes an endpoint. Amazon SageMaker frees up all of the resources that
#' were deployed when the endpoint was created.
#' 
#' Amazon SageMaker retires any custom KMS key grants associated with the
#' endpoint, meaning you don\'t need to use the
#' [RevokeGrant](http://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
#' API call.
#'
#' @usage
#' sagemaker_delete_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint
sagemaker_delete_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$delete_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint <- sagemaker_delete_endpoint

#' Deletes an endpoint configuration
#'
#' Deletes an endpoint configuration. The `DeleteEndpointConfig` API
#' deletes only the specified configuration. It does not delete endpoints
#' created using the configuration.
#'
#' @usage
#' sagemaker_delete_endpoint_config(EndpointConfigName)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_endpoint_config(
#'   EndpointConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_endpoint_config
sagemaker_delete_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DeleteEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$delete_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_endpoint_config <- sagemaker_delete_endpoint_config

#' Deletes a model
#'
#' Deletes a model. The `DeleteModel` API deletes only the model entry that
#' was created in Amazon SageMaker when you called the
#' [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
#' API. It does not delete model artifacts, inference code, or the IAM role
#' that you specified when creating the model.
#'
#' @usage
#' sagemaker_delete_model(ModelName)
#'
#' @param ModelName &#91;required&#93; The name of the model to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_model(
#'   ModelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model
sagemaker_delete_model <- function(ModelName) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_input(ModelName = ModelName)
  output <- .sagemaker$delete_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model <- sagemaker_delete_model

#' Deletes a model package
#'
#' Deletes a model package.
#' 
#' A model package is used to create Amazon SageMaker models or list on AWS
#' Marketplace. Buyers can subscribe to model packages listed on AWS
#' Marketplace to create models in Amazon SageMaker.
#'
#' @usage
#' sagemaker_delete_model_package(ModelPackageName)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package. The name must have 1 to 63 characters.
#' Valid characters are a-z, A-Z, 0-9, and - (hyphen).
#'
#' @section Request syntax:
#' ```
#' svc$delete_model_package(
#'   ModelPackageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_model_package
sagemaker_delete_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DeleteModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$delete_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_model_package <- sagemaker_delete_model_package

#' Deletes an Amazon SageMaker notebook instance
#'
#' Deletes an Amazon SageMaker notebook instance. Before you can delete a
#' notebook instance, you must call the `StopNotebookInstance` API.
#' 
#' When you delete a notebook instance, you lose all of your data. Amazon
#' SageMaker removes the ML compute instance, and deletes the ML storage
#' volume and the network interface associated with the notebook instance.
#'
#' @usage
#' sagemaker_delete_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the Amazon SageMaker notebook instance to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance
sagemaker_delete_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DeleteNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$delete_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance <- sagemaker_delete_notebook_instance

#' Deletes a notebook instance lifecycle configuration
#'
#' Deletes a notebook instance lifecycle configuration.
#'
#' @usage
#' sagemaker_delete_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_notebook_instance_lifecycle_config
sagemaker_delete_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DeleteNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$delete_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_notebook_instance_lifecycle_config <- sagemaker_delete_notebook_instance_lifecycle_config

#' Deletes the specified tags from an Amazon SageMaker resource
#'
#' Deletes the specified tags from an Amazon SageMaker resource.
#' 
#' To list a resource\'s tags, use the `ListTags` API.
#' 
#' When you call this API to delete tags from a hyperparameter tuning job,
#' the deleted tags are not removed from training jobs that the
#' hyperparameter tuning job launched before you called this API.
#'
#' @usage
#' sagemaker_delete_tags(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' delete.
#' @param TagKeys &#91;required&#93; An array or one or more tag keys to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_tags
sagemaker_delete_tags <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_tags_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .sagemaker$delete_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_tags <- sagemaker_delete_tags

#' Deletes an existing work team
#'
#' Deletes an existing work team. This operation can\'t be undone.
#'
#' @usage
#' sagemaker_delete_workteam(WorkteamName)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_workteam(
#'   WorkteamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_delete_workteam
sagemaker_delete_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DeleteWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$delete_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$delete_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$delete_workteam <- sagemaker_delete_workteam

#' Returns a description of the specified algorithm that is in your account
#'
#' Returns a description of the specified algorithm that is in your
#' account.
#'
#' @usage
#' sagemaker_describe_algorithm(AlgorithmName)
#'
#' @param AlgorithmName &#91;required&#93; The name of the algorithm to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_algorithm(
#'   AlgorithmName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_algorithm
sagemaker_describe_algorithm <- function(AlgorithmName) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_algorithm_input(AlgorithmName = AlgorithmName)
  output <- .sagemaker$describe_algorithm_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_algorithm <- sagemaker_describe_algorithm

#' Gets details about the specified Git repository
#'
#' Gets details about the specified Git repository.
#'
#' @usage
#' sagemaker_describe_code_repository(CodeRepositoryName)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_code_repository(
#'   CodeRepositoryName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_code_repository
sagemaker_describe_code_repository <- function(CodeRepositoryName) {
  op <- new_operation(
    name = "DescribeCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_code_repository_input(CodeRepositoryName = CodeRepositoryName)
  output <- .sagemaker$describe_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_code_repository <- sagemaker_describe_code_repository

#' Returns information about a model compilation job
#'
#' Returns information about a model compilation job.
#' 
#' To create a model compilation job, use CreateCompilationJob. To get
#' information about multiple model compilation jobs, use
#' ListCompilationJobs.
#'
#' @usage
#' sagemaker_describe_compilation_job(CompilationJobName)
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job that you want information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_compilation_job(
#'   CompilationJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_compilation_job
sagemaker_describe_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "DescribeCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$describe_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_compilation_job <- sagemaker_describe_compilation_job

#' Returns the description of an endpoint
#'
#' Returns the description of an endpoint.
#'
#' @usage
#' sagemaker_describe_endpoint(EndpointName)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint.
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoint(
#'   EndpointName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint
sagemaker_describe_endpoint <- function(EndpointName) {
  op <- new_operation(
    name = "DescribeEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_input(EndpointName = EndpointName)
  output <- .sagemaker$describe_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint <- sagemaker_describe_endpoint

#' Returns the description of an endpoint configuration created using the
#' CreateEndpointConfig API
#'
#' Returns the description of an endpoint configuration created using the
#' `CreateEndpointConfig` API.
#'
#' @usage
#' sagemaker_describe_endpoint_config(EndpointConfigName)
#'
#' @param EndpointConfigName &#91;required&#93; The name of the endpoint configuration.
#'
#' @section Request syntax:
#' ```
#' svc$describe_endpoint_config(
#'   EndpointConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_endpoint_config
sagemaker_describe_endpoint_config <- function(EndpointConfigName) {
  op <- new_operation(
    name = "DescribeEndpointConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_endpoint_config_input(EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$describe_endpoint_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_endpoint_config <- sagemaker_describe_endpoint_config

#' Gets a description of a hyperparameter tuning job
#'
#' Gets a description of a hyperparameter tuning job.
#'
#' @usage
#' sagemaker_describe_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_hyper_parameter_tuning_job
sagemaker_describe_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "DescribeHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$describe_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_hyper_parameter_tuning_job <- sagemaker_describe_hyper_parameter_tuning_job

#' Gets information about a labeling job
#'
#' Gets information about a labeling job.
#'
#' @usage
#' sagemaker_describe_labeling_job(LabelingJobName)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to return information for.
#'
#' @section Request syntax:
#' ```
#' svc$describe_labeling_job(
#'   LabelingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_labeling_job
sagemaker_describe_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "DescribeLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$describe_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_labeling_job <- sagemaker_describe_labeling_job

#' Describes a model that you created using the CreateModel API
#'
#' Describes a model that you created using the `CreateModel` API.
#'
#' @usage
#' sagemaker_describe_model(ModelName)
#'
#' @param ModelName &#91;required&#93; The name of the model.
#'
#' @section Request syntax:
#' ```
#' svc$describe_model(
#'   ModelName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model
sagemaker_describe_model <- function(ModelName) {
  op <- new_operation(
    name = "DescribeModel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_input(ModelName = ModelName)
  output <- .sagemaker$describe_model_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model <- sagemaker_describe_model

#' Returns a description of the specified model package, which is used to
#' create Amazon SageMaker models or list them on AWS Marketplace
#'
#' Returns a description of the specified model package, which is used to
#' create Amazon SageMaker models or list them on AWS Marketplace.
#' 
#' To create models in Amazon SageMaker, buyers can subscribe to model
#' packages listed on AWS Marketplace.
#'
#' @usage
#' sagemaker_describe_model_package(ModelPackageName)
#'
#' @param ModelPackageName &#91;required&#93; The name of the model package to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_model_package(
#'   ModelPackageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_model_package
sagemaker_describe_model_package <- function(ModelPackageName) {
  op <- new_operation(
    name = "DescribeModelPackage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_model_package_input(ModelPackageName = ModelPackageName)
  output <- .sagemaker$describe_model_package_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_model_package <- sagemaker_describe_model_package

#' Returns information about a notebook instance
#'
#' Returns information about a notebook instance.
#'
#' @usage
#' sagemaker_describe_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance that you want information about.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance
sagemaker_describe_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "DescribeNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$describe_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance <- sagemaker_describe_notebook_instance

#' Returns a description of a notebook instance lifecycle configuration
#'
#' Returns a description of a notebook instance lifecycle configuration.
#' 
#' For information about notebook instance lifestyle configurations, see
#' [Step 2.1: (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#'
#' @usage
#' sagemaker_describe_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_notebook_instance_lifecycle_config
sagemaker_describe_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName) {
  op <- new_operation(
    name = "DescribeNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName)
  output <- .sagemaker$describe_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_notebook_instance_lifecycle_config <- sagemaker_describe_notebook_instance_lifecycle_config

#' Gets information about a work team provided by a vendor
#'
#' Gets information about a work team provided by a vendor. It returns
#' details about the subscription with a vendor in the AWS Marketplace.
#'
#' @usage
#' sagemaker_describe_subscribed_workteam(WorkteamArn)
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the subscribed work team to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subscribed_workteam(
#'   WorkteamArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_subscribed_workteam
sagemaker_describe_subscribed_workteam <- function(WorkteamArn) {
  op <- new_operation(
    name = "DescribeSubscribedWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_subscribed_workteam_input(WorkteamArn = WorkteamArn)
  output <- .sagemaker$describe_subscribed_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_subscribed_workteam <- sagemaker_describe_subscribed_workteam

#' Returns information about a training job
#'
#' Returns information about a training job.
#'
#' @usage
#' sagemaker_describe_training_job(TrainingJobName)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job.
#'
#' @section Request syntax:
#' ```
#' svc$describe_training_job(
#'   TrainingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_training_job
sagemaker_describe_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "DescribeTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$describe_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_training_job <- sagemaker_describe_training_job

#' Returns information about a transform job
#'
#' Returns information about a transform job.
#'
#' @usage
#' sagemaker_describe_transform_job(TransformJobName)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job that you want to view details of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transform_job(
#'   TransformJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_transform_job
sagemaker_describe_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "DescribeTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$describe_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_transform_job <- sagemaker_describe_transform_job

#' Gets information about a specific work team
#'
#' Gets information about a specific work team. You can see information
#' such as the create date, the last updated date, membership information,
#' and the work team\'s Amazon Resource Name (ARN).
#'
#' @usage
#' sagemaker_describe_workteam(WorkteamName)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to return a description of.
#'
#' @section Request syntax:
#' ```
#' svc$describe_workteam(
#'   WorkteamName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_describe_workteam
sagemaker_describe_workteam <- function(WorkteamName) {
  op <- new_operation(
    name = "DescribeWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$describe_workteam_input(WorkteamName = WorkteamName)
  output <- .sagemaker$describe_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$describe_workteam <- sagemaker_describe_workteam

#' An auto-complete API for the search functionality in the Amazon
#' SageMaker console
#'
#' An auto-complete API for the search functionality in the Amazon
#' SageMaker console. It returns suggestions of possible matches for the
#' property name to use in `Search` queries. Provides suggestions for
#' `HyperParameters`, `Tags`, and `Metrics`.
#'
#' @usage
#' sagemaker_get_search_suggestions(Resource, SuggestionQuery)
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to Search for. The only valid
#' `Resource` value is `TrainingJob`.
#' @param SuggestionQuery Limits the property names that are included in the response.
#'
#' @section Request syntax:
#' ```
#' svc$get_search_suggestions(
#'   Resource = "TrainingJob",
#'   SuggestionQuery = list(
#'     PropertyNameQuery = list(
#'       PropertyNameHint = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_get_search_suggestions
sagemaker_get_search_suggestions <- function(Resource, SuggestionQuery = NULL) {
  op <- new_operation(
    name = "GetSearchSuggestions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$get_search_suggestions_input(Resource = Resource, SuggestionQuery = SuggestionQuery)
  output <- .sagemaker$get_search_suggestions_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$get_search_suggestions <- sagemaker_get_search_suggestions

#' Lists the machine learning algorithms that have been created
#'
#' Lists the machine learning algorithms that have been created.
#'
#' @usage
#' sagemaker_list_algorithms(CreationTimeAfter, CreationTimeBefore,
#'   MaxResults, NameContains, NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only algorithms created after the specified time
#' (timestamp).
#' @param CreationTimeBefore A filter that returns only algorithms created before the specified time
#' (timestamp).
#' @param MaxResults The maximum number of algorithms to return in the response.
#' @param NameContains A string in the algorithm name. This filter returns only algorithms
#' whose name contains the specified string.
#' @param NextToken If the response to a previous `ListAlgorithms` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' algorithms, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_algorithms(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_algorithms
sagemaker_list_algorithms <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListAlgorithms",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_algorithms_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_algorithms_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_algorithms <- sagemaker_list_algorithms

#' Gets a list of the Git repositories in your account
#'
#' Gets a list of the Git repositories in your account.
#'
#' @usage
#' sagemaker_list_code_repositories(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NameContains,
#'   NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only Git repositories that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only Git repositories that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only Git repositories that were last modified
#' after the specified time.
#' @param LastModifiedTimeBefore A filter that returns only Git repositories that were last modified
#' before the specified time.
#' @param MaxResults The maximum number of Git repositories to return in the response.
#' @param NameContains A string in the Git repositories name. This filter returns only
#' repositories whose name contains the specified string.
#' @param NextToken If the result of a `ListCodeRepositoriesOutput` request was truncated,
#' the response includes a `NextToken`. To get the next set of Git
#' repositories, use the token in the next request.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_code_repositories(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime"|"LastModifiedTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_code_repositories
sagemaker_list_code_repositories <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCodeRepositories",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_code_repositories_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_code_repositories_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_code_repositories <- sagemaker_list_code_repositories

#' Lists model compilation jobs that satisfy various filters
#'
#' Lists model compilation jobs that satisfy various filters.
#' 
#' To create a model compilation job, use CreateCompilationJob. To get
#' information about a particular model compilation job you have created,
#' use DescribeCompilationJob.
#'
#' @usage
#' sagemaker_list_compilation_jobs(NextToken, MaxResults,
#'   CreationTimeAfter, CreationTimeBefore, LastModifiedTimeAfter,
#'   LastModifiedTimeBefore, NameContains, StatusEquals, SortBy, SortOrder)
#'
#' @param NextToken If the result of the previous `ListCompilationJobs` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of model compilation jobs, use the token in the next request.
#' @param MaxResults The maximum number of model compilation jobs to return in the response.
#' @param CreationTimeAfter A filter that returns the model compilation jobs that were created after
#' a specified time.
#' @param CreationTimeBefore A filter that returns the model compilation jobs that were created
#' before a specified time.
#' @param LastModifiedTimeAfter A filter that returns the model compilation jobs that were modified
#' after a specified time.
#' @param LastModifiedTimeBefore A filter that returns the model compilation jobs that were modified
#' before a specified time.
#' @param NameContains A filter that returns the model compilation jobs whose name contains a
#' specified string.
#' @param StatusEquals A filter that retrieves model compilation jobs with a specific
#' DescribeCompilationJobResponse\\$CompilationJobStatus status.
#' @param SortBy The field by which to sort results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_compilation_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "INPROGRESS"|"COMPLETED"|"FAILED"|"STARTING"|"STOPPING"|"STOPPED",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_compilation_jobs
sagemaker_list_compilation_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListCompilationJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_compilation_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_compilation_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_compilation_jobs <- sagemaker_list_compilation_jobs

#' Lists endpoint configurations
#'
#' Lists endpoint configurations.
#'
#' @usage
#' sagemaker_list_endpoint_configs(SortBy, SortOrder, NextToken,
#'   MaxResults, NameContains, CreationTimeBefore, CreationTimeAfter)
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListEndpointConfig` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of endpoint configurations, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param NameContains A string in the endpoint configuration name. This filter returns only
#' endpoint configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoint configurations created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoint configurations with a creation time
#' greater than or equal to the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoint_configs(
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoint_configs
sagemaker_list_endpoint_configs <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListEndpointConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoint_configs_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_endpoint_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoint_configs <- sagemaker_list_endpoint_configs

#' Lists endpoints
#'
#' Lists endpoints.
#'
#' @usage
#' sagemaker_list_endpoints(SortBy, SortOrder, NextToken, MaxResults,
#'   NameContains, CreationTimeBefore, CreationTimeAfter,
#'   LastModifiedTimeBefore, LastModifiedTimeAfter, StatusEquals)
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of a `ListEndpoints` request was truncated, the response
#' includes a `NextToken`. To retrieve the next set of endpoints, use the
#' token in the next request.
#' @param MaxResults The maximum number of endpoints to return in the response.
#' @param NameContains A string in endpoint names. This filter returns only endpoints whose
#' name contains the specified string.
#' @param CreationTimeBefore A filter that returns only endpoints that were created before the
#' specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only endpoints with a creation time greater than
#' or equal to the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only endpoints that were modified before the
#' specified timestamp.
#' @param LastModifiedTimeAfter A filter that returns only endpoints that were modified after the
#' specified timestamp.
#' @param StatusEquals A filter that returns only endpoints with the specified status.
#'
#' @section Request syntax:
#' ```
#' svc$list_endpoints(
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "OutOfService"|"Creating"|"Updating"|"SystemUpdating"|"RollingBack"|"InService"|"Deleting"|"Failed"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_endpoints
sagemaker_list_endpoints <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_endpoints_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals)
  output <- .sagemaker$list_endpoints_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_endpoints <- sagemaker_list_endpoints

#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account
#'
#' Gets a list of HyperParameterTuningJobSummary objects that describe the
#' hyperparameter tuning jobs launched in your account.
#'
#' @usage
#' sagemaker_list_hyper_parameter_tuning_jobs(NextToken, MaxResults,
#'   SortBy, SortOrder, NameContains, CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, StatusEquals)
#'
#' @param NextToken If the result of the previous `ListHyperParameterTuningJobs` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of tuning jobs, use the token in the next request.
#' @param MaxResults The maximum number of tuning jobs to return. The default value is 10.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the tuning job name. This filter returns only tuning jobs
#' whose name contains the specified string.
#' @param CreationTimeAfter A filter that returns only tuning jobs that were created after the
#' specified time.
#' @param CreationTimeBefore A filter that returns only tuning jobs that were created before the
#' specified time.
#' @param LastModifiedTimeAfter A filter that returns only tuning jobs that were modified after the
#' specified time.
#' @param LastModifiedTimeBefore A filter that returns only tuning jobs that were modified before the
#' specified time.
#' @param StatusEquals A filter that returns only tuning jobs with the specified status.
#'
#' @section Request syntax:
#' ```
#' svc$list_hyper_parameter_tuning_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"Status"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Completed"|"InProgress"|"Failed"|"Stopped"|"Stopping"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_hyper_parameter_tuning_jobs
sagemaker_list_hyper_parameter_tuning_jobs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListHyperParameterTuningJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_hyper_parameter_tuning_jobs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, StatusEquals = StatusEquals)
  output <- .sagemaker$list_hyper_parameter_tuning_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_hyper_parameter_tuning_jobs <- sagemaker_list_hyper_parameter_tuning_jobs

#' Gets a list of labeling jobs
#'
#' Gets a list of labeling jobs.
#'
#' @usage
#' sagemaker_list_labeling_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, MaxResults, NextToken,
#'   NameContains, SortBy, SortOrder, StatusEquals)
#'
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only labeling jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only labeling jobs modified before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous `ListLabelingJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' labeling jobs, use the token in the next request.
#' @param NameContains A string in the labeling job name. This filter returns only labeling
#' jobs whose name contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param StatusEquals A filter that retrieves only labeling jobs with a specific status.
#'
#' @section Request syntax:
#' ```
#' svc$list_labeling_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   NameContains = "string",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs
sagemaker_list_labeling_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, MaxResults = NULL, NextToken = NULL, NameContains = NULL, SortBy = NULL, SortOrder = NULL, StatusEquals = NULL) {
  op <- new_operation(
    name = "ListLabelingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, MaxResults = MaxResults, NextToken = NextToken, NameContains = NameContains, SortBy = SortBy, SortOrder = SortOrder, StatusEquals = StatusEquals)
  output <- .sagemaker$list_labeling_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs <- sagemaker_list_labeling_jobs

#' Gets a list of labeling jobs assigned to a specified work team
#'
#' Gets a list of labeling jobs assigned to a specified work team.
#'
#' @usage
#' sagemaker_list_labeling_jobs_for_workteam(WorkteamArn, MaxResults,
#'   NextToken, CreationTimeAfter, CreationTimeBefore,
#'   JobReferenceCodeContains, SortBy, SortOrder)
#'
#' @param WorkteamArn &#91;required&#93; The Amazon Resource Name (ARN) of the work team for which you want to
#' see labeling jobs for.
#' @param MaxResults The maximum number of labeling jobs to return in each page of the
#' response.
#' @param NextToken If the result of the previous `ListLabelingJobsForWorkteam` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param CreationTimeAfter A filter that returns only labeling jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only labeling jobs created before the specified
#' time (timestamp).
#' @param JobReferenceCodeContains A filter the limits jobs to only the ones whose job reference code
#' contains the specified string.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_labeling_jobs_for_workteam(
#'   WorkteamArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   JobReferenceCodeContains = "string",
#'   SortBy = "CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_labeling_jobs_for_workteam
sagemaker_list_labeling_jobs_for_workteam <- function(WorkteamArn, MaxResults = NULL, NextToken = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, JobReferenceCodeContains = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListLabelingJobsForWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_labeling_jobs_for_workteam_input(WorkteamArn = WorkteamArn, MaxResults = MaxResults, NextToken = NextToken, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, JobReferenceCodeContains = JobReferenceCodeContains, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_labeling_jobs_for_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_labeling_jobs_for_workteam <- sagemaker_list_labeling_jobs_for_workteam

#' Lists the model packages that have been created
#'
#' Lists the model packages that have been created.
#'
#' @usage
#' sagemaker_list_model_packages(CreationTimeAfter, CreationTimeBefore,
#'   MaxResults, NameContains, NextToken, SortBy, SortOrder)
#'
#' @param CreationTimeAfter A filter that returns only model packages created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only model packages created before the specified
#' time (timestamp).
#' @param MaxResults The maximum number of model packages to return in the response.
#' @param NameContains A string in the model package name. This filter returns only model
#' packages whose name contains the specified string.
#' @param NextToken If the response to a previous `ListModelPackages` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of model
#' packages, use the token in the next request.
#' @param SortBy The parameter by which to sort the results. The default is
#' `CreationTime`.
#' @param SortOrder The sort order for the results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_model_packages(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NameContains = "string",
#'   NextToken = "string",
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_model_packages
sagemaker_list_model_packages <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, MaxResults = NULL, NameContains = NULL, NextToken = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListModelPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_model_packages_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, MaxResults = MaxResults, NameContains = NameContains, NextToken = NextToken, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_model_packages_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_model_packages <- sagemaker_list_model_packages

#' Lists models created with the CreateModel API
#'
#' Lists models created with the
#' [CreateModel](https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html)
#' API.
#'
#' @usage
#' sagemaker_list_models(SortBy, SortOrder, NextToken, MaxResults,
#'   NameContains, CreationTimeBefore, CreationTimeAfter)
#'
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the response to a previous `ListModels` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of models, use
#' the token in the next request.
#' @param MaxResults The maximum number of models to return in the response.
#' @param NameContains A string in the training job name. This filter returns only models in
#' the training job whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only models created before the specified time
#' (timestamp).
#' @param CreationTimeAfter A filter that returns only models with a creation time greater than or
#' equal to the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_models(
#'   SortBy = "Name"|"CreationTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_models
sagemaker_list_models <- function(SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL) {
  op <- new_operation(
    name = "ListModels",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_models_input(SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter)
  output <- .sagemaker$list_models_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_models <- sagemaker_list_models

#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' Lists notebook instance lifestyle configurations created with the
#' CreateNotebookInstanceLifecycleConfig API.
#'
#' @usage
#' sagemaker_list_notebook_instance_lifecycle_configs(NextToken,
#'   MaxResults, SortBy, SortOrder, NameContains, CreationTimeBefore,
#'   CreationTimeAfter, LastModifiedTimeBefore, LastModifiedTimeAfter)
#'
#' @param NextToken If the result of a `ListNotebookInstanceLifecycleConfigs` request was
#' truncated, the response includes a `NextToken`. To get the next set of
#' lifecycle configurations, use the token in the next request.
#' @param MaxResults The maximum number of lifecycle configurations to return in the
#' response.
#' @param SortBy Sorts the list of results. The default is `CreationTime`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the lifecycle configuration name. This filter returns only
#' lifecycle configurations whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only lifecycle configurations that were created
#' before the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only lifecycle configurations that were created
#' after the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only lifecycle configurations that were modified
#' before the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only lifecycle configurations that were modified
#' after the specified time (timestamp).
#'
#' @section Request syntax:
#' ```
#' svc$list_notebook_instance_lifecycle_configs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"CreationTime"|"LastModifiedTime",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instance_lifecycle_configs
sagemaker_list_notebook_instance_lifecycle_configs <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL) {
  op <- new_operation(
    name = "ListNotebookInstanceLifecycleConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instance_lifecycle_configs_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter)
  output <- .sagemaker$list_notebook_instance_lifecycle_configs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instance_lifecycle_configs <- sagemaker_list_notebook_instance_lifecycle_configs

#' Returns a list of the Amazon SageMaker notebook instances in the
#' requester's account in an AWS Region
#'
#' Returns a list of the Amazon SageMaker notebook instances in the
#' requester\'s account in an AWS Region.
#'
#' @usage
#' sagemaker_list_notebook_instances(NextToken, MaxResults, SortBy,
#'   SortOrder, NameContains, CreationTimeBefore, CreationTimeAfter,
#'   LastModifiedTimeBefore, LastModifiedTimeAfter, StatusEquals,
#'   NotebookInstanceLifecycleConfigNameContains,
#'   DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals)
#'
#' @param NextToken If the previous call to the `ListNotebookInstances` is truncated, the
#' response includes a `NextToken`. You can use this token in your
#' subsequent `ListNotebookInstances` request to fetch the next set of
#' notebook instances.
#' 
#' You might specify a filter or a sort order in your request. When
#' response is truncated, you must use the same values for the filer and
#' sort order in the next request.
#' @param MaxResults The maximum number of notebook instances to return.
#' @param SortBy The field to sort results by. The default is `Name`.
#' @param SortOrder The sort order for results.
#' @param NameContains A string in the notebook instances\' name. This filter returns only
#' notebook instances whose name contains the specified string.
#' @param CreationTimeBefore A filter that returns only notebook instances that were created before
#' the specified time (timestamp).
#' @param CreationTimeAfter A filter that returns only notebook instances that were created after
#' the specified time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only notebook instances that were modified before
#' the specified time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only notebook instances that were modified after
#' the specified time (timestamp).
#' @param StatusEquals A filter that returns only notebook instances with the specified status.
#' @param NotebookInstanceLifecycleConfigNameContains A string in the name of a notebook instances lifecycle configuration
#' associated with this notebook instance. This filter returns only
#' notebook instances associated with a lifecycle configuration with a name
#' that contains the specified string.
#' @param DefaultCodeRepositoryContains A string in the name or URL of a Git repository associated with this
#' notebook instance. This filter returns only notebook instances
#' associated with a git repository with a name that contains the specified
#' string.
#' @param AdditionalCodeRepositoryEquals A filter that returns only notebook instances with associated with the
#' specified git repository.
#'
#' @section Request syntax:
#' ```
#' svc$list_notebook_instances(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   StatusEquals = "Pending"|"InService"|"Stopping"|"Stopped"|"Failed"|"Deleting"|"Updating",
#'   NotebookInstanceLifecycleConfigNameContains = "string",
#'   DefaultCodeRepositoryContains = "string",
#'   AdditionalCodeRepositoryEquals = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_notebook_instances
sagemaker_list_notebook_instances <- function(NextToken = NULL, MaxResults = NULL, SortBy = NULL, SortOrder = NULL, NameContains = NULL, CreationTimeBefore = NULL, CreationTimeAfter = NULL, LastModifiedTimeBefore = NULL, LastModifiedTimeAfter = NULL, StatusEquals = NULL, NotebookInstanceLifecycleConfigNameContains = NULL, DefaultCodeRepositoryContains = NULL, AdditionalCodeRepositoryEquals = NULL) {
  op <- new_operation(
    name = "ListNotebookInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_notebook_instances_input(NextToken = NextToken, MaxResults = MaxResults, SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, CreationTimeBefore = CreationTimeBefore, CreationTimeAfter = CreationTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, StatusEquals = StatusEquals, NotebookInstanceLifecycleConfigNameContains = NotebookInstanceLifecycleConfigNameContains, DefaultCodeRepositoryContains = DefaultCodeRepositoryContains, AdditionalCodeRepositoryEquals = AdditionalCodeRepositoryEquals)
  output <- .sagemaker$list_notebook_instances_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_notebook_instances <- sagemaker_list_notebook_instances

#' Gets a list of the work teams that you are subscribed to in the AWS
#' Marketplace
#'
#' Gets a list of the work teams that you are subscribed to in the AWS
#' Marketplace. The list may be empty if no work team satisfies the filter
#' specified in the `NameContains` parameter.
#'
#' @usage
#' sagemaker_list_subscribed_workteams(NameContains, NextToken, MaxResults)
#'
#' @param NameContains A string in the work team name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous `ListSubscribedWorkteams` request was
#' truncated, the response includes a `NextToken`. To retrieve the next set
#' of labeling jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_subscribed_workteams(
#'   NameContains = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_subscribed_workteams
sagemaker_list_subscribed_workteams <- function(NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListSubscribedWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_subscribed_workteams_input(NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_subscribed_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_subscribed_workteams <- sagemaker_list_subscribed_workteams

#' Returns the tags for the specified Amazon SageMaker resource
#'
#' Returns the tags for the specified Amazon SageMaker resource.
#'
#' @usage
#' sagemaker_list_tags(ResourceArn, NextToken, MaxResults)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource whose tags you want to
#' retrieve.
#' @param NextToken If the response to the previous `ListTags` request is truncated, Amazon
#' SageMaker returns this token. To retrieve the next set of tags, use it
#' in the subsequent request.
#' @param MaxResults Maximum number of tags to return.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   ResourceArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_tags
sagemaker_list_tags <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_tags_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_tags_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_tags <- sagemaker_list_tags

#' Lists training jobs
#'
#' Lists training jobs.
#'
#' @usage
#' sagemaker_list_training_jobs(NextToken, MaxResults, CreationTimeAfter,
#'   CreationTimeBefore, LastModifiedTimeAfter, LastModifiedTimeBefore,
#'   NameContains, StatusEquals, SortBy, SortOrder)
#'
#' @param NextToken If the result of the previous `ListTrainingJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' training jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return in the response.
#' @param CreationTimeAfter A filter that returns only training jobs created after the specified
#' time (timestamp).
#' @param CreationTimeBefore A filter that returns only training jobs created before the specified
#' time (timestamp).
#' @param LastModifiedTimeAfter A filter that returns only training jobs modified after the specified
#' time (timestamp).
#' @param LastModifiedTimeBefore A filter that returns only training jobs modified before the specified
#' time (timestamp).
#' @param NameContains A string in the training job name. This filter returns only training
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only training jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_training_jobs(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs
sagemaker_list_training_jobs <- function(NextToken = NULL, MaxResults = NULL, CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_input(NextToken = NextToken, MaxResults = MaxResults, CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs <- sagemaker_list_training_jobs

#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched
#'
#' Gets a list of TrainingJobSummary objects that describe the training
#' jobs that a hyperparameter tuning job launched.
#'
#' @usage
#' sagemaker_list_training_jobs_for_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName, NextToken, MaxResults, StatusEquals,
#'   SortBy, SortOrder)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job whose training jobs you want to list.
#' @param NextToken If the result of the previous
#' `ListTrainingJobsForHyperParameterTuningJob` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of training
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of training jobs to return. The default value is 10.
#' @param StatusEquals A filter that returns only training jobs with the specified status.
#' @param SortBy The field to sort results by. The default is `Name`.
#' 
#' If the value of this field is `FinalObjectiveMetricValue`, any training
#' jobs that did not return an objective metric are not listed.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#'
#' @section Request syntax:
#' ```
#' svc$list_training_jobs_for_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status"|"FinalObjectiveMetricValue",
#'   SortOrder = "Ascending"|"Descending"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_training_jobs_for_hyper_parameter_tuning_job
sagemaker_list_training_jobs_for_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName, NextToken = NULL, MaxResults = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL) {
  op <- new_operation(
    name = "ListTrainingJobsForHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName, NextToken = NextToken, MaxResults = MaxResults, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder)
  output <- .sagemaker$list_training_jobs_for_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_training_jobs_for_hyper_parameter_tuning_job <- sagemaker_list_training_jobs_for_hyper_parameter_tuning_job

#' Lists transform jobs
#'
#' Lists transform jobs.
#'
#' @usage
#' sagemaker_list_transform_jobs(CreationTimeAfter, CreationTimeBefore,
#'   LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
#'   StatusEquals, SortBy, SortOrder, NextToken, MaxResults)
#'
#' @param CreationTimeAfter A filter that returns only transform jobs created after the specified
#' time.
#' @param CreationTimeBefore A filter that returns only transform jobs created before the specified
#' time.
#' @param LastModifiedTimeAfter A filter that returns only transform jobs modified after the specified
#' time.
#' @param LastModifiedTimeBefore A filter that returns only transform jobs modified before the specified
#' time.
#' @param NameContains A string in the transform job name. This filter returns only transform
#' jobs whose name contains the specified string.
#' @param StatusEquals A filter that retrieves only transform jobs with a specific status.
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Descending`.
#' @param NextToken If the result of the previous `ListTransformJobs` request was truncated,
#' the response includes a `NextToken`. To retrieve the next set of
#' transform jobs, use the token in the next request.
#' @param MaxResults The maximum number of transform jobs to return in the response. The
#' default value is `10`.
#'
#' @section Request syntax:
#' ```
#' svc$list_transform_jobs(
#'   CreationTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   CreationTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeAfter = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   LastModifiedTimeBefore = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NameContains = "string",
#'   StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
#'   SortBy = "Name"|"CreationTime"|"Status",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_transform_jobs
sagemaker_list_transform_jobs <- function(CreationTimeAfter = NULL, CreationTimeBefore = NULL, LastModifiedTimeAfter = NULL, LastModifiedTimeBefore = NULL, NameContains = NULL, StatusEquals = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTransformJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_transform_jobs_input(CreationTimeAfter = CreationTimeAfter, CreationTimeBefore = CreationTimeBefore, LastModifiedTimeAfter = LastModifiedTimeAfter, LastModifiedTimeBefore = LastModifiedTimeBefore, NameContains = NameContains, StatusEquals = StatusEquals, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_transform_jobs_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_transform_jobs <- sagemaker_list_transform_jobs

#' Gets a list of work teams that you have defined in a region
#'
#' Gets a list of work teams that you have defined in a region. The list
#' may be empty if no work team satisfies the filter specified in the
#' `NameContains` parameter.
#'
#' @usage
#' sagemaker_list_workteams(SortBy, SortOrder, NameContains, NextToken,
#'   MaxResults)
#'
#' @param SortBy The field to sort results by. The default is `CreationTime`.
#' @param SortOrder The sort order for results. The default is `Ascending`.
#' @param NameContains A string in the work team\'s name. This filter returns only work teams
#' whose name contains the specified string.
#' @param NextToken If the result of the previous `ListWorkteams` request was truncated, the
#' response includes a `NextToken`. To retrieve the next set of labeling
#' jobs, use the token in the next request.
#' @param MaxResults The maximum number of work teams to return in each page of the response.
#'
#' @section Request syntax:
#' ```
#' svc$list_workteams(
#'   SortBy = "Name"|"CreateDate",
#'   SortOrder = "Ascending"|"Descending",
#'   NameContains = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_list_workteams
sagemaker_list_workteams <- function(SortBy = NULL, SortOrder = NULL, NameContains = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWorkteams",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$list_workteams_input(SortBy = SortBy, SortOrder = SortOrder, NameContains = NameContains, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$list_workteams_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$list_workteams <- sagemaker_list_workteams

#' Renders the UI template so that you can preview the worker's experience
#'
#' Renders the UI template so that you can preview the worker\'s
#' experience.
#'
#' @usage
#' sagemaker_render_ui_template(UiTemplate, Task, RoleArn)
#'
#' @param UiTemplate &#91;required&#93; A `Template` object containing the worker UI template to render.
#' @param Task &#91;required&#93; A `RenderableTask` object containing a representative task to render.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) that has access to the S3 objects that
#' are used by the template.
#'
#' @section Request syntax:
#' ```
#' svc$render_ui_template(
#'   UiTemplate = list(
#'     Content = "string"
#'   ),
#'   Task = list(
#'     Input = "string"
#'   ),
#'   RoleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_render_ui_template
sagemaker_render_ui_template <- function(UiTemplate, Task, RoleArn) {
  op <- new_operation(
    name = "RenderUiTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$render_ui_template_input(UiTemplate = UiTemplate, Task = Task, RoleArn = RoleArn)
  output <- .sagemaker$render_ui_template_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$render_ui_template <- sagemaker_render_ui_template

#' Finds Amazon SageMaker resources that match a search query
#'
#' Finds Amazon SageMaker resources that match a search query. Matching
#' resource objects are returned as a list of `SearchResult` objects in the
#' response. You can sort the search results by any resource property in a
#' ascending or descending order.
#' 
#' You can query against the following value types: numerical, text,
#' Booleans, and timestamps.
#'
#' @usage
#' sagemaker_search(Resource, SearchExpression, SortBy, SortOrder,
#'   NextToken, MaxResults)
#'
#' @param Resource &#91;required&#93; The name of the Amazon SageMaker resource to search for. Currently, the
#' only valid `Resource` value is `TrainingJob`.
#' @param SearchExpression A Boolean conditional statement. Resource objects must satisfy this
#' condition to be included in search results. You must provide at least
#' one subexpression, filter, or nested filter. The maximum number of
#' recursive `SubExpressions`, `NestedFilters`, and `Filters` that can be
#' included in a `SearchExpression` object is 50.
#' @param SortBy The name of the resource property used to sort the `SearchResults`. The
#' default is `LastModifiedTime`.
#' @param SortOrder How `SearchResults` are ordered. Valid values are `Ascending` or
#' `Descending`. The default is `Descending`.
#' @param NextToken If more than `MaxResults` resource objects match the specified
#' `SearchExpression`, the `SearchResponse` includes a `NextToken`. The
#' `NextToken` can be passed to the next `SearchRequest` to continue
#' retrieving results for the specified `SearchExpression` and `Sort`
#' parameters.
#' @param MaxResults The maximum number of results to return in a `SearchResponse`.
#'
#' @section Request syntax:
#' ```
#' svc$search(
#'   Resource = "TrainingJob",
#'   SearchExpression = list(
#'     Filters = list(
#'       list(
#'         Name = "string",
#'         Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains",
#'         Value = "string"
#'       )
#'     ),
#'     NestedFilters = list(
#'       list(
#'         NestedPropertyName = "string",
#'         Filters = list(
#'           list(
#'             Name = "string",
#'             Operator = "Equals"|"NotEquals"|"GreaterThan"|"GreaterThanOrEqualTo"|"LessThan"|"LessThanOrEqualTo"|"Contains",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     SubExpressions = list(
#'       list()
#'     ),
#'     Operator = "And"|"Or"
#'   ),
#'   SortBy = "string",
#'   SortOrder = "Ascending"|"Descending",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_search
sagemaker_search <- function(Resource, SearchExpression = NULL, SortBy = NULL, SortOrder = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$search_input(Resource = Resource, SearchExpression = SearchExpression, SortBy = SortBy, SortOrder = SortOrder, NextToken = NextToken, MaxResults = MaxResults)
  output <- .sagemaker$search_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$search <- sagemaker_search

#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume
#'
#' Launches an ML compute instance with the latest version of the libraries
#' and attaches your ML storage volume. After configuring the notebook
#' instance, Amazon SageMaker sets the notebook instance status to
#' `InService`. A notebook instance\'s status must be `InService` before
#' you can connect to your Jupyter notebook.
#'
#' @usage
#' sagemaker_start_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to start.
#'
#' @section Request syntax:
#' ```
#' svc$start_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_start_notebook_instance
sagemaker_start_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StartNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$start_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$start_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$start_notebook_instance <- sagemaker_start_notebook_instance

#' Stops a model compilation job
#'
#' Stops a model compilation job.
#' 
#' To stop a job, Amazon SageMaker sends the algorithm the SIGTERM signal.
#' This gracefully shuts the job down. If the job hasn\'t stopped, it sends
#' the SIGKILL signal.
#' 
#' When it receives a `StopCompilationJob` request, Amazon SageMaker
#' changes the CompilationJobSummary\\$CompilationJobStatus of the job to
#' `Stopping`. After Amazon SageMaker stops the job, it sets the
#' CompilationJobSummary\\$CompilationJobStatus to `Stopped`.
#'
#' @usage
#' sagemaker_stop_compilation_job(CompilationJobName)
#'
#' @param CompilationJobName &#91;required&#93; The name of the model compilation job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_compilation_job(
#'   CompilationJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_compilation_job
sagemaker_stop_compilation_job <- function(CompilationJobName) {
  op <- new_operation(
    name = "StopCompilationJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_compilation_job_input(CompilationJobName = CompilationJobName)
  output <- .sagemaker$stop_compilation_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_compilation_job <- sagemaker_stop_compilation_job

#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched
#'
#' Stops a running hyperparameter tuning job and all running training jobs
#' that the tuning job launched.
#' 
#' All model artifacts output from the training jobs are stored in Amazon
#' Simple Storage Service (Amazon S3). All data that the training jobs
#' write to Amazon CloudWatch Logs are still available in CloudWatch. After
#' the tuning job moves to the `Stopped` state, it releases all reserved
#' resources for the tuning job.
#'
#' @usage
#' sagemaker_stop_hyper_parameter_tuning_job(HyperParameterTuningJobName)
#'
#' @param HyperParameterTuningJobName &#91;required&#93; The name of the tuning job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_hyper_parameter_tuning_job(
#'   HyperParameterTuningJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_hyper_parameter_tuning_job
sagemaker_stop_hyper_parameter_tuning_job <- function(HyperParameterTuningJobName) {
  op <- new_operation(
    name = "StopHyperParameterTuningJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_hyper_parameter_tuning_job_input(HyperParameterTuningJobName = HyperParameterTuningJobName)
  output <- .sagemaker$stop_hyper_parameter_tuning_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_hyper_parameter_tuning_job <- sagemaker_stop_hyper_parameter_tuning_job

#' Stops a running labeling job
#'
#' Stops a running labeling job. A job that is stopped cannot be restarted.
#' Any results obtained before the job is stopped are placed in the Amazon
#' S3 output bucket.
#'
#' @usage
#' sagemaker_stop_labeling_job(LabelingJobName)
#'
#' @param LabelingJobName &#91;required&#93; The name of the labeling job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_labeling_job(
#'   LabelingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_labeling_job
sagemaker_stop_labeling_job <- function(LabelingJobName) {
  op <- new_operation(
    name = "StopLabelingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_labeling_job_input(LabelingJobName = LabelingJobName)
  output <- .sagemaker$stop_labeling_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_labeling_job <- sagemaker_stop_labeling_job

#' Terminates the ML compute instance
#'
#' Terminates the ML compute instance. Before terminating the instance,
#' Amazon SageMaker disconnects the ML storage volume from it. Amazon
#' SageMaker preserves the ML storage volume. Amazon SageMaker stops
#' charging you for the ML compute instance when you call
#' `StopNotebookInstance`.
#' 
#' To access data on the ML storage volume for a notebook instance that has
#' been terminated, call the `StartNotebookInstance` API.
#' `StartNotebookInstance` launches another ML compute instance, configures
#' it, and attaches the preserved ML storage volume so you can continue
#' your work.
#'
#' @usage
#' sagemaker_stop_notebook_instance(NotebookInstanceName)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to terminate.
#'
#' @section Request syntax:
#' ```
#' svc$stop_notebook_instance(
#'   NotebookInstanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_notebook_instance
sagemaker_stop_notebook_instance <- function(NotebookInstanceName) {
  op <- new_operation(
    name = "StopNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_notebook_instance_input(NotebookInstanceName = NotebookInstanceName)
  output <- .sagemaker$stop_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_notebook_instance <- sagemaker_stop_notebook_instance

#' Stops a training job
#'
#' Stops a training job. To stop a job, Amazon SageMaker sends the
#' algorithm the `SIGTERM` signal, which delays job termination for 120
#' seconds. Algorithms might use this 120-second window to save the model
#' artifacts, so the results of the training is not lost.
#' 
#' When it receives a `StopTrainingJob` request, Amazon SageMaker changes
#' the status of the job to `Stopping`. After Amazon SageMaker stops the
#' job, it sets the status to `Stopped`.
#'
#' @usage
#' sagemaker_stop_training_job(TrainingJobName)
#'
#' @param TrainingJobName &#91;required&#93; The name of the training job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_training_job(
#'   TrainingJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_training_job
sagemaker_stop_training_job <- function(TrainingJobName) {
  op <- new_operation(
    name = "StopTrainingJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_training_job_input(TrainingJobName = TrainingJobName)
  output <- .sagemaker$stop_training_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_training_job <- sagemaker_stop_training_job

#' Stops a transform job
#'
#' Stops a transform job.
#' 
#' When Amazon SageMaker receives a `StopTransformJob` request, the status
#' of the job changes to `Stopping`. After Amazon SageMaker stops the job,
#' the status is set to `Stopped`. When you stop a transform job before it
#' is completed, Amazon SageMaker doesn\'t store the job\'s output in
#' Amazon S3.
#'
#' @usage
#' sagemaker_stop_transform_job(TransformJobName)
#'
#' @param TransformJobName &#91;required&#93; The name of the transform job to stop.
#'
#' @section Request syntax:
#' ```
#' svc$stop_transform_job(
#'   TransformJobName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_stop_transform_job
sagemaker_stop_transform_job <- function(TransformJobName) {
  op <- new_operation(
    name = "StopTransformJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$stop_transform_job_input(TransformJobName = TransformJobName)
  output <- .sagemaker$stop_transform_job_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$stop_transform_job <- sagemaker_stop_transform_job

#' Updates the specified Git repository with the specified values
#'
#' Updates the specified Git repository with the specified values.
#'
#' @usage
#' sagemaker_update_code_repository(CodeRepositoryName, GitConfig)
#'
#' @param CodeRepositoryName &#91;required&#93; The name of the Git repository to update.
#' @param GitConfig The configuration of the git repository, including the URL and the
#' Amazon Resource Name (ARN) of the AWS Secrets Manager secret that
#' contains the credentials used to access the repository. The secret must
#' have a staging label of `AWSCURRENT` and must be in the following
#' format:
#' 
#' `\{"username": <i>UserName</i>, "password": <i>Password</i>\}`
#'
#' @section Request syntax:
#' ```
#' svc$update_code_repository(
#'   CodeRepositoryName = "string",
#'   GitConfig = list(
#'     SecretArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_code_repository
sagemaker_update_code_repository <- function(CodeRepositoryName, GitConfig = NULL) {
  op <- new_operation(
    name = "UpdateCodeRepository",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_code_repository_input(CodeRepositoryName = CodeRepositoryName, GitConfig = GitConfig)
  output <- .sagemaker$update_code_repository_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_code_repository <- sagemaker_update_code_repository

#' Deploys the new EndpointConfig specified in the request, switches to
#' using newly created endpoint, and then deletes resources provisioned for
#' the endpoint using the previous EndpointConfig (there is no availability
#' loss)
#'
#' Deploys the new `EndpointConfig` specified in the request, switches to
#' using newly created endpoint, and then deletes resources provisioned for
#' the endpoint using the previous `EndpointConfig` (there is no
#' availability loss).
#' 
#' When Amazon SageMaker receives the request, it sets the endpoint status
#' to `Updating`. After updating the endpoint, it sets the status to
#' `InService`. To check the status of an endpoint, use the
#' [DescribeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
#' API.
#' 
#' You must not delete an `EndpointConfig` in use by an endpoint that is
#' live or while the `UpdateEndpoint` or `CreateEndpoint` operations are
#' being performed on the endpoint. To update an endpoint, you must create
#' a new `EndpointConfig`.
#'
#' @usage
#' sagemaker_update_endpoint(EndpointName, EndpointConfigName)
#'
#' @param EndpointName &#91;required&#93; The name of the endpoint whose configuration you want to update.
#' @param EndpointConfigName &#91;required&#93; The name of the new endpoint configuration.
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint(
#'   EndpointName = "string",
#'   EndpointConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint
sagemaker_update_endpoint <- function(EndpointName, EndpointConfigName) {
  op <- new_operation(
    name = "UpdateEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_input(EndpointName = EndpointName, EndpointConfigName = EndpointConfigName)
  output <- .sagemaker$update_endpoint_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint <- sagemaker_update_endpoint

#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint
#'
#' Updates variant weight of one or more variants associated with an
#' existing endpoint, or capacity of one variant associated with an
#' existing endpoint. When it receives the request, Amazon SageMaker sets
#' the endpoint status to `Updating`. After updating the endpoint, it sets
#' the status to `InService`. To check the status of an endpoint, use the
#' [DescribeEndpoint](https://docs.aws.amazon.com/sagemaker/latest/dg/API_DescribeEndpoint.html)
#' API.
#'
#' @usage
#' sagemaker_update_endpoint_weights_and_capacities(EndpointName,
#'   DesiredWeightsAndCapacities)
#'
#' @param EndpointName &#91;required&#93; The name of an existing Amazon SageMaker endpoint.
#' @param DesiredWeightsAndCapacities &#91;required&#93; An object that provides new capacity and weight values for a variant.
#'
#' @section Request syntax:
#' ```
#' svc$update_endpoint_weights_and_capacities(
#'   EndpointName = "string",
#'   DesiredWeightsAndCapacities = list(
#'     list(
#'       VariantName = "string",
#'       DesiredWeight = 123.0,
#'       DesiredInstanceCount = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_endpoint_weights_and_capacities
sagemaker_update_endpoint_weights_and_capacities <- function(EndpointName, DesiredWeightsAndCapacities) {
  op <- new_operation(
    name = "UpdateEndpointWeightsAndCapacities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_endpoint_weights_and_capacities_input(EndpointName = EndpointName, DesiredWeightsAndCapacities = DesiredWeightsAndCapacities)
  output <- .sagemaker$update_endpoint_weights_and_capacities_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_endpoint_weights_and_capacities <- sagemaker_update_endpoint_weights_and_capacities

#' Updates a notebook instance
#'
#' Updates a notebook instance. NotebookInstance updates include upgrading
#' or downgrading the ML compute instance used for your notebook instance
#' to accommodate changes in your workload requirements.
#'
#' @usage
#' sagemaker_update_notebook_instance(NotebookInstanceName, InstanceType,
#'   RoleArn, LifecycleConfigName, DisassociateLifecycleConfig,
#'   VolumeSizeInGB, DefaultCodeRepository, AdditionalCodeRepositories,
#'   AcceleratorTypes, DisassociateAcceleratorTypes,
#'   DisassociateDefaultCodeRepository,
#'   DisassociateAdditionalCodeRepositories, RootAccess)
#'
#' @param NotebookInstanceName &#91;required&#93; The name of the notebook instance to update.
#' @param InstanceType The Amazon ML compute instance type.
#' @param RoleArn The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
#' assume to access the notebook instance. For more information, see
#' [Amazon SageMaker
#' Roles](https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html).
#' 
#' To be able to pass this role to Amazon SageMaker, the caller of this API
#' must have the `iam:PassRole` permission.
#' @param LifecycleConfigName The name of a lifecycle configuration to associate with the notebook
#' instance. For information about lifestyle configurations, see [Step 2.1:
#' (Optional) Customize a Notebook
#' Instance](https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html).
#' @param DisassociateLifecycleConfig Set to `true` to remove the notebook instance lifecycle configuration
#' currently associated with the notebook instance. This operation is
#' idempotent. If you specify a lifecycle configuration that is not
#' associated with the notebook instance when you call this method, it does
#' not throw an error.
#' @param VolumeSizeInGB The size, in GB, of the ML storage volume to attach to the notebook
#' instance. The default value is 5 GB. ML storage volumes are encrypted,
#' so Amazon SageMaker can\'t determine the amount of available free space
#' on the volume. Because of this, you can increase the volume size when
#' you update a notebook instance, but you can\'t decrease the volume size.
#' If you want to decrease the size of the ML storage volume in use, create
#' a new notebook instance with the desired size.
#' @param DefaultCodeRepository The Git repository to associate with the notebook instance as its
#' default code repository. This can be either the name of a Git repository
#' stored as a resource in your account, or the URL of a Git repository in
#' [AWS
#' CodeCommit](http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. When you open a notebook instance, it
#' opens in the directory that contains this repository. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AdditionalCodeRepositories An array of up to three Git repositories to associate with the notebook
#' instance. These can be either the names of Git repositories stored as
#' resources in your account, or the URL of Git repositories in [AWS
#' CodeCommit](http://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html)
#' or in any other Git repository. These repositories are cloned at the
#' same level as the default repository of your notebook instance. For more
#' information, see [Associating Git Repositories with Amazon SageMaker
#' Notebook
#' Instances](http://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html).
#' @param AcceleratorTypes A list of the Elastic Inference (EI) instance types to associate with
#' this notebook instance. Currently only one EI instance type can be
#' associated with a notebook instance. For more information, see [Using
#' Elastic Inference in Amazon
#' SageMaker](http://docs.aws.amazon.com/sagemaker/latest/dg/ei.html).
#' @param DisassociateAcceleratorTypes A list of the Elastic Inference (EI) instance types to remove from this
#' notebook instance. This operation is idempotent. If you specify an
#' accelerator type that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param DisassociateDefaultCodeRepository The name or URL of the default Git repository to remove from this
#' notebook instance. This operation is idempotent. If you specify a Git
#' repository that is not associated with the notebook instance when you
#' call this method, it does not throw an error.
#' @param DisassociateAdditionalCodeRepositories A list of names or URLs of the default Git repositories to remove from
#' this notebook instance. This operation is idempotent. If you specify a
#' Git repository that is not associated with the notebook instance when
#' you call this method, it does not throw an error.
#' @param RootAccess Whether root access is enabled or disabled for users of the notebook
#' instance. The default value is `Enabled`.
#' 
#' If you set this to `Disabled`, users don\'t have root access on the
#' notebook instance, but lifecycle configuration scripts still run with
#' root permissions.
#'
#' @section Request syntax:
#' ```
#' svc$update_notebook_instance(
#'   NotebookInstanceName = "string",
#'   InstanceType = "ml.t2.medium"|"ml.t2.large"|"ml.t2.xlarge"|"ml.t2.2xlarge"|"ml.t3.medium"|"ml.t3.large"|"ml.t3.xlarge"|"ml.t3.2xlarge"|"ml.m4.xlarge"|"ml.m4.2xlarge"|"ml.m4.4xlarge"|"ml.m4.10xlarge"|"ml.m4.16xlarge"|"ml.m5.xlarge"|"ml.m5.2xlarge"|"ml.m5.4xlarge"|"ml.m5.12xlarge"|"ml.m5.24xlarge"|"ml.c4.xlarge"|"ml.c4.2xlarge"|"ml.c4.4xlarge"|"ml.c4.8xlarge"|"ml.c5.xlarge"|"ml.c5.2xlarge"|"ml.c5.4xlarge"|"ml.c5.9xlarge"|"ml.c5.18xlarge"|"ml.c5d.xlarge"|"ml.c5d.2xlarge"|"ml.c5d.4xlarge"|"ml.c5d.9xlarge"|"ml.c5d.18xlarge"|"ml.p2.xlarge"|"ml.p2.8xlarge"|"ml.p2.16xlarge"|"ml.p3.2xlarge"|"ml.p3.8xlarge"|"ml.p3.16xlarge",
#'   RoleArn = "string",
#'   LifecycleConfigName = "string",
#'   DisassociateLifecycleConfig = TRUE|FALSE,
#'   VolumeSizeInGB = 123,
#'   DefaultCodeRepository = "string",
#'   AdditionalCodeRepositories = list(
#'     "string"
#'   ),
#'   AcceleratorTypes = list(
#'     "ml.eia1.medium"|"ml.eia1.large"|"ml.eia1.xlarge"
#'   ),
#'   DisassociateAcceleratorTypes = TRUE|FALSE,
#'   DisassociateDefaultCodeRepository = TRUE|FALSE,
#'   DisassociateAdditionalCodeRepositories = TRUE|FALSE,
#'   RootAccess = "Enabled"|"Disabled"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance
sagemaker_update_notebook_instance <- function(NotebookInstanceName, InstanceType = NULL, RoleArn = NULL, LifecycleConfigName = NULL, DisassociateLifecycleConfig = NULL, VolumeSizeInGB = NULL, DefaultCodeRepository = NULL, AdditionalCodeRepositories = NULL, AcceleratorTypes = NULL, DisassociateAcceleratorTypes = NULL, DisassociateDefaultCodeRepository = NULL, DisassociateAdditionalCodeRepositories = NULL, RootAccess = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_input(NotebookInstanceName = NotebookInstanceName, InstanceType = InstanceType, RoleArn = RoleArn, LifecycleConfigName = LifecycleConfigName, DisassociateLifecycleConfig = DisassociateLifecycleConfig, VolumeSizeInGB = VolumeSizeInGB, DefaultCodeRepository = DefaultCodeRepository, AdditionalCodeRepositories = AdditionalCodeRepositories, AcceleratorTypes = AcceleratorTypes, DisassociateAcceleratorTypes = DisassociateAcceleratorTypes, DisassociateDefaultCodeRepository = DisassociateDefaultCodeRepository, DisassociateAdditionalCodeRepositories = DisassociateAdditionalCodeRepositories, RootAccess = RootAccess)
  output <- .sagemaker$update_notebook_instance_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance <- sagemaker_update_notebook_instance

#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API
#'
#' Updates a notebook instance lifecycle configuration created with the
#' CreateNotebookInstanceLifecycleConfig API.
#'
#' @usage
#' sagemaker_update_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName, OnCreate, OnStart)
#'
#' @param NotebookInstanceLifecycleConfigName &#91;required&#93; The name of the lifecycle configuration.
#' @param OnCreate The shell script that runs only once, when you create a notebook
#' instance
#' @param OnStart The shell script that runs every time you start a notebook instance,
#' including when you create the notebook instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_notebook_instance_lifecycle_config(
#'   NotebookInstanceLifecycleConfigName = "string",
#'   OnCreate = list(
#'     list(
#'       Content = "string"
#'     )
#'   ),
#'   OnStart = list(
#'     list(
#'       Content = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_notebook_instance_lifecycle_config
sagemaker_update_notebook_instance_lifecycle_config <- function(NotebookInstanceLifecycleConfigName, OnCreate = NULL, OnStart = NULL) {
  op <- new_operation(
    name = "UpdateNotebookInstanceLifecycleConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_notebook_instance_lifecycle_config_input(NotebookInstanceLifecycleConfigName = NotebookInstanceLifecycleConfigName, OnCreate = OnCreate, OnStart = OnStart)
  output <- .sagemaker$update_notebook_instance_lifecycle_config_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_notebook_instance_lifecycle_config <- sagemaker_update_notebook_instance_lifecycle_config

#' Updates an existing work team with new member definitions or description
#'
#' Updates an existing work team with new member definitions or
#' description.
#'
#' @usage
#' sagemaker_update_workteam(WorkteamName, MemberDefinitions, Description,
#'   NotificationConfiguration)
#'
#' @param WorkteamName &#91;required&#93; The name of the work team to update.
#' @param MemberDefinitions A list of `MemberDefinition` objects that contain the updated work team
#' members.
#' @param Description An updated description for the work team.
#' @param NotificationConfiguration Configures SNS topic notifications for available or expiring work items
#'
#' @section Request syntax:
#' ```
#' svc$update_workteam(
#'   WorkteamName = "string",
#'   MemberDefinitions = list(
#'     list(
#'       CognitoMemberDefinition = list(
#'         UserPool = "string",
#'         UserGroup = "string",
#'         ClientId = "string"
#'       )
#'     )
#'   ),
#'   Description = "string",
#'   NotificationConfiguration = list(
#'     NotificationTopicArn = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname sagemaker_update_workteam
sagemaker_update_workteam <- function(WorkteamName, MemberDefinitions = NULL, Description = NULL, NotificationConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateWorkteam",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .sagemaker$update_workteam_input(WorkteamName = WorkteamName, MemberDefinitions = MemberDefinitions, Description = Description, NotificationConfiguration = NotificationConfiguration)
  output <- .sagemaker$update_workteam_output()
  config <- get_config()
  svc <- .sagemaker$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemaker$operations$update_workteam <- sagemaker_update_workteam
