% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_batch_inference_job}
\alias{personalize_create_batch_inference_job}
\title{Creates a batch inference job}
\usage{
personalize_create_batch_inference_job(jobName, solutionVersionArn,
  numResults, jobInput, jobOutput, roleArn)
}
\arguments{
\item{jobName}{[required] The name of the batch inference job to create.}

\item{solutionVersionArn}{[required] The Amazon Resource Name (ARN) of the solution version that will be used
to generate the batch inference recommendations.}

\item{numResults}{The number of recommendations to retreive.}

\item{jobInput}{[required] The Amazon S3 path that leads to the input file to base your
recommendations on. The input material must be in JSON format.}

\item{jobOutput}{[required] The path to the Amazon S3 bucket where the job\'s output will be stored.}

\item{roleArn}{[required] The ARN of the Amazon Identity and Access Management role that has
permissions to read and write to your input and out Amazon S3 buckets
respectively.}
}
\description{
Creates a batch inference job. The operation can handle up to 50 million
records and the input file must be in JSON format. For more information,
see recommendations-batch.
}
\section{Request syntax}{
\preformatted{svc$create_batch_inference_job(
  jobName = "string",
  solutionVersionArn = "string",
  numResults = 123,
  jobInput = list(
    s3DataSource = list(
      path = "string",
      kmsKeyArn = "string"
    )
  ),
  jobOutput = list(
    s3DataDestination = list(
      path = "string",
      kmsKeyArn = "string"
    )
  ),
  roleArn = "string"
)
}
}

\keyword{internal}
