% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_text_detection}
\alias{rekognition_start_text_detection}
\title{Starts asynchronous detection of text in a stored video}
\usage{
rekognition_start_text_detection(Video, ClientRequestToken,
  NotificationChannel, JobTag, Filters)
}
\arguments{
\item{Video}{[required]}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple \code{StartTextDetection} requests, the same \code{JobId} is
returned. Use \code{ClientRequestToken} to prevent the same job from being
accidentaly started more than once.}

\item{NotificationChannel}{}

\item{JobTag}{An identifier returned in the completion status published by your Amazon
Simple Notification Service topic. For example, you can use \code{JobTag} to
group related jobs and identify them in the completion notification.}

\item{Filters}{Optional parameters that let you set criteria the text must meet to be
included in your response.}
}
\description{
Starts asynchronous detection of text in a stored video.
}
\details{
Amazon Rekognition Video can detect text in a video stored in an Amazon
S3 bucket. Use Video to specify the bucket name and the filename of the
video. \code{StartTextDetection} returns a job identifier (\code{JobId}) which you
use to get the results of the operation. When text detection is
finished, Amazon Rekognition Video publishes a completion status to the
Amazon Simple Notification Service topic that you specify in
\code{NotificationChannel}.

To get the results of the text detection operation, first check that the
status value published to the Amazon SNS topic is \code{SUCCEEDED}. if so,
call GetTextDetection and pass the job identifier (\code{JobId}) from the
initial call to \code{StartTextDetection}.
}
\section{Request syntax}{
\preformatted{svc$start_text_detection(
  Video = list(
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  ClientRequestToken = "string",
  NotificationChannel = list(
    SNSTopicArn = "string",
    RoleArn = "string"
  ),
  JobTag = "string",
  Filters = list(
    WordFilter = list(
      MinConfidence = 123.0,
      MinBoundingBoxHeight = 123.0,
      MinBoundingBoxWidth = 123.0
    ),
    RegionsOfInterest = list(
      list(
        BoundingBox = list(
          Width = 123.0,
          Height = 123.0,
          Left = 123.0,
          Top = 123.0
        )
      )
    )
  )
)
}
}

\keyword{internal}
