% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_labels}
\alias{rekognition_detect_labels}
\title{Detects instances of real-world entities within an image (JPEG or PNG)
provided as input}
\usage{
rekognition_detect_labels(Image, MaxLabels = NULL, MinConfidence = NULL)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing image bytes is
not supported. Images stored in an S3 Bucket do not need to be
base64-encoded.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MaxLabels}{Maximum number of labels you want the service to return in the response.
The service returns the specified number of highest confidence labels.}

\item{MinConfidence}{Specifies the minimum confidence level for the labels to return. Amazon
Rekognition doesn't return any labels with confidence lower than this
specified value.

If \code{MinConfidence} is not specified, the operation returns labels with a
confidence values greater than or equal to 55 percent.}
}
\description{
Detects instances of real-world entities within an image (JPEG or PNG) provided as input. This includes objects like flower, tree, and table; events like wedding, graduation, and birthday party; and concepts like landscape, evening, and nature.

See \url{https://paws-r.github.io/docs/rekognition/detect_labels.html} for full documentation.
}
\keyword{internal}
