# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Translate
#'
#' @description
#' Provides translation of the input content from the source language to
#' the target language.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- translate(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- translate()
#' svc$create_parallel_data(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=translate_create_parallel_data]{create_parallel_data} \tab Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3\cr
#'  \link[=translate_delete_parallel_data]{delete_parallel_data} \tab Deletes a parallel data resource in Amazon Translate\cr
#'  \link[=translate_delete_terminology]{delete_terminology} \tab A synchronous action that deletes a custom terminology\cr
#'  \link[=translate_describe_text_translation_job]{describe_text_translation_job} \tab Gets the properties associated with an asynchronous batch translation job including name, ID, status, source and target languages, input/output S3 buckets, and so on\cr
#'  \link[=translate_get_parallel_data]{get_parallel_data} \tab Provides information about a parallel data resource\cr
#'  \link[=translate_get_terminology]{get_terminology} \tab Retrieves a custom terminology\cr
#'  \link[=translate_import_terminology]{import_terminology} \tab Creates or updates a custom terminology, depending on whether one already exists for the given terminology name\cr
#'  \link[=translate_list_languages]{list_languages} \tab Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports\cr
#'  \link[=translate_list_parallel_data]{list_parallel_data} \tab Provides a list of your parallel data resources in Amazon Translate\cr
#'  \link[=translate_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with a given Amazon Translate resource\cr
#'  \link[=translate_list_terminologies]{list_terminologies} \tab Provides a list of custom terminologies associated with your account\cr
#'  \link[=translate_list_text_translation_jobs]{list_text_translation_jobs} \tab Gets a list of the batch translation jobs that you have submitted\cr
#'  \link[=translate_start_text_translation_job]{start_text_translation_job} \tab Starts an asynchronous batch translation job\cr
#'  \link[=translate_stop_text_translation_job]{stop_text_translation_job} \tab Stops an asynchronous batch translation job that is in progress\cr
#'  \link[=translate_tag_resource]{tag_resource} \tab Associates a specific tag with a resource\cr
#'  \link[=translate_translate_document]{translate_document} \tab Translates the input document from the source language to the target language\cr
#'  \link[=translate_translate_text]{translate_text} \tab Translates input text from the source language to the target language\cr
#'  \link[=translate_untag_resource]{untag_resource} \tab Removes a specific tag associated with an Amazon Translate resource\cr
#'  \link[=translate_update_parallel_data]{update_parallel_data} \tab Updates a previously created parallel data resource by importing a new input file from Amazon S3
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname translate
#' @export
translate <- function(config = list()) {
  svc <- .translate$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.translate <- list()

.translate$operations <- list()

.translate$metadata <- list(
  service_name = "translate",
  endpoints = list("*" = list(endpoint = "translate.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "translate.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "translate.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "translate.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Translate",
  api_version = "2017-07-01",
  signing_name = "translate",
  json_version = "1.1",
  target_prefix = "AWSShineFrontendService_20170701"
)

.translate$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.translate$metadata, handlers, config)
}
