% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_stop_inference_experiment}
\alias{sagemaker_stop_inference_experiment}
\title{Stops an inference experiment}
\usage{
sagemaker_stop_inference_experiment(
  Name,
  ModelVariantActions,
  DesiredModelVariants = NULL,
  DesiredState = NULL,
  Reason = NULL
)
}
\arguments{
\item{Name}{[required] The name of the inference experiment to stop.}

\item{ModelVariantActions}{[required] Array of key-value pairs, with names of variants mapped to actions. The
possible actions are the following:
\itemize{
\item \code{Promote} - Promote the shadow variant to a production variant
\item \code{Remove} - Delete the variant
\item \code{Retain} - Keep the variant as it is
}}

\item{DesiredModelVariants}{An array of \code{ModelVariantConfig} objects. There is one for each variant
that you want to deploy after the inference experiment stops. Each
\code{ModelVariantConfig} describes the infrastructure configuration for
deploying the corresponding variant.}

\item{DesiredState}{The desired state of the experiment after stopping. The possible states
are the following:
\itemize{
\item \code{Completed}: The experiment completed successfully
\item \code{Cancelled}: The experiment was canceled
}}

\item{Reason}{The reason for stopping the experiment.}
}
\description{
Stops an inference experiment.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_stop_inference_experiment/} for full documentation.
}
\keyword{internal}
