% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscalingplans_operations.R
\name{autoscalingplans_describe_scaling_plan_resources}
\alias{autoscalingplans_describe_scaling_plan_resources}
\title{Describes the scalable resources in the specified scaling plan}
\usage{
autoscalingplans_describe_scaling_plan_resources(ScalingPlanName,
  ScalingPlanVersion, MaxResults, NextToken)
}
\arguments{
\item{ScalingPlanName}{[required] The name of the scaling plan.}

\item{ScalingPlanVersion}{[required] The version number of the scaling plan.}

\item{MaxResults}{The maximum number of scalable resources to return. The value must be
between 1 and 50. The default value is 50.}

\item{NextToken}{The token for the next set of results.}
}
\description{
Describes the scalable resources in the specified scaling plan.
}
\section{Request syntax}{
\preformatted{svc$describe_scaling_plan_resources(
  ScalingPlanName = "string",
  ScalingPlanVersion = 123,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
