% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_execute_change_set}
\alias{cloudformation_execute_change_set}
\title{Updates a stack using the input information that was provided when the
specified change set was created}
\usage{
cloudformation_execute_change_set(ChangeSetName, StackName,
  ClientRequestToken)
}
\arguments{
\item{ChangeSetName}{[required] The name or ARN of the change set that you want use to update the
specified stack.}

\item{StackName}{If you specified the name of a change set, specify the stack name or ID
(ARN) that is associated with the change set you want to execute.}

\item{ClientRequestToken}{A unique identifier for this \code{ExecuteChangeSet} request. Specify this
token if you plan to retry requests so that AWS CloudFormation knows
that you're not attempting to execute a change set to update a stack
with the same name. You might retry \code{ExecuteChangeSet} requests to
ensure that AWS CloudFormation successfully received them.}
}
\description{
Updates a stack using the input information that was provided when the
specified change set was created. After the call successfully completes,
AWS CloudFormation starts updating the stack. Use the DescribeStacks
action to view the status of the update.
}
\details{
When you execute a change set, AWS CloudFormation deletes all other
change sets associated with the stack because they aren't valid for the
updated stack.

If a stack policy is associated with the stack, AWS CloudFormation
enforces the policy during the update. You can't specify a temporary
stack policy that overrides the current policy.
}
\section{Request syntax}{
\preformatted{svc$execute_change_set(
  ChangeSetName = "string",
  StackName = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
