% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_tag_resource}
\alias{cloudwatchevents_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified CloudWatch
Events resource}
\usage{
cloudwatchevents_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch Events rule that you're adding tags to.}

\item{Tags}{[required] The list of key-value pairs to associate with the rule.}
}
\description{
Assigns one or more tags (key-value pairs) to the specified CloudWatch
Events resource. Tags can help you organize and categorize your
resources. You can also use them to scope user permissions by granting a
user permission to access or change only resources with certain tag
values. In CloudWatch Events, rules can be tagged.
}
\details{
Tags don't have any semantic meaning to AWS and are interpreted
strictly as strings of characters.

You can use the \code{TagResource} action with a rule that already has tags.
If you specify a new tag key for the rule, this tag is appended to the
list of tags associated with the rule. If you specify a tag key that is
already associated with the rule, the new tag value that you specify
replaces the previous value for that tag.

You can associate as many as 50 tags with a resource.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  ResourceARN = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
