# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include organizations_service.R
NULL

#' Sends a response to the originator of a handshake agreeing to the action
#' proposed by the handshake request
#'
#' @description
#' Sends a response to the originator of a handshake agreeing to the action
#' proposed by the handshake request.
#' 
#' This operation can be called only by the following principals when they
#' also have the relevant IAM permissions:
#' 
#' -   **Invitation to join** or **Approve all features request**
#'     handshakes: only a principal from the member account.
#' 
#'     The user who calls the API for an invitation to join must have the
#'     `organizations:AcceptHandshake` permission. If you enabled all
#'     features in the organization, the user must also have the
#'     `iam:CreateServiceLinkedRole` permission so that AWS Organizations
#'     can create the required service-linked role named
#'     `AWSServiceRoleForOrganizations`. For more information, see [AWS
#'     Organizations and Service-Linked
#'     Roles](https://docs.aws.amazon.com/organizations/latest/userguide/#orgs_integration_service-linked-roles)
#'     in the *AWS Organizations User Guide*.
#' 
#' -   **Enable all features final confirmation** handshake: only a
#'     principal from the management account.
#' 
#'     For more information about invitations, see [Inviting an AWS Account
#'     to Join Your
#'     Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_invites.html)
#'     in the *AWS Organizations User Guide.* For more information about
#'     requests to enable all features in the organization, see [Enabling
#'     All Features in Your
#'     Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
#'     in the *AWS Organizations User Guide.*
#' 
#' After you accept a handshake, it continues to appear in the results of
#' relevant APIs for only 30 days. After that, it's deleted.
#'
#' @usage
#' organizations_accept_handshake(HandshakeId)
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to accept.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @section Request syntax:
#' ```
#' svc$accept_handshake(
#'   HandshakeId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Bill is the owner of an organization, and he invites Juan's account
#' # (222222222222) to join his organization. The following example shows
#' # Juan's account accepting the handshake and thus agreeing to the
#' # invitation.
#' svc$accept_handshake(
#'   HandshakeId = "h-examplehandshakeid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_accept_handshake
organizations_accept_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "AcceptHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$accept_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$accept_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$accept_handshake <- organizations_accept_handshake

#' Attaches a policy to a root, an organizational unit (OU), or an
#' individual account
#'
#' @description
#' Attaches a policy to a root, an organizational unit (OU), or an
#' individual account. How the policy affects accounts depends on the type
#' of policy. Refer to the *AWS Organizations User Guide* for information
#' about each policy type:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_attach_policy(PolicyId, TargetId)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to attach to the
#' target. You can get the ID for the policy by calling the ListPolicies
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, OU, or account that you want to
#' attach the policy to. You can get the ID by calling the ListRoots,
#' ListOrganizationalUnitsForParent, or ListAccounts operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$attach_policy(
#'   PolicyId = "string",
#'   TargetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to attach a service control policy (SCP)
#' # to an OU:
#' # 
#' svc$attach_policy(
#'   PolicyId = "p-examplepolicyid111",
#'   TargetId = "ou-examplerootid111-exampleouid111"
#' )
#' 
#' # The following example shows how to attach a service control policy (SCP)
#' # to an account:
#' # 
#' svc$attach_policy(
#'   PolicyId = "p-examplepolicyid111",
#'   TargetId = "333333333333"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_attach_policy
organizations_attach_policy <- function(PolicyId, TargetId) {
  op <- new_operation(
    name = "AttachPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$attach_policy_input(PolicyId = PolicyId, TargetId = TargetId)
  output <- .organizations$attach_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$attach_policy <- organizations_attach_policy

#' Cancels a handshake
#'
#' @description
#' Cancels a handshake. Canceling a handshake sets the handshake state to
#' `CANCELED`.
#' 
#' This operation can be called only from the account that originated the
#' handshake. The recipient of the handshake can't cancel it, but can use
#' DeclineHandshake instead. After a handshake is canceled, the recipient
#' can no longer respond to that handshake.
#' 
#' After you cancel a handshake, it continues to appear in the results of
#' relevant APIs for only 30 days. After that, it's deleted.
#'
#' @usage
#' organizations_cancel_handshake(HandshakeId)
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to cancel. You
#' can get the ID from the ListHandshakesForOrganization operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_handshake(
#'   HandshakeId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Bill previously sent an invitation to Susan's account to join his
#' # organization. He changes his mind and decides to cancel the invitation
#' # before Susan accepts it. The following example shows Bill's
#' # cancellation:
#' # 
#' svc$cancel_handshake(
#'   HandshakeId = "h-examplehandshakeid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_cancel_handshake
organizations_cancel_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "CancelHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$cancel_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$cancel_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$cancel_handshake <- organizations_cancel_handshake

#' Creates an AWS account that is automatically a member of the
#' organization whose credentials made the request
#'
#' @description
#' Creates an AWS account that is automatically a member of the
#' organization whose credentials made the request. This is an asynchronous
#' request that AWS performs in the background. Because `CreateAccount`
#' operates asynchronously, it can return a successful completion message
#' even though account initialization might still be in progress. You might
#' need to wait a few minutes before you can successfully access the
#' account. To check the status of the request, do one of the following:
#' 
#' -   Use the `Id` member of the `CreateAccountStatus` response element
#'     from this operation to provide as a parameter to the
#'     DescribeCreateAccountStatus operation.
#' 
#' -   Check the AWS CloudTrail log for the `CreateAccountResult` event.
#'     For information on using AWS CloudTrail with AWS Organizations, see
#'     [Monitoring the Activity in Your
#'     Organization](https://docs.aws.amazon.com/organizations/latest/userguide/)
#'     in the *AWS Organizations User Guide.*
#' 
#' The user who calls the API to create an account must have the
#' `organizations:CreateAccount` permission. If you enabled all features in
#' the organization, AWS Organizations creates the required service-linked
#' role named `AWSServiceRoleForOrganizations`. For more information, see
#' [AWS Organizations and Service-Linked
#' Roles](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs)
#' in the *AWS Organizations User Guide*.
#' 
#' If the request includes tags, then the requester must have the
#' `organizations:TagResource` permission.
#' 
#' AWS Organizations preconfigures the new member account with a role
#' (named `OrganizationAccountAccessRole` by default) that grants users in
#' the management account administrator permissions in the new member
#' account. Principals in the management account can assume the role. AWS
#' Organizations clones the company name and address information for the
#' new account from the organization's management account.
#' 
#' This operation can be called only from the organization's management
#' account.
#' 
#' For more information about creating accounts, see [Creating an AWS
#' Account in Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html)
#' in the *AWS Organizations User Guide.*
#' 
#' -   When you create an account in an organization using the AWS
#'     Organizations console, API, or CLI commands, the information
#'     required for the account to operate as a standalone account, such as
#'     a payment method and signing the end user license agreement (EULA)
#'     is *not* automatically collected. If you must remove an account from
#'     your organization later, you can do so only after you provide the
#'     missing information. Follow the steps at [To leave an organization
#'     as a member
#'     account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
#'     in the *AWS Organizations User Guide*.
#' 
#' -   If you get an exception that indicates that you exceeded your
#'     account limits for the organization, contact AWS Support.
#' 
#' -   If you get an exception that indicates that the operation failed
#'     because your organization is still initializing, wait one hour and
#'     then try again. If the error persists, contact AWS Support.
#' 
#' -   Using `CreateAccount` to create multiple temporary accounts isn't
#'     recommended. You can only close an account from the Billing and Cost
#'     Management Console, and you must be signed in as the root user. For
#'     information on the requirements and process for closing an account,
#'     see [Closing an AWS
#'     Account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html)
#'     in the *AWS Organizations User Guide*.
#' 
#' When you create a member account with this operation, you can choose
#' whether to create the account with the **IAM User and Role Access to
#' Billing Information** switch enabled. If you enable it, IAM users and
#' roles that have appropriate permissions can view billing information for
#' the account. If you disable it, only the account root user can access
#' billing information. For information about how to disable this switch
#' for an account, see [Granting Access to Your Billing Information and
#' Tools](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html).
#'
#' @usage
#' organizations_create_account(Email, AccountName, RoleName,
#'   IamUserAccessToBilling, Tags)
#'
#' @param Email &#91;required&#93; The email address of the owner to assign to the new member account. This
#' email address must not already be associated with another AWS account.
#' You must use a valid email address to complete account creation. You
#' can't access the root user of the account or remove an account that was
#' created with an invalid email address.
#' @param AccountName &#91;required&#93; The friendly name of the member account.
#' @param RoleName (Optional)
#' 
#' The name of an IAM role that AWS Organizations automatically
#' preconfigures in the new member account. This role trusts the management
#' account, allowing users in the management account to assume the role, as
#' permitted by the management account administrator. The role has
#' administrator permissions in the new member account.
#' 
#' If you don't specify this parameter, the role name defaults to
#' `OrganizationAccountAccessRole`.
#' 
#' For more information about how to use this role to access the member
#' account, see the following links:
#' 
#' -   [Accessing and Administering the Member Accounts in Your
#'     Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
#'     in the *AWS Organizations User Guide*
#' 
#' -   Steps 2 and 3 in [Tutorial: Delegate Access Across AWS Accounts
#'     Using IAM
#'     Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
#'     in the *IAM User Guide*
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter. The pattern can include uppercase letters,
#' lowercase letters, digits with no spaces, and any of the following
#' characters: =,.@@-
#' @param IamUserAccessToBilling If set to `ALLOW`, the new account enables IAM users to access account
#' billing information *if* they have the required permissions. If set to
#' `DENY`, only the root user of the new account can access account billing
#' information. For more information, see [Activating Access to the Billing
#' and Cost Management
#' Console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#ControllingAccessWebsite-Activate)
#' in the *AWS Billing and Cost Management User Guide*.
#' 
#' If you don't specify this parameter, the value defaults to `ALLOW`, and
#' IAM users and roles with the required permissions can access billing
#' information for the new account.
#' @param Tags A list of tags that you want to attach to the newly created account. For
#' each tag in the list, you must specify both a tag key and a value. You
#' can set the value to an empty string, but you can't set it to `null`.
#' For more information about tagging, see [Tagging AWS Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the AWS Organizations User Guide.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for an account, then the entire request fails and the account is
#' not created.
#'
#' @section Request syntax:
#' ```
#' svc$create_account(
#'   Email = "string",
#'   AccountName = "string",
#'   RoleName = "string",
#'   IamUserAccessToBilling = "ALLOW"|"DENY",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The owner of an organization creates a member account in the
#' # organization. The following example shows that when the organization
#' # owner creates the member account, the account is preconfigured with the
#' # name "Production Account" and an owner email address of
#' # susan@example.com.  An IAM role is automatically created using the
#' # default name because the roleName parameter is not used. AWS
#' # Organizations sends Susan a "Welcome to AWS" email:
#' # 
#' # 
#' svc$create_account(
#'   AccountName = "Production Account",
#'   Email = "susan@example.com"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_create_account
organizations_create_account <- function(Email, AccountName, RoleName = NULL, IamUserAccessToBilling = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_account_input(Email = Email, AccountName = AccountName, RoleName = RoleName, IamUserAccessToBilling = IamUserAccessToBilling, Tags = Tags)
  output <- .organizations$create_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_account <- organizations_create_account

#' This action is available if all of the following are true: - You're
#' authorized to create accounts in the AWS GovCloud (US) Region
#'
#' @description
#' This action is available if all of the following are true:
#' 
#' -   You're authorized to create accounts in the AWS GovCloud (US)
#'     Region. For more information on the AWS GovCloud (US) Region, see
#'     the [*AWS GovCloud User
#'     Guide*.](https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/welcome.html)
#' 
#' -   You already have an account in the AWS GovCloud (US) Region that is
#'     paired with a management account of an organization in the
#'     commercial Region.
#' 
#' -   You call this action from the management account of your
#'     organization in the commercial Region.
#' 
#' -   You have the `organizations:CreateGovCloudAccount` permission.
#' 
#' AWS Organizations automatically creates the required service-linked role
#' named `AWSServiceRoleForOrganizations`. For more information, see [AWS
#' Organizations and Service-Linked
#' Roles](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html#orgs_integrate_services-using_slrs)
#' in the *AWS Organizations User Guide.*
#' 
#' AWS automatically enables AWS CloudTrail for AWS GovCloud (US) accounts,
#' but you should also do the following:
#' 
#' -   Verify that AWS CloudTrail is enabled to store logs.
#' 
#' -   Create an S3 bucket for AWS CloudTrail log storage.
#' 
#'     For more information, see [Verifying AWS CloudTrail Is
#'     Enabled](https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/verifying-cloudtrail.html)
#'     in the *AWS GovCloud User Guide*.
#' 
#' If the request includes tags, then the requester must have the
#' `organizations:TagResource` permission. The tags are attached to the
#' commercial account associated with the GovCloud account, rather than the
#' GovCloud account itself. To add tags to the GovCloud account, call the
#' TagResource operation in the GovCloud Region after the new GovCloud
#' account exists.
#' 
#' You call this action from the management account of your organization in
#' the commercial Region to create a standalone AWS account in the AWS
#' GovCloud (US) Region. After the account is created, the management
#' account of an organization in the AWS GovCloud (US) Region can invite it
#' to that organization. For more information on inviting standalone
#' accounts in the AWS GovCloud (US) to join an organization, see [AWS
#' Organizations](https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
#' in the *AWS GovCloud User Guide.*
#' 
#' Calling `CreateGovCloudAccount` is an asynchronous request that AWS
#' performs in the background. Because `CreateGovCloudAccount` operates
#' asynchronously, it can return a successful completion message even
#' though account initialization might still be in progress. You might need
#' to wait a few minutes before you can successfully access the account. To
#' check the status of the request, do one of the following:
#' 
#' -   Use the `OperationId` response element from this operation to
#'     provide as a parameter to the DescribeCreateAccountStatus operation.
#' 
#' -   Check the AWS CloudTrail log for the `CreateAccountResult` event.
#'     For information on using AWS CloudTrail with Organizations, see
#'     [Monitoring the Activity in Your
#'     Organization](https://docs.aws.amazon.com/organizations/latest/userguide/)
#'     in the *AWS Organizations User Guide.*
#' 
#' When you call the `CreateGovCloudAccount` action, you create two
#' accounts: a standalone account in the AWS GovCloud (US) Region and an
#' associated account in the commercial Region for billing and support
#' purposes. The account in the commercial Region is automatically a member
#' of the organization whose credentials made the request. Both accounts
#' are associated with the same email address.
#' 
#' A role is created in the new account in the commercial Region that
#' allows the management account in the organization in the commercial
#' Region to assume it. An AWS GovCloud (US) account is then created and
#' associated with the commercial account that you just created. A role is
#' also created in the new AWS GovCloud (US) account that can be assumed by
#' the AWS GovCloud (US) account that is associated with the management
#' account of the commercial organization. For more information and to view
#' a diagram that explains how account access works, see [AWS
#' Organizations](https://docs.aws.amazon.com/govcloud-us/latest/UserGuide/govcloud-organizations.html)
#' in the *AWS GovCloud User Guide.*
#' 
#' For more information about creating accounts, see [Creating an AWS
#' Account in Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_create.html)
#' in the *AWS Organizations User Guide.*
#' 
#' -   When you create an account in an organization using the AWS
#'     Organizations console, API, or CLI commands, the information
#'     required for the account to operate as a standalone account is *not*
#'     automatically collected. This includes a payment method and signing
#'     the end user license agreement (EULA). If you must remove an account
#'     from your organization later, you can do so only after you provide
#'     the missing information. Follow the steps at [To leave an
#'     organization as a member
#'     account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
#'     in the *AWS Organizations User Guide.*
#' 
#' -   If you get an exception that indicates that you exceeded your
#'     account limits for the organization, contact AWS Support.
#' 
#' -   If you get an exception that indicates that the operation failed
#'     because your organization is still initializing, wait one hour and
#'     then try again. If the error persists, contact AWS Support.
#' 
#' -   Using `CreateGovCloudAccount` to create multiple temporary accounts
#'     isn't recommended. You can only close an account from the AWS
#'     Billing and Cost Management console, and you must be signed in as
#'     the root user. For information on the requirements and process for
#'     closing an account, see [Closing an AWS
#'     Account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_close.html)
#'     in the *AWS Organizations User Guide*.
#' 
#' When you create a member account with this operation, you can choose
#' whether to create the account with the **IAM User and Role Access to
#' Billing Information** switch enabled. If you enable it, IAM users and
#' roles that have appropriate permissions can view billing information for
#' the account. If you disable it, only the account root user can access
#' billing information. For information about how to disable this switch
#' for an account, see [Granting Access to Your Billing Information and
#' Tools](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html).
#'
#' @usage
#' organizations_create_gov_cloud_account(Email, AccountName, RoleName,
#'   IamUserAccessToBilling, Tags)
#'
#' @param Email &#91;required&#93; The email address of the owner to assign to the new member account in
#' the commercial Region. This email address must not already be associated
#' with another AWS account. You must use a valid email address to complete
#' account creation. You can't access the root user of the account or
#' remove an account that was created with an invalid email address. Like
#' all request parameters for `CreateGovCloudAccount`, the request for the
#' email address for the AWS GovCloud (US) account originates from the
#' commercial Region, not from the AWS GovCloud (US) Region.
#' @param AccountName &#91;required&#93; The friendly name of the member account.
#' @param RoleName (Optional)
#' 
#' The name of an IAM role that AWS Organizations automatically
#' preconfigures in the new member accounts in both the AWS GovCloud (US)
#' Region and in the commercial Region. This role trusts the management
#' account, allowing users in the management account to assume the role, as
#' permitted by the management account administrator. The role has
#' administrator permissions in the new member account.
#' 
#' If you don't specify this parameter, the role name defaults to
#' `OrganizationAccountAccessRole`.
#' 
#' For more information about how to use this role to access the member
#' account, see [Accessing and Administering the Member Accounts in Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_access.html#orgs_manage_accounts_create-cross-account-role)
#' in the *AWS Organizations User Guide* and steps 2 and 3 in [Tutorial:
#' Delegate Access Across AWS Accounts Using IAM
#' Roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/tutorial_cross-account-with-roles.html)
#' in the *IAM User Guide.*
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter. The pattern can include uppercase letters,
#' lowercase letters, digits with no spaces, and any of the following
#' characters: =,.@@-
#' @param IamUserAccessToBilling If set to `ALLOW`, the new linked account in the commercial Region
#' enables IAM users to access account billing information *if* they have
#' the required permissions. If set to `DENY`, only the root user of the
#' new account can access account billing information. For more
#' information, see [Activating Access to the Billing and Cost Management
#' Console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#ControllingAccessWebsite-Activate)
#' in the *AWS Billing and Cost Management User Guide.*
#' 
#' If you don't specify this parameter, the value defaults to `ALLOW`, and
#' IAM users and roles with the required permissions can access billing
#' information for the new account.
#' @param Tags A list of tags that you want to attach to the newly created account.
#' These tags are attached to the commercial account associated with the
#' GovCloud account, and not to the GovCloud account itself. To add tags to
#' the actual GovCloud account, call the TagResource operation in the
#' GovCloud region after the new GovCloud account exists.
#' 
#' For each tag in the list, you must specify both a tag key and a value.
#' You can set the value to an empty string, but you can't set it to
#' `null`. For more information about tagging, see [Tagging AWS
#' Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the AWS Organizations User Guide.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for an account, then the entire request fails and the account is
#' not created.
#'
#' @section Request syntax:
#' ```
#' svc$create_gov_cloud_account(
#'   Email = "string",
#'   AccountName = "string",
#'   RoleName = "string",
#'   IamUserAccessToBilling = "ALLOW"|"DENY",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_create_gov_cloud_account
organizations_create_gov_cloud_account <- function(Email, AccountName, RoleName = NULL, IamUserAccessToBilling = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateGovCloudAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_gov_cloud_account_input(Email = Email, AccountName = AccountName, RoleName = RoleName, IamUserAccessToBilling = IamUserAccessToBilling, Tags = Tags)
  output <- .organizations$create_gov_cloud_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_gov_cloud_account <- organizations_create_gov_cloud_account

#' Creates an AWS organization
#'
#' @description
#' Creates an AWS organization. The account whose user is calling the
#' `CreateOrganization` operation automatically becomes the [management
#' account](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account)
#' of the new organization.
#' 
#' This operation must be called using credentials from the account that is
#' to become the new organization's management account. The principal must
#' also have the relevant IAM permissions.
#' 
#' By default (or if you set the `FeatureSet` parameter to `ALL`), the new
#' organization is created with all features enabled and service control
#' policies automatically enabled in the root. If you instead choose to
#' create the organization supporting only the consolidated billing
#' features by setting the `FeatureSet` parameter to
#' `CONSOLIDATED_BILLING\"`, no policy types are enabled by default, and
#' you can't use organization policies
#'
#' @usage
#' organizations_create_organization(FeatureSet)
#'
#' @param FeatureSet Specifies the feature set supported by the new organization. Each
#' feature set supports different levels of functionality.
#' 
#' -   `CONSOLIDATED_BILLING`: All member accounts have their bills
#'     consolidated to and paid by the management account. For more
#'     information, see [Consolidated
#'     billing](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only)
#'     in the *AWS Organizations User Guide.*
#' 
#'     The consolidated billing feature subset isn't available for
#'     organizations in the AWS GovCloud (US) Region.
#' 
#' -   `ALL`: In addition to all the features supported by the consolidated
#'     billing feature set, the management account can also apply any
#'     policy type to any member account in the organization. For more
#'     information, see [All
#'     features](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all)
#'     in the *AWS Organizations User Guide.*
#'
#' @section Request syntax:
#' ```
#' svc$create_organization(
#'   FeatureSet = "ALL"|"CONSOLIDATED_BILLING"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Bill wants to create an organization using credentials from account
#' # 111111111111. The following example shows that the account becomes the
#' # master account in the new organization. Because he does not specify a
#' # feature set, the new organization defaults to all features enabled and
#' # service control policies enabled on the root:
#' # 
#' # 
#' svc$create_organization()
#' 
#' # In the following example, Bill creates an organization using credentials
#' # from account 111111111111, and configures the organization to support
#' # only the consolidated billing feature set:
#' # 
#' # 
#' svc$create_organization(
#'   FeatureSet = "CONSOLIDATED_BILLING"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_create_organization
organizations_create_organization <- function(FeatureSet = NULL) {
  op <- new_operation(
    name = "CreateOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_organization_input(FeatureSet = FeatureSet)
  output <- .organizations$create_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_organization <- organizations_create_organization

#' Creates an organizational unit (OU) within a root or parent OU
#'
#' @description
#' Creates an organizational unit (OU) within a root or parent OU. An OU is
#' a container for accounts that enables you to organize your accounts to
#' apply policies according to your business requirements. The number of
#' levels deep that you can nest OUs is dependent upon the policy types
#' enabled for that root. For service control policies, the limit is five.
#' 
#' For more information about OUs, see [Managing Organizational
#' Units](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_ous.html)
#' in the *AWS Organizations User Guide.*
#' 
#' If the request includes tags, then the requester must have the
#' `organizations:TagResource` permission.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_create_organizational_unit(ParentId, Name, Tags)
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) of the parent root or OU that you want to
#' create the new OU in.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param Name &#91;required&#93; The friendly name to assign to the new OU.
#' @param Tags A list of tags that you want to attach to the newly created OU. For each
#' tag in the list, you must specify both a tag key and a value. You can
#' set the value to an empty string, but you can't set it to `null`. For
#' more information about tagging, see [Tagging AWS Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the AWS Organizations User Guide.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for an OU, then the entire request fails and the OU is not created.
#'
#' @section Request syntax:
#' ```
#' svc$create_organizational_unit(
#'   ParentId = "string",
#'   Name = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to create an OU that is named
#' # AccountingOU. The new OU is directly under the root.:
#' # 
#' # 
#' svc$create_organizational_unit(
#'   Name = "AccountingOU",
#'   ParentId = "r-examplerootid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_create_organizational_unit
organizations_create_organizational_unit <- function(ParentId, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_organizational_unit_input(ParentId = ParentId, Name = Name, Tags = Tags)
  output <- .organizations$create_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_organizational_unit <- organizations_create_organizational_unit

#' Creates a policy of a specified type that you can attach to a root, an
#' organizational unit (OU), or an individual AWS account
#'
#' @description
#' Creates a policy of a specified type that you can attach to a root, an
#' organizational unit (OU), or an individual AWS account.
#' 
#' For more information about policies and their use, see [Managing
#' Organization
#' Policies](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html).
#' 
#' If the request includes tags, then the requester must have the
#' `organizations:TagResource` permission.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_create_policy(Content, Description, Name, Type, Tags)
#'
#' @param Content &#91;required&#93; The policy text content to add to the new policy. The text that you
#' supply must adhere to the rules of the policy type you specify in the
#' `Type` parameter.
#' @param Description &#91;required&#93; An optional description to assign to the policy.
#' @param Name &#91;required&#93; The friendly name to assign to the policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#' @param Type &#91;required&#93; The type of policy to create. You can specify one of the following
#' values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param Tags A list of tags that you want to attach to the newly created policy. For
#' each tag in the list, you must specify both a tag key and a value. You
#' can set the value to an empty string, but you can't set it to `null`.
#' For more information about tagging, see [Tagging AWS Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the AWS Organizations User Guide.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for a policy, then the entire request fails and the policy is not
#' created.
#'
#' @section Request syntax:
#' ```
#' svc$create_policy(
#'   Content = "string",
#'   Description = "string",
#'   Name = "string",
#'   Type = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to create a service control policy (SCP)
#' # that is named AllowAllS3Actions. The JSON string in the content
#' # parameter specifies the content in the policy. The parameter string is
#' # escaped with backslashes to ensure that the embedded double quotes in
#' # the JSON policy are treated as literals in the parameter, which itself
#' # is surrounded by double quotes:
#' # 
#' # 
#' svc$create_policy(
#'   Content = "\{\\\"Version\\\":\\\"2012-10-17\\\",\\\"Statement\\\":\{\\\"Effect\\\":...",
#'   Description = "Enables admins of attached accounts to delegate all S3 permissions",
#'   Name = "AllowAllS3Actions",
#'   Type = "SERVICE_CONTROL_POLICY"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_create_policy
organizations_create_policy <- function(Content, Description, Name, Type, Tags = NULL) {
  op <- new_operation(
    name = "CreatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$create_policy_input(Content = Content, Description = Description, Name = Name, Type = Type, Tags = Tags)
  output <- .organizations$create_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$create_policy <- organizations_create_policy

#' Declines a handshake request
#'
#' @description
#' Declines a handshake request. This sets the handshake state to
#' `DECLINED` and effectively deactivates the request.
#' 
#' This operation can be called only from the account that received the
#' handshake. The originator of the handshake can use CancelHandshake
#' instead. The originator can't reactivate a declined request, but can
#' reinitiate the process with a new handshake request.
#' 
#' After you decline a handshake, it continues to appear in the results of
#' relevant APIs for only 30 days. After that, it's deleted.
#'
#' @usage
#' organizations_decline_handshake(HandshakeId)
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want to decline.
#' You can get the ID from the ListHandshakesForAccount operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @section Request syntax:
#' ```
#' svc$decline_handshake(
#'   HandshakeId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows Susan declining an invitation to join Bill's
#' # organization. The DeclineHandshake operation returns a handshake object,
#' # showing that the state is now DECLINED:
#' svc$decline_handshake(
#'   HandshakeId = "h-examplehandshakeid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_decline_handshake
organizations_decline_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "DeclineHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$decline_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$decline_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$decline_handshake <- organizations_decline_handshake

#' Deletes the organization
#'
#' @description
#' Deletes the organization. You can delete an organization only by using
#' credentials from the management account. The organization must be empty
#' of member accounts.
#'
#' @usage
#' organizations_delete_organization()
#'

#'

#'
#' @keywords internal
#'
#' @rdname organizations_delete_organization
organizations_delete_organization <- function() {
  op <- new_operation(
    name = "DeleteOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_organization_input()
  output <- .organizations$delete_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_organization <- organizations_delete_organization

#' Deletes an organizational unit (OU) from a root or another OU
#'
#' @description
#' Deletes an organizational unit (OU) from a root or another OU. You must
#' first remove all accounts and child OUs from the OU that you want to
#' delete.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_delete_organizational_unit(OrganizationalUnitId)
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the organizational unit that you want to
#' delete. You can get the ID from the ListOrganizationalUnitsForParent
#' operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$delete_organizational_unit(
#'   OrganizationalUnitId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to delete an OU. The example assumes
#' # that you previously removed all accounts and other OUs from the OU:
#' # 
#' # 
#' svc$delete_organizational_unit(
#'   OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_delete_organizational_unit
organizations_delete_organizational_unit <- function(OrganizationalUnitId) {
  op <- new_operation(
    name = "DeleteOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId)
  output <- .organizations$delete_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_organizational_unit <- organizations_delete_organizational_unit

#' Deletes the specified policy from your organization
#'
#' @description
#' Deletes the specified policy from your organization. Before you perform
#' this operation, you must first detach the policy from all organizational
#' units (OUs), roots, and accounts.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_delete_policy(PolicyId)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to delete. You
#' can get the ID from the ListPolicies or ListPoliciesForTarget
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy(
#'   PolicyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to delete a policy from an organization.
#' # The example assumes that you previously detached the policy from all
#' # entities:
#' # 
#' # 
#' svc$delete_policy(
#'   PolicyId = "p-examplepolicyid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_delete_policy
organizations_delete_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$delete_policy_input(PolicyId = PolicyId)
  output <- .organizations$delete_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$delete_policy <- organizations_delete_policy

#' Removes the specified member AWS account as a delegated administrator
#' for the specified AWS service
#'
#' @description
#' Removes the specified member AWS account as a delegated administrator
#' for the specified AWS service.
#' 
#' Deregistering a delegated administrator can have unintended impacts on
#' the functionality of the enabled AWS service. See the documentation for
#' the enabled service before you deregister a delegated administrator so
#' that you understand any potential impacts.
#' 
#' You can run this action only for AWS services that support this feature.
#' For a current list of services that support it, see the column *Supports
#' Delegated Administrator* in the table at [AWS Services that you can use
#' with AWS
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_deregister_delegated_administrator(AccountId,
#'   ServicePrincipal)
#'
#' @param AccountId &#91;required&#93; The account ID number of the member account in the organization that you
#' want to deregister as a delegated administrator.
#' @param ServicePrincipal &#91;required&#93; The service principal name of an AWS service for which the account is a
#' delegated administrator.
#' 
#' Delegated administrator privileges are revoked for only the specified
#' AWS service from the member account. If the specified service is the
#' only service for which the member account is a delegated administrator,
#' the operation also revokes Organizations read action permissions.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_delegated_administrator(
#'   AccountId = "string",
#'   ServicePrincipal = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_deregister_delegated_administrator
organizations_deregister_delegated_administrator <- function(AccountId, ServicePrincipal) {
  op <- new_operation(
    name = "DeregisterDelegatedAdministrator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$deregister_delegated_administrator_input(AccountId = AccountId, ServicePrincipal = ServicePrincipal)
  output <- .organizations$deregister_delegated_administrator_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$deregister_delegated_administrator <- organizations_deregister_delegated_administrator

#' Retrieves AWS Organizations-related information about the specified
#' account
#'
#' @description
#' Retrieves AWS Organizations-related information about the specified
#' account.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_describe_account(AccountId)
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the AWS account that you want information
#' about. You can get the ID from the ListAccounts or ListAccountsForParent
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#'
#' @section Request syntax:
#' ```
#' svc$describe_account(
#'   AccountId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows a user in the master account (111111111111)
#' # asking for details about account 555555555555:
#' svc$describe_account(
#'   AccountId = "555555555555"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_account
organizations_describe_account <- function(AccountId) {
  op <- new_operation(
    name = "DescribeAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_account_input(AccountId = AccountId)
  output <- .organizations$describe_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_account <- organizations_describe_account

#' Retrieves the current status of an asynchronous request to create an
#' account
#'
#' @description
#' Retrieves the current status of an asynchronous request to create an
#' account.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_describe_create_account_status(CreateAccountRequestId)
#'
#' @param CreateAccountRequestId &#91;required&#93; Specifies the `Id` value that uniquely identifies the `CreateAccount`
#' request. You can get the value from the `CreateAccountStatus.Id`
#' response in an earlier CreateAccount request, or from the
#' ListCreateAccountStatus operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a create
#' account request ID string requires "car-" followed by from 8 to 32
#' lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$describe_create_account_status(
#'   CreateAccountRequestId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to request the status about a previous
#' # request to create an account in an organization. This operation can be
#' # called only by a principal from the organization's master account. In
#' # the example, the specified "createAccountRequestId" comes from the
#' # response of the original call to "CreateAccount":
#' svc$describe_create_account_status(
#'   CreateAccountRequestId = "car-exampleaccountcreationrequestid"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_create_account_status
organizations_describe_create_account_status <- function(CreateAccountRequestId) {
  op <- new_operation(
    name = "DescribeCreateAccountStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_create_account_status_input(CreateAccountRequestId = CreateAccountRequestId)
  output <- .organizations$describe_create_account_status_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_create_account_status <- organizations_describe_create_account_status

#' Returns the contents of the effective policy for specified policy type
#' and account
#'
#' @description
#' Returns the contents of the effective policy for specified policy type
#' and account. The effective policy is the aggregation of any policies of
#' the specified type that the account inherits, plus any policy of that
#' type that is directly attached to the account.
#' 
#' This operation applies only to policy types *other* than service control
#' policies (SCPs).
#' 
#' For more information about policy inheritance, see [How Policy
#' Inheritance
#' Works](https://docs.aws.amazon.com/organizations/latest/userguide/) in
#' the *AWS Organizations User Guide*.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_describe_effective_policy(PolicyType, TargetId)
#'
#' @param PolicyType &#91;required&#93; The type of policy that you want information about. You can specify one
#' of the following values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param TargetId When you're signed in as the management account, specify the ID of the
#' account that you want details about. Specifying an organization root or
#' organizational unit (OU) as the target is not supported.
#'
#' @section Request syntax:
#' ```
#' svc$describe_effective_policy(
#'   PolicyType = "TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
#'   TargetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_describe_effective_policy
organizations_describe_effective_policy <- function(PolicyType, TargetId = NULL) {
  op <- new_operation(
    name = "DescribeEffectivePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_effective_policy_input(PolicyType = PolicyType, TargetId = TargetId)
  output <- .organizations$describe_effective_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_effective_policy <- organizations_describe_effective_policy

#' Retrieves information about a previously requested handshake
#'
#' @description
#' Retrieves information about a previously requested handshake. The
#' handshake ID comes from the response to the original
#' InviteAccountToOrganization operation that generated the handshake.
#' 
#' You can access handshakes that are `ACCEPTED`, `DECLINED`, or `CANCELED`
#' for only 30 days after they change to that state. They're then deleted
#' and no longer accessible.
#' 
#' This operation can be called from any account in the organization.
#'
#' @usage
#' organizations_describe_handshake(HandshakeId)
#'
#' @param HandshakeId &#91;required&#93; The unique identifier (ID) of the handshake that you want information
#' about. You can get the ID from the original call to
#' InviteAccountToOrganization, or from a call to ListHandshakesForAccount
#' or ListHandshakesForOrganization.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for handshake
#' ID string requires "h-" followed by from 8 to 32 lowercase letters or
#' digits.
#'
#' @section Request syntax:
#' ```
#' svc$describe_handshake(
#'   HandshakeId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows you how to request details about a
#' # handshake. The handshake ID comes either from the original call to
#' # "InviteAccountToOrganization", or from a call to
#' # "ListHandshakesForAccount" or "ListHandshakesForOrganization":
#' svc$describe_handshake(
#'   HandshakeId = "h-examplehandshakeid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_handshake
organizations_describe_handshake <- function(HandshakeId) {
  op <- new_operation(
    name = "DescribeHandshake",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_handshake_input(HandshakeId = HandshakeId)
  output <- .organizations$describe_handshake_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_handshake <- organizations_describe_handshake

#' Retrieves information about the organization that the user's account
#' belongs to
#'
#' @description
#' Retrieves information about the organization that the user's account
#' belongs to.
#' 
#' This operation can be called from any account in the organization.
#' 
#' Even if a policy type is shown as available in the organization, you can
#' disable it separately at the root level with DisablePolicyType. Use
#' ListRoots to see the status of policy types for a specified root.
#'
#' @usage
#' organizations_describe_organization()
#'

#'

#'
#' @examples
#' \dontrun{
#' # The following example shows how to request information about the current
#' # user's organization:/n/n
#' svc$describe_organization()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_organization
organizations_describe_organization <- function() {
  op <- new_operation(
    name = "DescribeOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_organization_input()
  output <- .organizations$describe_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_organization <- organizations_describe_organization

#' Retrieves information about an organizational unit (OU)
#'
#' @description
#' Retrieves information about an organizational unit (OU).
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_describe_organizational_unit(OrganizationalUnitId)
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the organizational unit that you want
#' details about. You can get the ID from the
#' ListOrganizationalUnitsForParent operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$describe_organizational_unit(
#'   OrganizationalUnitId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to request details about an OU:/n/n
#' svc$describe_organizational_unit(
#'   OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_organizational_unit
organizations_describe_organizational_unit <- function(OrganizationalUnitId) {
  op <- new_operation(
    name = "DescribeOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId)
  output <- .organizations$describe_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_organizational_unit <- organizations_describe_organizational_unit

#' Retrieves information about a policy
#'
#' @description
#' Retrieves information about a policy.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_describe_policy(PolicyId)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want details about.
#' You can get the ID from the ListPolicies or ListPoliciesForTarget
#' operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#'
#' @section Request syntax:
#' ```
#' svc$describe_policy(
#'   PolicyId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to request information about a
#' # policy:/n/n
#' svc$describe_policy(
#'   PolicyId = "p-examplepolicyid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_describe_policy
organizations_describe_policy <- function(PolicyId) {
  op <- new_operation(
    name = "DescribePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$describe_policy_input(PolicyId = PolicyId)
  output <- .organizations$describe_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$describe_policy <- organizations_describe_policy

#' Detaches a policy from a target root, organizational unit (OU), or
#' account
#'
#' @description
#' Detaches a policy from a target root, organizational unit (OU), or
#' account.
#' 
#' If the policy being detached is a service control policy (SCP), the
#' changes to permissions for AWS Identity and Access Management (IAM)
#' users and roles in affected accounts are immediate.
#' 
#' Every root, OU, and account must have at least one SCP attached. If you
#' want to replace the default `FullAWSAccess` policy with an SCP that
#' limits the permissions that can be delegated, you must attach the
#' replacement SCP before you can remove the default SCP. This is the
#' authorization strategy of an "[allow
#' list](https://docs.aws.amazon.com/organizations/latest/userguide/#orgs_policies_allowlist)".
#' If you instead attach a second SCP and leave the `FullAWSAccess` SCP
#' still attached, and specify `"Effect": "Deny"` in the second SCP to
#' override the `"Effect": "Allow"` in the `FullAWSAccess` policy (or any
#' other attached SCP), you're using the authorization strategy of a "[deny
#' list](https://docs.aws.amazon.com/organizations/latest/userguide/#orgs_policies_denylist)".
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_detach_policy(PolicyId, TargetId)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy you want to detach. You can get
#' the ID from the ListPolicies or ListPoliciesForTarget operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, OU, or account that you want to
#' detach the policy from. You can get the ID from the ListRoots,
#' ListOrganizationalUnitsForParent, or ListAccounts operations.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$detach_policy(
#'   PolicyId = "string",
#'   TargetId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to detach a policy from an OU:/n/n
#' svc$detach_policy(
#'   PolicyId = "p-examplepolicyid111",
#'   TargetId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_detach_policy
organizations_detach_policy <- function(PolicyId, TargetId) {
  op <- new_operation(
    name = "DetachPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$detach_policy_input(PolicyId = PolicyId, TargetId = TargetId)
  output <- .organizations$detach_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$detach_policy <- organizations_detach_policy

#' Disables the integration of an AWS service (the service that is
#' specified by ServicePrincipal) with AWS Organizations
#'
#' @description
#' Disables the integration of an AWS service (the service that is
#' specified by `ServicePrincipal`) with AWS Organizations. When you
#' disable integration, the specified service no longer can create a
#' [service-linked
#' role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
#' in *new* accounts in your organization. This means the service can't
#' perform operations on your behalf on any new accounts in your
#' organization. The service can still perform operations in older accounts
#' until the service completes its clean-up from AWS Organizations.
#' 
#' We recommend that you disable integration between AWS Organizations and
#' the specified AWS service by using the console or commands that are
#' provided by the specified service. Doing so ensures that the other
#' service is aware that it can clean up any resources that are required
#' only for the integration. How the service cleans up its resources in the
#' organization's accounts depends on that service. For more information,
#' see the documentation for the other AWS service.
#' 
#' After you perform the `DisableAWSServiceAccess` operation, the specified
#' service can no longer perform operations in your organization's accounts
#' unless the operations are explicitly permitted by the IAM policies that
#' are attached to your roles.
#' 
#' For more information about integrating other services with AWS
#' Organizations, including the list of services that work with
#' Organizations, see [Integrating AWS Organizations with Other AWS
#' Services](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_disable_aws_service_access(ServicePrincipal)
#'
#' @param ServicePrincipal &#91;required&#93; The service principal name of the AWS service for which you want to
#' disable integration with your organization. This is typically in the
#' form of a URL, such as ` <i>service-abbreviation</i>.amazonaws.com`.
#'
#' @section Request syntax:
#' ```
#' svc$disable_aws_service_access(
#'   ServicePrincipal = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_disable_aws_service_access
organizations_disable_aws_service_access <- function(ServicePrincipal) {
  op <- new_operation(
    name = "DisableAWSServiceAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$disable_aws_service_access_input(ServicePrincipal = ServicePrincipal)
  output <- .organizations$disable_aws_service_access_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$disable_aws_service_access <- organizations_disable_aws_service_access

#' Disables an organizational policy type in a root
#'
#' @description
#' Disables an organizational policy type in a root. A policy of a certain
#' type can be attached to entities in a root only if that type is enabled
#' in the root. After you perform this operation, you no longer can attach
#' policies of the specified type to that root or to any organizational
#' unit (OU) or account in that root. You can undo this by using the
#' EnablePolicyType operation.
#' 
#' This is an asynchronous request that AWS performs in the background. If
#' you disable a policy type for a root, it still appears enabled for the
#' organization if [all
#' features](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
#' are enabled for the organization. AWS recommends that you first use
#' ListRoots to see the status of policy types for a specified root, and
#' then use this operation.
#' 
#' This operation can be called only from the organization's management
#' account.
#' 
#' To view the status of available policy types in the organization, use
#' DescribeOrganization.
#'
#' @usage
#' organizations_disable_policy_type(RootId, PolicyType)
#'
#' @param RootId &#91;required&#93; The unique identifier (ID) of the root in which you want to disable a
#' policy type. You can get the ID from the ListRoots operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a root ID
#' string requires "r-" followed by from 4 to 32 lowercase letters or
#' digits.
#' @param PolicyType &#91;required&#93; The policy type that you want to disable in this root. You can specify
#' one of the following values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#'
#' @section Request syntax:
#' ```
#' svc$disable_policy_type(
#'   RootId = "string",
#'   PolicyType = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to disable the service control policy
#' # (SCP) policy type in a root. The response shows that the PolicyTypes
#' # response element no longer includes SERVICE_CONTROL_POLICY:/n/n
#' svc$disable_policy_type(
#'   PolicyType = "SERVICE_CONTROL_POLICY",
#'   RootId = "r-examplerootid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_disable_policy_type
organizations_disable_policy_type <- function(RootId, PolicyType) {
  op <- new_operation(
    name = "DisablePolicyType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$disable_policy_type_input(RootId = RootId, PolicyType = PolicyType)
  output <- .organizations$disable_policy_type_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$disable_policy_type <- organizations_disable_policy_type

#' Enables the integration of an AWS service (the service that is specified
#' by ServicePrincipal) with AWS Organizations
#'
#' @description
#' Enables the integration of an AWS service (the service that is specified
#' by `ServicePrincipal`) with AWS Organizations. When you enable
#' integration, you allow the specified service to create a [service-linked
#' role](https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html)
#' in all the accounts in your organization. This allows the service to
#' perform operations on your behalf in your organization and its accounts.
#' 
#' We recommend that you enable integration between AWS Organizations and
#' the specified AWS service by using the console or commands that are
#' provided by the specified service. Doing so ensures that the service is
#' aware that it can create the resources that are required for the
#' integration. How the service creates those resources in the
#' organization's accounts depends on that service. For more information,
#' see the documentation for the other AWS service.
#' 
#' For more information about enabling services to integrate with AWS
#' Organizations, see [Integrating AWS Organizations with Other AWS
#' Services](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation can be called only from the organization's management
#' account and only if the organization has [enabled all
#' features](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html).
#'
#' @usage
#' organizations_enable_aws_service_access(ServicePrincipal)
#'
#' @param ServicePrincipal &#91;required&#93; The service principal name of the AWS service for which you want to
#' enable integration with your organization. This is typically in the form
#' of a URL, such as ` <i>service-abbreviation</i>.amazonaws.com`.
#'
#' @section Request syntax:
#' ```
#' svc$enable_aws_service_access(
#'   ServicePrincipal = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_enable_aws_service_access
organizations_enable_aws_service_access <- function(ServicePrincipal) {
  op <- new_operation(
    name = "EnableAWSServiceAccess",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_aws_service_access_input(ServicePrincipal = ServicePrincipal)
  output <- .organizations$enable_aws_service_access_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_aws_service_access <- organizations_enable_aws_service_access

#' Enables all features in an organization
#'
#' @description
#' Enables all features in an organization. This enables the use of
#' organization policies that can restrict the services and actions that
#' can be called in each account. Until you enable all features, you have
#' access only to consolidated billing, and you can't use any of the
#' advanced account administration features that AWS Organizations
#' supports. For more information, see [Enabling All Features in Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation is required only for organizations that were created
#' explicitly with only the consolidated billing features enabled. Calling
#' this operation sends a handshake to every invited account in the
#' organization. The feature set change can be finalized and the additional
#' features enabled only after all administrators in the invited accounts
#' approve the change by accepting the handshake.
#' 
#' After you enable all features, you can separately enable or disable
#' individual policy types in a root using EnablePolicyType and
#' DisablePolicyType. To see the status of policy types in a root, use
#' ListRoots.
#' 
#' After all invited member accounts accept the handshake, you finalize the
#' feature set change by accepting the handshake that contains
#' `"Action": "ENABLE_ALL_FEATURES"`. This completes the change.
#' 
#' After you enable all features in your organization, the management
#' account in the organization can apply policies on all member accounts.
#' These policies can restrict what users and even administrators in those
#' accounts can do. The management account can apply policies that prevent
#' accounts from leaving the organization. Ensure that your account
#' administrators are aware of this.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_enable_all_features()
#'
#' @section Request syntax:
#' ```
#' svc$enable_all_features()
#' ```
#'
#' @examples
#' \dontrun{
#' # This example shows the administrator asking all the invited accounts in
#' # the organization to approve enabling all features in the organization.
#' # AWS Organizations sends an email to the address that is registered with
#' # every invited member account asking the owner to approve the change by
#' # accepting the handshake that is sent. After all invited member accounts
#' # accept the handshake, the organization administrator can finalize the
#' # change to enable all features, and those with appropriate permissions
#' # can create policies and apply them to roots, OUs, and accounts:/n/n
#' svc$enable_all_features()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_enable_all_features
organizations_enable_all_features <- function() {
  op <- new_operation(
    name = "EnableAllFeatures",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_all_features_input()
  output <- .organizations$enable_all_features_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_all_features <- organizations_enable_all_features

#' Enables a policy type in a root
#'
#' @description
#' Enables a policy type in a root. After you enable a policy type in a
#' root, you can attach policies of that type to the root, any
#' organizational unit (OU), or account in that root. You can undo this by
#' using the DisablePolicyType operation.
#' 
#' This is an asynchronous request that AWS performs in the background. AWS
#' recommends that you first use ListRoots to see the status of policy
#' types for a specified root, and then use this operation.
#' 
#' This operation can be called only from the organization's management
#' account.
#' 
#' You can enable a policy type in a root only if that policy type is
#' available in the organization. To view the status of available policy
#' types in the organization, use DescribeOrganization.
#'
#' @usage
#' organizations_enable_policy_type(RootId, PolicyType)
#'
#' @param RootId &#91;required&#93; The unique identifier (ID) of the root in which you want to enable a
#' policy type. You can get the ID from the ListRoots operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a root ID
#' string requires "r-" followed by from 4 to 32 lowercase letters or
#' digits.
#' @param PolicyType &#91;required&#93; The policy type that you want to enable. You can specify one of the
#' following values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#'
#' @section Request syntax:
#' ```
#' svc$enable_policy_type(
#'   RootId = "string",
#'   PolicyType = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to enable the service control policy
#' # (SCP) policy type in a root. The output shows a root object with a
#' # PolicyTypes response element showing that SCPs are now enabled:/n/n
#' svc$enable_policy_type(
#'   PolicyType = "SERVICE_CONTROL_POLICY",
#'   RootId = "r-examplerootid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_enable_policy_type
organizations_enable_policy_type <- function(RootId, PolicyType) {
  op <- new_operation(
    name = "EnablePolicyType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$enable_policy_type_input(RootId = RootId, PolicyType = PolicyType)
  output <- .organizations$enable_policy_type_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$enable_policy_type <- organizations_enable_policy_type

#' Sends an invitation to another account to join your organization as a
#' member account
#'
#' @description
#' Sends an invitation to another account to join your organization as a
#' member account. AWS Organizations sends email on your behalf to the
#' email address that is associated with the other account's owner. The
#' invitation is implemented as a Handshake whose details are in the
#' response.
#' 
#' -   You can invite AWS accounts only from the same seller as the
#'     management account. For example, if your organization's management
#'     account was created by Amazon Internet Services Pvt. Ltd (AISPL), an
#'     AWS seller in India, you can invite only other AISPL accounts to
#'     your organization. You can't combine accounts from AISPL and AWS or
#'     from any other AWS seller. For more information, see [Consolidated
#'     Billing in
#'     India](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/).
#' 
#' -   If you receive an exception that indicates that you exceeded your
#'     account limits for the organization or that the operation failed
#'     because your organization is still initializing, wait one hour and
#'     then try again. If the error persists after an hour, contact AWS
#'     Support.
#' 
#' If the request includes tags, then the requester must have the
#' `organizations:TagResource` permission.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_invite_account_to_organization(Target, Notes, Tags)
#'
#' @param Target &#91;required&#93; The identifier (ID) of the AWS account that you want to invite to join
#' your organization. This is a JSON object that contains the following
#' elements:
#' 
#' `\{ "Type": "ACCOUNT", "Id": "&lt;<i> <b>account id number</b> </i>&gt;" \}`
#' 
#' If you use the AWS CLI, you can submit this as a single string, similar
#' to the following example:
#' 
#' `--target Id=123456789012,Type=ACCOUNT`
#' 
#' If you specify `"Type": "ACCOUNT"`, you must provide the AWS account ID
#' number as the `Id`. If you specify `"Type": "EMAIL"`, you must specify
#' the email address that is associated with the account.
#' 
#' `--target Id=diego@@example.com,Type=EMAIL`
#' @param Notes Additional information that you want to include in the generated email
#' to the recipient account owner.
#' @param Tags A list of tags that you want to attach to the account when it becomes a
#' member of the organization. For each tag in the list, you must specify
#' both a tag key and a value. You can set the value to an empty string,
#' but you can't set it to `null`. For more information about tagging, see
#' [Tagging AWS Organizations
#' resources](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_tagging.html)
#' in the AWS Organizations User Guide.
#' 
#' Any tags in the request are checked for compliance with any applicable
#' tag policies when the request is made. The request is rejected if the
#' tags in the request don't match the requirements of the policy at that
#' time. Tag policy compliance is ***not*** checked again when the
#' invitation is accepted and the tags are actually attached to the
#' account. That means that if the tag policy changes between the
#' invitation and the acceptance, then that tags could potentially be
#' non-compliant.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for an account, then the entire request fails and invitations are
#' not sent.
#'
#' @section Request syntax:
#' ```
#' svc$invite_account_to_organization(
#'   Target = list(
#'     Id = "string",
#'     Type = "ACCOUNT"|"ORGANIZATION"|"EMAIL"
#'   ),
#'   Notes = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows the admin of the master account owned by
#' # bill@example.com inviting the account owned by juan@example.com to join
#' # an organization.
#' svc$invite_account_to_organization(
#'   Notes = "This is a request for Juan's account to join Bill's organization",
#'   Target = list(
#'     Id = "juan@example.com",
#'     Type = "EMAIL"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_invite_account_to_organization
organizations_invite_account_to_organization <- function(Target, Notes = NULL, Tags = NULL) {
  op <- new_operation(
    name = "InviteAccountToOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$invite_account_to_organization_input(Target = Target, Notes = Notes, Tags = Tags)
  output <- .organizations$invite_account_to_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$invite_account_to_organization <- organizations_invite_account_to_organization

#' Removes a member account from its parent organization
#'
#' @description
#' Removes a member account from its parent organization. This version of
#' the operation is performed by the account that wants to leave. To remove
#' a member account as a user in the management account, use
#' RemoveAccountFromOrganization instead.
#' 
#' This operation can be called only from a member account in the
#' organization.
#' 
#' -   The management account in an organization with all features enabled
#'     can set service control policies (SCPs) that can restrict what
#'     administrators of member accounts can do. This includes preventing
#'     them from successfully calling `LeaveOrganization` and leaving the
#'     organization.
#' 
#' -   You can leave an organization as a member account only if the
#'     account is configured with the information required to operate as a
#'     standalone account. When you create an account in an organization
#'     using the AWS Organizations console, API, or CLI commands, the
#'     information required of standalone accounts is *not* automatically
#'     collected. For each account that you want to make standalone, you
#'     must perform the following steps. If any of the steps are already
#'     completed for this account, that step doesn't appear.
#' 
#'     -   Choose a support plan
#' 
#'     -   Provide and verify the required contact information
#' 
#'     -   Provide a current payment method
#' 
#'     AWS uses the payment method to charge for any billable (not free
#'     tier) AWS activity that occurs while the account isn't attached to
#'     an organization. Follow the steps at [To leave an organization when
#'     all required account information has not yet been
#'     provided](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
#'     in the *AWS Organizations User Guide.*
#' 
#' -   You can leave an organization only after you enable IAM user access
#'     to billing in your account. For more information, see [Activating
#'     Access to the Billing and Cost Management
#'     Console](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/control-access-billing.html#ControllingAccessWebsite-Activate)
#'     in the *AWS Billing and Cost Management User Guide.*
#' 
#' -   After the account leaves the organization, all tags that were
#'     attached to the account object in the organization are deleted. AWS
#'     accounts outside of an organization do not support tags.
#'
#' @usage
#' organizations_leave_organization()
#'

#'

#'
#' @examples
#' \dontrun{
#' # TThe following example shows how to remove your member account from an
#' # organization:
#' svc$leave_organization()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_leave_organization
organizations_leave_organization <- function() {
  op <- new_operation(
    name = "LeaveOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$leave_organization_input()
  output <- .organizations$leave_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$leave_organization <- organizations_leave_organization

#' Returns a list of the AWS services that you enabled to integrate with
#' your organization
#'
#' @description
#' Returns a list of the AWS services that you enabled to integrate with
#' your organization. After a service on this list creates the resources
#' that it requires for the integration, it can perform operations on your
#' organization and its accounts.
#' 
#' For more information about integrating other services with AWS
#' Organizations, including the list of services that currently work with
#' Organizations, see [Integrating AWS Organizations with Other AWS
#' Services](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_aws_service_access_for_organization(NextToken,
#'   MaxResults)
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_aws_service_access_for_organization(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_list_aws_service_access_for_organization
organizations_list_aws_service_access_for_organization <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAWSServiceAccessForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_aws_service_access_for_organization_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_aws_service_access_for_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_aws_service_access_for_organization <- organizations_list_aws_service_access_for_organization

#' Lists all the accounts in the organization
#'
#' @description
#' Lists all the accounts in the organization. To request only the accounts
#' in a specified root or organizational unit (OU), use the
#' ListAccountsForParent operation instead.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_accounts(NextToken, MaxResults)
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_accounts(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows you how to request a list of the accounts in
#' # an organization:
#' svc$list_accounts()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_accounts
organizations_list_accounts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_accounts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_accounts_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_accounts <- organizations_list_accounts

#' Lists the accounts in an organization that are contained by the
#' specified target root or organizational unit (OU)
#'
#' @description
#' Lists the accounts in an organization that are contained by the
#' specified target root or organizational unit (OU). If you specify the
#' root, you get a list of all the accounts that aren't in any OU. If you
#' specify an OU, you get a list of all the accounts in only that OU and
#' not in any child OUs. To get a list of all accounts in the organization,
#' use the ListAccounts operation.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_accounts_for_parent(ParentId, NextToken, MaxResults)
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) for the parent root or organization unit (OU)
#' whose accounts you want to list.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_accounts_for_parent(
#'   ParentId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to request a list of the accounts in an
#' # OU:/n/n
#' svc$list_accounts_for_parent(
#'   ParentId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_accounts_for_parent
organizations_list_accounts_for_parent <- function(ParentId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccountsForParent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_accounts_for_parent_input(ParentId = ParentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_accounts_for_parent_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_accounts_for_parent <- organizations_list_accounts_for_parent

#' Lists all of the organizational units (OUs) or accounts that are
#' contained in the specified parent OU or root
#'
#' @description
#' Lists all of the organizational units (OUs) or accounts that are
#' contained in the specified parent OU or root. This operation, along with
#' ListParents enables you to traverse the tree structure that makes up
#' this root.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_children(ParentId, ChildType, NextToken, MaxResults)
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) for the parent root or OU whose children you
#' want to list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param ChildType &#91;required&#93; Filters the output to include only the specified child type.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_children(
#'   ParentId = "string",
#'   ChildType = "ACCOUNT"|"ORGANIZATIONAL_UNIT",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to request a list of the child OUs in a
#' # parent root or OU:/n/n
#' svc$list_children(
#'   ChildType = "ORGANIZATIONAL_UNIT",
#'   ParentId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_children
organizations_list_children <- function(ParentId, ChildType, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListChildren",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_children_input(ParentId = ParentId, ChildType = ChildType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_children_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_children <- organizations_list_children

#' Lists the account creation requests that match the specified status that
#' is currently being tracked for the organization
#'
#' @description
#' Lists the account creation requests that match the specified status that
#' is currently being tracked for the organization.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_create_account_status(States, NextToken, MaxResults)
#'
#' @param States A list of one or more states that you want included in the response. If
#' this parameter isn't present, all requests are included in the response.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_create_account_status(
#'   States = list(
#'     "IN_PROGRESS"|"SUCCEEDED"|"FAILED"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows a user requesting a list of only the
#' # completed account creation requests made for the current organization:
#' svc$list_create_account_status(
#'   States = list(
#'     "SUCCEEDED"
#'   )
#' )
#' 
#' # The following example shows a user requesting a list of only the
#' # in-progress account creation requests made for the current organization:
#' svc$list_create_account_status(
#'   States = list(
#'     "IN_PROGRESS"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_create_account_status
organizations_list_create_account_status <- function(States = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCreateAccountStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_create_account_status_input(States = States, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_create_account_status_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_create_account_status <- organizations_list_create_account_status

#' Lists the AWS accounts that are designated as delegated administrators
#' in this organization
#'
#' @description
#' Lists the AWS accounts that are designated as delegated administrators
#' in this organization.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_delegated_administrators(ServicePrincipal, NextToken,
#'   MaxResults)
#'
#' @param ServicePrincipal Specifies a service principal name. If specified, then the operation
#' lists the delegated administrators only for the specified service.
#' 
#' If you don't specify a service principal, the operation lists all
#' delegated administrators for all services in your organization.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_delegated_administrators(
#'   ServicePrincipal = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_list_delegated_administrators
organizations_list_delegated_administrators <- function(ServicePrincipal = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDelegatedAdministrators",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_delegated_administrators_input(ServicePrincipal = ServicePrincipal, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_delegated_administrators_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_delegated_administrators <- organizations_list_delegated_administrators

#' List the AWS services for which the specified account is a delegated
#' administrator
#'
#' @description
#' List the AWS services for which the specified account is a delegated
#' administrator.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_delegated_services_for_account(AccountId, NextToken,
#'   MaxResults)
#'
#' @param AccountId &#91;required&#93; The account ID number of a delegated administrator account in the
#' organization.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_delegated_services_for_account(
#'   AccountId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_list_delegated_services_for_account
organizations_list_delegated_services_for_account <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDelegatedServicesForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_delegated_services_for_account_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_delegated_services_for_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_delegated_services_for_account <- organizations_list_delegated_services_for_account

#' Lists the current handshakes that are associated with the account of the
#' requesting user
#'
#' @description
#' Lists the current handshakes that are associated with the account of the
#' requesting user.
#' 
#' Handshakes that are `ACCEPTED`, `DECLINED`, or `CANCELED` appear in the
#' results of this API for only 30 days after changing to that state. After
#' that, they're deleted and no longer accessible.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called from any account in the organization.
#'
#' @usage
#' organizations_list_handshakes_for_account(Filter, NextToken, MaxResults)
#'
#' @param Filter Filters the handshakes that you want included in the response. The
#' default is all types. Use the `ActionType` element to limit the output
#' to only a specified type, such as `INVITE`, `ENABLE_ALL_FEATURES`, or
#' `APPROVE_ALL_FEATURES`. Alternatively, for the `ENABLE_ALL_FEATURES`
#' handshake that generates a separate child handshake for each member
#' account, you can specify `ParentHandshakeId` to see only the handshakes
#' that were generated by that parent request.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_handshakes_for_account(
#'   Filter = list(
#'     ActionType = "INVITE"|"ENABLE_ALL_FEATURES"|"APPROVE_ALL_FEATURES"|"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
#'     ParentHandshakeId = "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows you how to get a list of handshakes that are
#' # associated with the account of the credentials used to call the
#' # operation:
#' svc$list_handshakes_for_account()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_handshakes_for_account
organizations_list_handshakes_for_account <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHandshakesForAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_handshakes_for_account_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_handshakes_for_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_handshakes_for_account <- organizations_list_handshakes_for_account

#' Lists the handshakes that are associated with the organization that the
#' requesting user is part of
#'
#' @description
#' Lists the handshakes that are associated with the organization that the
#' requesting user is part of. The `ListHandshakesForOrganization`
#' operation returns a list of handshake structures. Each structure
#' contains details and status about a handshake.
#' 
#' Handshakes that are `ACCEPTED`, `DECLINED`, or `CANCELED` appear in the
#' results of this API for only 30 days after changing to that state. After
#' that, they're deleted and no longer accessible.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_handshakes_for_organization(Filter, NextToken,
#'   MaxResults)
#'
#' @param Filter A filter of the handshakes that you want included in the response. The
#' default is all types. Use the `ActionType` element to limit the output
#' to only a specified type, such as `INVITE`, `ENABLE-ALL-FEATURES`, or
#' `APPROVE-ALL-FEATURES`. Alternatively, for the `ENABLE-ALL-FEATURES`
#' handshake that generates a separate child handshake for each member
#' account, you can specify the `ParentHandshakeId` to see only the
#' handshakes that were generated by that parent request.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_handshakes_for_organization(
#'   Filter = list(
#'     ActionType = "INVITE"|"ENABLE_ALL_FEATURES"|"APPROVE_ALL_FEATURES"|"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
#'     ParentHandshakeId = "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows you how to get a list of handshakes
#' # associated with the current organization:
#' svc$list_handshakes_for_organization()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_handshakes_for_organization
organizations_list_handshakes_for_organization <- function(Filter = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListHandshakesForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_handshakes_for_organization_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_handshakes_for_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_handshakes_for_organization <- organizations_list_handshakes_for_organization

#' Lists the organizational units (OUs) in a parent organizational unit or
#' root
#'
#' @description
#' Lists the organizational units (OUs) in a parent organizational unit or
#' root.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_organizational_units_for_parent(ParentId, NextToken,
#'   MaxResults)
#'
#' @param ParentId &#91;required&#93; The unique identifier (ID) of the root or OU whose child OUs you want to
#' list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_organizational_units_for_parent(
#'   ParentId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to get a list of OUs in a specified
#' # root:/n/n
#' svc$list_organizational_units_for_parent(
#'   ParentId = "r-examplerootid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_organizational_units_for_parent
organizations_list_organizational_units_for_parent <- function(ParentId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOrganizationalUnitsForParent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_organizational_units_for_parent_input(ParentId = ParentId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_organizational_units_for_parent_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_organizational_units_for_parent <- organizations_list_organizational_units_for_parent

#' Lists the root or organizational units (OUs) that serve as the immediate
#' parent of the specified child OU or account
#'
#' @description
#' Lists the root or organizational units (OUs) that serve as the immediate
#' parent of the specified child OU or account. This operation, along with
#' ListChildren enables you to traverse the tree structure that makes up
#' this root.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#' 
#' In the current release, a child can have only a single parent.
#'
#' @usage
#' organizations_list_parents(ChildId, NextToken, MaxResults)
#'
#' @param ChildId &#91;required&#93; The unique identifier (ID) of the OU or account whose parent containers
#' you want to list. Don't specify a root.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a child ID
#' string requires one of the following:
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that contains the OU). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_parents(
#'   ChildId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to list the root or OUs that contain
#' # account 444444444444:/n/n
#' svc$list_parents(
#'   ChildId = "444444444444"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_parents
organizations_list_parents <- function(ChildId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListParents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_parents_input(ChildId = ChildId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_parents_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_parents <- organizations_list_parents

#' Retrieves the list of all policies in an organization of a specified
#' type
#'
#' @description
#' Retrieves the list of all policies in an organization of a specified
#' type.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_policies(Filter, NextToken, MaxResults)
#'
#' @param Filter &#91;required&#93; Specifies the type of policy that you want to include in the response.
#' You must specify one of the following values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_policies(
#'   Filter = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to get a list of service control
#' # policies (SCPs):/n/n
#' svc$list_policies(
#'   Filter = "SERVICE_CONTROL_POLICY"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_policies
organizations_list_policies <- function(Filter, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_policies_input(Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_policies_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_policies <- organizations_list_policies

#' Lists the policies that are directly attached to the specified target
#' root, organizational unit (OU), or account
#'
#' @description
#' Lists the policies that are directly attached to the specified target
#' root, organizational unit (OU), or account. You must specify the policy
#' type that you want included in the returned list.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_policies_for_target(TargetId, Filter, NextToken,
#'   MaxResults)
#'
#' @param TargetId &#91;required&#93; The unique identifier (ID) of the root, organizational unit, or account
#' whose policies you want to list.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a target ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Account** - A string that consists of exactly 12 digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param Filter &#91;required&#93; The type of policy that you want to include in the returned list. You
#' must specify one of the following values:
#' 
#' -   [AISERVICES\\_OPT\\_OUT\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
#' 
#' -   [BACKUP\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html)
#' 
#' -   [SERVICE\\_CONTROL\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html)
#' 
#' -   [TAG\\_POLICY](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html)
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_policies_for_target(
#'   TargetId = "string",
#'   Filter = "SERVICE_CONTROL_POLICY"|"TAG_POLICY"|"BACKUP_POLICY"|"AISERVICES_OPT_OUT_POLICY",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to get a list of all service control
#' # policies (SCPs) of the type specified by the Filter parameter, that are
#' # directly attached to an account. The returned list does not include
#' # policies that apply to the account because of inheritance from its
#' # location in an OU hierarchy:/n/n
#' svc$list_policies_for_target(
#'   Filter = "SERVICE_CONTROL_POLICY",
#'   TargetId = "444444444444"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_policies_for_target
organizations_list_policies_for_target <- function(TargetId, Filter, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPoliciesForTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_policies_for_target_input(TargetId = TargetId, Filter = Filter, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_policies_for_target_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_policies_for_target <- organizations_list_policies_for_target

#' Lists the roots that are defined in the current organization
#'
#' @description
#' Lists the roots that are defined in the current organization.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#' 
#' Policy types can be enabled and disabled in roots. This is distinct from
#' whether they're available in the organization. When you enable all
#' features, you make policy types available for use in that organization.
#' Individual policy types can then be enabled and disabled in a root. To
#' see the availability of a policy type in an organization, use
#' DescribeOrganization.
#'
#' @usage
#' organizations_list_roots(NextToken, MaxResults)
#'
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_roots(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to get the list of the roots in the
#' # current organization:/n/n
#' svc$list_roots()
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_roots
organizations_list_roots <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRoots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_roots_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_roots_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_roots <- organizations_list_roots

#' Lists tags that are attached to the specified resource
#'
#' @description
#' Lists tags that are attached to the specified resource.
#' 
#' You can attach tags to the following resources in AWS Organizations.
#' 
#' -   AWS account
#' 
#' -   Organization root
#' 
#' -   Organizational unit (OU)
#' 
#' -   Policy (any type)
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_tags_for_resource(ResourceId, NextToken)
#'
#' @param ResourceId &#91;required&#93; The ID of the resource with the tags to list.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   AWS account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-<i>1a2b-34uvwxyz</i> `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-<i>1a2b</i> `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-<i>12abcdefg3</i> `
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceId = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_list_tags_for_resource
organizations_list_tags_for_resource <- function(ResourceId, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_tags_for_resource_input(ResourceId = ResourceId, NextToken = NextToken)
  output <- .organizations$list_tags_for_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_tags_for_resource <- organizations_list_tags_for_resource

#' Lists all the roots, organizational units (OUs), and accounts that the
#' specified policy is attached to
#'
#' @description
#' Lists all the roots, organizational units (OUs), and accounts that the
#' specified policy is attached to.
#' 
#' Always check the `NextToken` response parameter for a `null` value when
#' calling a `List*` operation. These operations can occasionally return an
#' empty set of results even when there are more results available. The
#' `NextToken` response parameter value is `null` *only* when there are no
#' more results to display.
#' 
#' This operation can be called only from the organization's management
#' account or by a member account that is a delegated administrator for an
#' AWS service.
#'
#' @usage
#' organizations_list_targets_for_policy(PolicyId, NextToken, MaxResults)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy whose attachments you want to
#' know.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#' @param NextToken The parameter for receiving additional results if you receive a
#' `NextToken` response in a previous request. A `NextToken` response
#' indicates that more output is available. Set this parameter to the value
#' of the previous call's `NextToken` response to indicate where the output
#' should continue from.
#' @param MaxResults The total number of results that you want included on each page of the
#' response. If you do not include this parameter, it defaults to a value
#' that is specific to the operation. If additional items exist beyond the
#' maximum you specify, the `NextToken` response element is present and has
#' a value (is not null). Include that value as the `NextToken` request
#' parameter in the next call to the operation to get the next part of the
#' results. Note that Organizations might return fewer results than the
#' maximum even when there are more results available. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_targets_for_policy(
#'   PolicyId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to get the list of roots, OUs, and
#' # accounts to which the specified policy is attached:/n/n
#' svc$list_targets_for_policy(
#'   PolicyId = "p-FullAWSAccess"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_list_targets_for_policy
organizations_list_targets_for_policy <- function(PolicyId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTargetsForPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$list_targets_for_policy_input(PolicyId = PolicyId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .organizations$list_targets_for_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$list_targets_for_policy <- organizations_list_targets_for_policy

#' Moves an account from its current source parent root or organizational
#' unit (OU) to the specified destination parent root or OU
#'
#' @description
#' Moves an account from its current source parent root or organizational
#' unit (OU) to the specified destination parent root or OU.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_move_account(AccountId, SourceParentId,
#'   DestinationParentId)
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the account that you want to move.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#' @param SourceParentId &#91;required&#93; The unique identifier (ID) of the root or organizational unit that you
#' want to move the account from.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#' @param DestinationParentId &#91;required&#93; The unique identifier (ID) of the root or organizational unit that you
#' want to move the account to.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a parent ID
#' string requires one of the following:
#' 
#' -   **Root** - A string that begins with "r-" followed by from 4 to 32
#'     lowercase letters or digits.
#' 
#' -   **Organizational unit (OU)** - A string that begins with "ou-"
#'     followed by from 4 to 32 lowercase letters or digits (the ID of the
#'     root that the OU is in). This string is followed by a second "-"
#'     dash and from 8 to 32 additional lowercase letters or digits.
#'
#' @section Request syntax:
#' ```
#' svc$move_account(
#'   AccountId = "string",
#'   SourceParentId = "string",
#'   DestinationParentId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to move a member account from the root
#' # to an OU:/n/n
#' svc$move_account(
#'   AccountId = "333333333333",
#'   DestinationParentId = "ou-examplerootid111-exampleouid111",
#'   SourceParentId = "r-examplerootid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_move_account
organizations_move_account <- function(AccountId, SourceParentId, DestinationParentId) {
  op <- new_operation(
    name = "MoveAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$move_account_input(AccountId = AccountId, SourceParentId = SourceParentId, DestinationParentId = DestinationParentId)
  output <- .organizations$move_account_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$move_account <- organizations_move_account

#' Enables the specified member account to administer the Organizations
#' features of the specified AWS service
#'
#' @description
#' Enables the specified member account to administer the Organizations
#' features of the specified AWS service. It grants read-only access to AWS
#' Organizations service data. The account still requires IAM permissions
#' to access and administer the AWS service.
#' 
#' You can run this action only for AWS services that support this feature.
#' For a current list of services that support it, see the column *Supports
#' Delegated Administrator* in the table at [AWS Services that you can use
#' with AWS
#' Organizations](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html)
#' in the *AWS Organizations User Guide.*
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_register_delegated_administrator(AccountId,
#'   ServicePrincipal)
#'
#' @param AccountId &#91;required&#93; The account ID number of the member account in the organization to
#' register as a delegated administrator.
#' @param ServicePrincipal &#91;required&#93; The service principal of the AWS service for which you want to make the
#' member account a delegated administrator.
#'
#' @section Request syntax:
#' ```
#' svc$register_delegated_administrator(
#'   AccountId = "string",
#'   ServicePrincipal = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_register_delegated_administrator
organizations_register_delegated_administrator <- function(AccountId, ServicePrincipal) {
  op <- new_operation(
    name = "RegisterDelegatedAdministrator",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$register_delegated_administrator_input(AccountId = AccountId, ServicePrincipal = ServicePrincipal)
  output <- .organizations$register_delegated_administrator_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$register_delegated_administrator <- organizations_register_delegated_administrator

#' Removes the specified account from the organization
#'
#' @description
#' Removes the specified account from the organization.
#' 
#' The removed account becomes a standalone account that isn't a member of
#' any organization. It's no longer subject to any policies and is
#' responsible for its own bill payments. The organization's management
#' account is no longer charged for any expenses accrued by the member
#' account after it's removed from the organization.
#' 
#' This operation can be called only from the organization's management
#' account. Member accounts can remove themselves with LeaveOrganization
#' instead.
#' 
#' -   You can remove an account from your organization only if the account
#'     is configured with the information required to operate as a
#'     standalone account. When you create an account in an organization
#'     using the AWS Organizations console, API, or CLI commands, the
#'     information required of standalone accounts is *not* automatically
#'     collected. For an account that you want to make standalone, you must
#'     choose a support plan, provide and verify the required contact
#'     information, and provide a current payment method. AWS uses the
#'     payment method to charge for any billable (not free tier) AWS
#'     activity that occurs while the account isn't attached to an
#'     organization. To remove an account that doesn't yet have this
#'     information, you must sign in as the member account and follow the
#'     steps at [To leave an organization when all required account
#'     information has not yet been
#'     provided](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts_remove.html#leave-without-all-info)
#'     in the *AWS Organizations User Guide.*
#' 
#' -   After the account leaves the organization, all tags that were
#'     attached to the account object in the organization are deleted. AWS
#'     accounts outside of an organization do not support tags.
#'
#' @usage
#' organizations_remove_account_from_organization(AccountId)
#'
#' @param AccountId &#91;required&#93; The unique identifier (ID) of the member account that you want to remove
#' from the organization.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an account
#' ID string requires exactly 12 digits.
#'
#' @section Request syntax:
#' ```
#' svc$remove_account_from_organization(
#'   AccountId = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows you how to remove an account from an
#' # organization:
#' svc$remove_account_from_organization(
#'   AccountId = "333333333333"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_remove_account_from_organization
organizations_remove_account_from_organization <- function(AccountId) {
  op <- new_operation(
    name = "RemoveAccountFromOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$remove_account_from_organization_input(AccountId = AccountId)
  output <- .organizations$remove_account_from_organization_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$remove_account_from_organization <- organizations_remove_account_from_organization

#' Adds one or more tags to the specified resource
#'
#' @description
#' Adds one or more tags to the specified resource.
#' 
#' Currently, you can attach tags to the following resources in AWS
#' Organizations.
#' 
#' -   AWS account
#' 
#' -   Organization root
#' 
#' -   Organizational unit (OU)
#' 
#' -   Policy (any type)
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_tag_resource(ResourceId, Tags)
#'
#' @param ResourceId &#91;required&#93; The ID of the resource to add a tag to.
#' @param Tags &#91;required&#93; A list of tags to add to the specified resource.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   AWS account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-<i>1a2b-34uvwxyz</i> `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-<i>1a2b</i> `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-<i>12abcdefg3</i> `
#' 
#' For each tag in the list, you must specify both a tag key and a value.
#' You can set the value to an empty string, but you can't set it to
#' `null`.
#' 
#' If any one of the tags is invalid or if you exceed the allowed number of
#' tags for an account user, then the entire request fails and the account
#' is not created.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_tag_resource
organizations_tag_resource <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$tag_resource_input(ResourceId = ResourceId, Tags = Tags)
  output <- .organizations$tag_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$tag_resource <- organizations_tag_resource

#' Removes any tags with the specified keys from the specified resource
#'
#' @description
#' Removes any tags with the specified keys from the specified resource.
#' 
#' You can attach tags to the following resources in AWS Organizations.
#' 
#' -   AWS account
#' 
#' -   Organization root
#' 
#' -   Organizational unit (OU)
#' 
#' -   Policy (any type)
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_untag_resource(ResourceId, TagKeys)
#'
#' @param ResourceId &#91;required&#93; The ID of the resource to remove a tag from.
#' 
#' You can specify any of the following taggable resources.
#' 
#' -   AWS account – specify the account ID number.
#' 
#' -   Organizational unit – specify the OU ID that begins with `ou-` and
#'     looks similar to: `ou-<i>1a2b-34uvwxyz</i> `
#' 
#' -   Root – specify the root ID that begins with `r-` and looks similar
#'     to: `r-<i>1a2b</i> `
#' 
#' -   Policy – specify the policy ID that begins with `p-` andlooks
#'     similar to: `p-<i>12abcdefg3</i> `
#' @param TagKeys &#91;required&#93; The list of keys for tags to remove from the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname organizations_untag_resource
organizations_untag_resource <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$untag_resource_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .organizations$untag_resource_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$untag_resource <- organizations_untag_resource

#' Renames the specified organizational unit (OU)
#'
#' @description
#' Renames the specified organizational unit (OU). The ID and ARN don't
#' change. The child OUs and accounts remain in place, and any attached
#' policies of the OU remain attached.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_update_organizational_unit(OrganizationalUnitId, Name)
#'
#' @param OrganizationalUnitId &#91;required&#93; The unique identifier (ID) of the OU that you want to rename. You can
#' get the ID from the ListOrganizationalUnitsForParent operation.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for an
#' organizational unit ID string requires "ou-" followed by from 4 to 32
#' lowercase letters or digits (the ID of the root that contains the OU).
#' This string is followed by a second "-" dash and from 8 to 32 additional
#' lowercase letters or digits.
#' @param Name The new name that you want to assign to the OU.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#'
#' @section Request syntax:
#' ```
#' svc$update_organizational_unit(
#'   OrganizationalUnitId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to rename an OU. The output confirms the
#' # new name:/n/n
#' svc$update_organizational_unit(
#'   Name = "AccountingOU",
#'   OrganizationalUnitId = "ou-examplerootid111-exampleouid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_update_organizational_unit
organizations_update_organizational_unit <- function(OrganizationalUnitId, Name = NULL) {
  op <- new_operation(
    name = "UpdateOrganizationalUnit",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$update_organizational_unit_input(OrganizationalUnitId = OrganizationalUnitId, Name = Name)
  output <- .organizations$update_organizational_unit_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$update_organizational_unit <- organizations_update_organizational_unit

#' Updates an existing policy with a new name, description, or content
#'
#' @description
#' Updates an existing policy with a new name, description, or content. If
#' you don't supply any parameter, that value remains unchanged. You can't
#' change a policy's type.
#' 
#' This operation can be called only from the organization's management
#' account.
#'
#' @usage
#' organizations_update_policy(PolicyId, Name, Description, Content)
#'
#' @param PolicyId &#91;required&#93; The unique identifier (ID) of the policy that you want to update.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) for a policy ID
#' string requires "p-" followed by from 8 to 128 lowercase or uppercase
#' letters, digits, or the underscore character (\\_).
#' @param Name If provided, the new name for the policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of any of the characters in the
#' ASCII character range.
#' @param Description If provided, the new description for the policy.
#' @param Content If provided, the new content for the policy. The text must be correctly
#' formatted JSON that complies with the syntax for the policy's type. For
#' more information, see [Service Control Policy
#' Syntax](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps_syntax.html)
#' in the *AWS Organizations User Guide.*
#'
#' @section Request syntax:
#' ```
#' svc$update_policy(
#'   PolicyId = "string",
#'   Name = "string",
#'   Description = "string",
#'   Content = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example shows how to rename a policy and give it a new
#' # description and new content. The output confirms the new name and
#' # description text:/n/n
#' svc$update_policy(
#'   Description = "This description replaces the original.",
#'   Name = "Renamed-Policy",
#'   PolicyId = "p-examplepolicyid111"
#' )
#' 
#' # The following example shows how to replace the JSON text of the SCP from
#' # the preceding example with a new JSON policy text string that allows S3
#' # actions instead of EC2 actions:/n/n
#' svc$update_policy(
#'   Content = "\{ \\\"Version\\\": \\\"2012-10-17\\\", \\\"Statement\\\": \{\\\"Effect\\\": ...",
#'   PolicyId = "p-examplepolicyid111"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname organizations_update_policy
organizations_update_policy <- function(PolicyId, Name = NULL, Description = NULL, Content = NULL) {
  op <- new_operation(
    name = "UpdatePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .organizations$update_policy_input(PolicyId = PolicyId, Name = Name, Description = Description, Content = Content)
  output <- .organizations$update_policy_output()
  config <- get_config()
  svc <- .organizations$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.organizations$operations$update_policy <- organizations_update_policy
