% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_put_dashboard}
\alias{cloudwatch_put_dashboard}
\title{Creates a dashboard if it does not already exist, or updates an existing
dashboard}
\usage{
cloudwatch_put_dashboard(DashboardName, DashboardBody)
}
\arguments{
\item{DashboardName}{[required] The name of the dashboard. If a dashboard with this name already exists,
this call modifies that dashboard, replacing its current contents.
Otherwise, a new dashboard is created. The maximum length is 255, and
valid characters are A-Z, a-z, 0-9, "-", and "\\_". This parameter is
required.}

\item{DashboardBody}{[required] The detailed information about the dashboard in JSON format, including
the widgets to include and their location on the dashboard. This
parameter is required.

For more information about the syntax, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/CloudWatch-Dashboard-Body-Structure.html}{Dashboard Body Structure and Syntax}.}
}
\description{
Creates a dashboard if it does not already exist, or updates an existing
dashboard. If you update a dashboard, the entire contents are replaced
with what you specify here.

All dashboards in your account are global, not region-specific.

A simple way to create a dashboard using \code{PutDashboard} is to copy an
existing dashboard. To copy an existing dashboard using the console, you
can load the dashboard and then use the View/edit source command in the
Actions menu to display the JSON block for that dashboard. Another way
to copy a dashboard is to use \code{GetDashboard}, and then use the data
returned within \code{DashboardBody} as the template for the new dashboard
when you call \code{PutDashboard}.

When you create a dashboard with \code{PutDashboard}, a good practice is to
add a text widget at the top of the dashboard with a message that the
dashboard was created by script and should not be changed in the
console. This message could also point console users to the location of
the \code{DashboardBody} script or the CloudFormation template used to create
the dashboard.
}
\section{Request syntax}{
\preformatted{svc$put_dashboard(
  DashboardName = "string",
  DashboardBody = "string"
)
}
}

\keyword{internal}
