% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_list_replays}
\alias{cloudwatchevents_list_replays}
\title{Lists your replays}
\usage{
cloudwatchevents_list_replays(NamePrefix, State, EventSourceArn,
  NextToken, Limit)
}
\arguments{
\item{NamePrefix}{A name prefix to filter the replays returned. Only replays with name
that match the prefix are returned.}

\item{State}{The state of the replay.}

\item{EventSourceArn}{The ARN of the event source associated with the replay.}

\item{NextToken}{The token returned by a previous call to retrieve the next set of
results.}

\item{Limit}{The maximum number of replays to retrieve.}
}
\description{
Lists your replays. You can either list all the replays or you can
provide a prefix to match to the replay names. Filter parameters are
exclusive.
}
\section{Request syntax}{
\preformatted{svc$list_replays(
  NamePrefix = "string",
  State = "STARTING"|"RUNNING"|"CANCELLING"|"COMPLETED"|"CANCELLED"|"FAILED",
  EventSourceArn = "string",
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
