% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_get_log_group_fields}
\alias{cloudwatchlogs_get_log_group_fields}
\title{Returns a list of the fields that are included in log events in the
specified log group, along with the percentage of log events that
contain each field}
\usage{
cloudwatchlogs_get_log_group_fields(logGroupName, time)
}
\arguments{
\item{logGroupName}{[required] The name of the log group to search.}

\item{time}{The time to set as the center of the query. If you specify \code{time}, the 8
minutes before and 8 minutes after this time are searched. If you omit
\code{time}, the past 15 minutes are queried.

The \code{time} value is specified as epoch time, the number of seconds since
January 1, 1970, 00:00:00 UTC.}
}
\description{
Returns a list of the fields that are included in log events in the
specified log group, along with the percentage of log events that
contain each field. The search is limited to a time period that you
specify.

In the results, fields that start with @ are fields generated by
CloudWatch Logs. For example, \verb{@timestamp} is the timestamp of each log
event. For more information about the fields that are generated by
CloudWatch logs, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_AnalyzeLogData-discoverable-fields.html}{Supported Logs and Discovered Fields}.

The response results are sorted by the frequency percentage, starting
with the highest percentage.
}
\section{Request syntax}{
\preformatted{svc$get_log_group_fields(
  logGroupName = "string",
  time = 123
)
}
}

\keyword{internal}
