% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_list_received_licenses}
\alias{licensemanager_list_received_licenses}
\title{Lists received licenses}
\usage{
licensemanager_list_received_licenses(LicenseArns, Filters, NextToken,
  MaxResults)
}
\arguments{
\item{LicenseArns}{Amazon Resource Names (ARNs) of the licenses.}

\item{Filters}{Filters to scope the results. The following filters are supported:
\itemize{
\item \code{ProductSKU}
\item \code{Status}
\item \code{KeyFingerprint}
\item \code{Issuer}
}}

\item{NextToken}{Token for the next set of results.}

\item{MaxResults}{Maximum number of results to return in a single call.}
}
\description{
Lists received licenses.
}
\section{Request syntax}{
\preformatted{svc$list_received_licenses(
  LicenseArns = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
