% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_deployments}
\alias{opsworks_describe_deployments}
\title{Requests a description of a specified set of deployments}
\usage{
opsworks_describe_deployments(StackId, AppId, DeploymentIds)
}
\arguments{
\item{StackId}{The stack ID. If you include this parameter, the command returns a
description of the commands associated with the specified stack.}

\item{AppId}{The app ID. If you include this parameter, the command returns a
description of the commands associated with the specified app.}

\item{DeploymentIds}{An array of deployment IDs to be described. If you include this
parameter, the command returns a description of the specified
deployments. Otherwise, it returns a description of every deployment.}
}
\description{
Requests a description of a specified set of deployments.

This call accepts only one resource-identifying parameter.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_deployments(
  StackId = "string",
  AppId = "string",
  DeploymentIds = list(
    "string"
  )
)
}
}

\keyword{internal}
