% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_select_aggregate_resource_config}
\alias{configservice_select_aggregate_resource_config}
\title{Accepts a structured query language (SQL) SELECT command and an
aggregator to query configuration state of AWS resources across multiple
accounts and regions, performs the corresponding search, and returns
resource configurations matching the properties}
\usage{
configservice_select_aggregate_resource_config(Expression,
  ConfigurationAggregatorName, Limit, MaxResults, NextToken)
}
\arguments{
\item{Expression}{[required] The SQL query SELECT command.}

\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{Limit}{The maximum number of query results returned on each page.}

\item{MaxResults}{The maximum number of query results returned on each page. AWS Config
also allows the Limit request parameter.}

\item{NextToken}{The nextToken string returned in a previous request that you use to
request the next page of results in a paginated response.}
}
\value{
A list with the following syntax:\preformatted{list(
  Results = list(
    "string"
  ),
  QueryInfo = list(
    SelectFields = list(
      list(
        Name = "string"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Accepts a structured query language (SQL) SELECT command and an
aggregator to query configuration state of AWS resources across multiple
accounts and regions, performs the corresponding search, and returns
resource configurations matching the properties.

For more information about query components, see the \href{https://docs.aws.amazon.com/config/latest/developerguide/query-components.html}{\strong{Query Components}}
section in the AWS Config Developer Guide.
}
\section{Request syntax}{
\preformatted{svc$select_aggregate_resource_config(
  Expression = "string",
  ConfigurationAggregatorName = "string",
  Limit = 123,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
