% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_compliance_summary_by_resource_type}
\alias{configservice_get_compliance_summary_by_resource_type}
\title{Returns the number of resources that are compliant and the number that
are noncompliant}
\usage{
configservice_get_compliance_summary_by_resource_type(ResourceTypes)
}
\arguments{
\item{ResourceTypes}{Specify one or more resource types to get the number of resources that
are compliant and the number that are noncompliant for each resource
type.

For this request, you can specify an AWS resource type such as
\verb{AWS::EC2::Instance}. You can specify that the resource type is an AWS
account by specifying \verb{AWS::::Account}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ComplianceSummariesByResourceType = list(
    list(
      ResourceType = "string",
      ComplianceSummary = list(
        CompliantResourceCount = list(
          CappedCount = 123,
          CapExceeded = TRUE|FALSE
        ),
        NonCompliantResourceCount = list(
          CappedCount = 123,
          CapExceeded = TRUE|FALSE
        ),
        ComplianceSummaryTimestamp = as.POSIXct(
          "2015-01-01"
        )
      )
    )
  )
)
}
}
\description{
Returns the number of resources that are compliant and the number that
are noncompliant. You can specify one or more resource types to get
these numbers for each resource type. The maximum number returned is
100.
}
\section{Request syntax}{
\preformatted{svc$get_compliance_summary_by_resource_type(
  ResourceTypes = list(
    "string"
  )
)
}
}

\keyword{internal}
