% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_handshake}
\alias{organizations_describe_handshake}
\title{Retrieves information about a previously requested handshake}
\usage{
organizations_describe_handshake(HandshakeId)
}
\arguments{
\item{HandshakeId}{[required] The unique identifier (ID) of the handshake that you want information
about. You can get the ID from the original call to
\code{\link[=organizations_invite_account_to_organization]{invite_account_to_organization}},
or from a call to
\code{\link[=organizations_list_handshakes_for_account]{list_handshakes_for_account}}
or
\code{\link[=organizations_list_handshakes_for_organization]{list_handshakes_for_organization}}.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for handshake
ID string requires "h-" followed by from 8 to 32 lowercase letters or
digits.}
}
\value{
A list with the following syntax:\preformatted{list(
  Handshake = list(
    Id = "string",
    Arn = "string",
    Parties = list(
      list(
        Id = "string",
        Type = "ACCOUNT"|"ORGANIZATION"|"EMAIL"
      )
    ),
    State = "REQUESTED"|"OPEN"|"CANCELED"|"ACCEPTED"|"DECLINED"|"EXPIRED",
    RequestedTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    ExpirationTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    Action = "INVITE"|"ENABLE_ALL_FEATURES"|"APPROVE_ALL_FEATURES"|"ADD_ORGANIZATIONS_SERVICE_LINKED_ROLE",
    Resources = list(
      list(
        Value = "string",
        Type = "ACCOUNT"|"ORGANIZATION"|"ORGANIZATION_FEATURE_SET"|"EMAIL"|"MASTER_EMAIL"|"MASTER_NAME"|"NOTES"|"PARENT_HANDSHAKE",
        Resources = list()
      )
    )
  )
)
}
}
\description{
Retrieves information about a previously requested handshake. The
handshake ID comes from the response to the original
\code{\link[=organizations_invite_account_to_organization]{invite_account_to_organization}}
operation that generated the handshake.

You can access handshakes that are \code{ACCEPTED}, \code{DECLINED}, or \code{CANCELED}
for only 30 days after they change to that state. They're then deleted
and no longer accessible.

This operation can be called from any account in the organization.
}
\section{Request syntax}{
\preformatted{svc$describe_handshake(
  HandshakeId = "string"
)
}
}

\examples{
\dontrun{
# The following example shows you how to request details about a
# handshake. The handshake ID comes either from the original call to
# "InviteAccountToOrganization", or from a call to
# "ListHandshakesForAccount" or "ListHandshakesForOrganization":
svc$describe_handshake(
  HandshakeId = "h-examplehandshakeid111"
)
}

}
\keyword{internal}
