% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_service.R
\name{servicecatalog}
\alias{servicecatalog}
\title{AWS Service Catalog}
\usage{
servicecatalog(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
\href{https://aws.amazon.com/servicecatalog/}{AWS Service Catalog} enables
organizations to create and manage catalogs of IT services that are
approved for AWS. To get the most out of this documentation, you should
be familiar with the terminology discussed in \href{https://docs.aws.amazon.com/servicecatalog/latest/adminguide/what-is_concepts.html}{AWS Service Catalog Concepts}.
}
\section{Service syntax}{
\preformatted{svc <- servicecatalog(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=servicecatalog_accept_portfolio_share]{accept_portfolio_share} \tab Accepts an offer to share the specified portfolio\cr
\link[=servicecatalog_associate_budget_with_resource]{associate_budget_with_resource} \tab Associates the specified budget with the specified resource\cr
\link[=servicecatalog_associate_principal_with_portfolio]{associate_principal_with_portfolio} \tab Associates the specified principal ARN with the specified portfolio\cr
\link[=servicecatalog_associate_product_with_portfolio]{associate_product_with_portfolio} \tab Associates the specified product with the specified portfolio\cr
\link[=servicecatalog_associate_service_action_with_provisioning_artifact]{associate_service_action_with_provisioning_artifact} \tab Associates a self-service action with a provisioning artifact\cr
\link[=servicecatalog_associate_tag_option_with_resource]{associate_tag_option_with_resource} \tab Associate the specified TagOption with the specified portfolio or product\cr
\link[=servicecatalog_batch_associate_service_action_with_provisioning_artifact]{batch_associate_service_action_with_provisioning_artifact} \tab Associates multiple self-service actions with provisioning artifacts\cr
\link[=servicecatalog_batch_disassociate_service_action_from_provisioning_artifact]{batch_disassociate_service_action_from_provisioning_artifact} \tab Disassociates a batch of self-service actions from the specified provisioning artifact\cr
\link[=servicecatalog_copy_product]{copy_product} \tab Copies the specified source product to the specified target product or a new product\cr
\link[=servicecatalog_create_constraint]{create_constraint} \tab Creates a constraint\cr
\link[=servicecatalog_create_portfolio]{create_portfolio} \tab Creates a portfolio\cr
\link[=servicecatalog_create_portfolio_share]{create_portfolio_share} \tab Shares the specified portfolio with the specified account or organization node\cr
\link[=servicecatalog_create_product]{create_product} \tab Creates a product\cr
\link[=servicecatalog_create_provisioned_product_plan]{create_provisioned_product_plan} \tab Creates a plan\cr
\link[=servicecatalog_create_provisioning_artifact]{create_provisioning_artifact} \tab Creates a provisioning artifact (also known as a version) for the specified product\cr
\link[=servicecatalog_create_service_action]{create_service_action} \tab Creates a self-service action\cr
\link[=servicecatalog_create_tag_option]{create_tag_option} \tab Creates a TagOption\cr
\link[=servicecatalog_delete_constraint]{delete_constraint} \tab Deletes the specified constraint\cr
\link[=servicecatalog_delete_portfolio]{delete_portfolio} \tab Deletes the specified portfolio\cr
\link[=servicecatalog_delete_portfolio_share]{delete_portfolio_share} \tab Stops sharing the specified portfolio with the specified account or organization node\cr
\link[=servicecatalog_delete_product]{delete_product} \tab Deletes the specified product\cr
\link[=servicecatalog_delete_provisioned_product_plan]{delete_provisioned_product_plan} \tab Deletes the specified plan\cr
\link[=servicecatalog_delete_provisioning_artifact]{delete_provisioning_artifact} \tab Deletes the specified provisioning artifact (also known as a version) for the specified product\cr
\link[=servicecatalog_delete_service_action]{delete_service_action} \tab Deletes a self-service action\cr
\link[=servicecatalog_delete_tag_option]{delete_tag_option} \tab Deletes the specified TagOption\cr
\link[=servicecatalog_describe_constraint]{describe_constraint} \tab Gets information about the specified constraint\cr
\link[=servicecatalog_describe_copy_product_status]{describe_copy_product_status} \tab Gets the status of the specified copy product operation\cr
\link[=servicecatalog_describe_portfolio]{describe_portfolio} \tab Gets information about the specified portfolio\cr
\link[=servicecatalog_describe_portfolio_shares]{describe_portfolio_shares} \tab Returns a summary of each of the portfolio shares that were created for the specified portfolio\cr
\link[=servicecatalog_describe_portfolio_share_status]{describe_portfolio_share_status} \tab Gets the status of the specified portfolio share operation\cr
\link[=servicecatalog_describe_product]{describe_product} \tab Gets information about the specified product\cr
\link[=servicecatalog_describe_product_as_admin]{describe_product_as_admin} \tab Gets information about the specified product\cr
\link[=servicecatalog_describe_product_view]{describe_product_view} \tab Gets information about the specified product\cr
\link[=servicecatalog_describe_provisioned_product]{describe_provisioned_product} \tab Gets information about the specified provisioned product\cr
\link[=servicecatalog_describe_provisioned_product_plan]{describe_provisioned_product_plan} \tab Gets information about the resource changes for the specified plan\cr
\link[=servicecatalog_describe_provisioning_artifact]{describe_provisioning_artifact} \tab Gets information about the specified provisioning artifact (also known as a version) for the specified product\cr
\link[=servicecatalog_describe_provisioning_parameters]{describe_provisioning_parameters} \tab Gets information about the configuration required to provision the specified product using the specified provisioning artifact\cr
\link[=servicecatalog_describe_record]{describe_record} \tab Gets information about the specified request operation\cr
\link[=servicecatalog_describe_service_action]{describe_service_action} \tab Describes a self-service action\cr
\link[=servicecatalog_describe_service_action_execution_parameters]{describe_service_action_execution_parameters} \tab Finds the default parameters for a specific self-service action on a specific provisioned product and returns a map of the results to the user\cr
\link[=servicecatalog_describe_tag_option]{describe_tag_option} \tab Gets information about the specified TagOption\cr
\link[=servicecatalog_disable_aws_organizations_access]{disable_aws_organizations_access} \tab Disable portfolio sharing through AWS Organizations feature\cr
\link[=servicecatalog_disassociate_budget_from_resource]{disassociate_budget_from_resource} \tab Disassociates the specified budget from the specified resource\cr
\link[=servicecatalog_disassociate_principal_from_portfolio]{disassociate_principal_from_portfolio} \tab Disassociates a previously associated principal ARN from a specified portfolio\cr
\link[=servicecatalog_disassociate_product_from_portfolio]{disassociate_product_from_portfolio} \tab Disassociates the specified product from the specified portfolio\cr
\link[=servicecatalog_disassociate_service_action_from_provisioning_artifact]{disassociate_service_action_from_provisioning_artifact} \tab Disassociates the specified self-service action association from the specified provisioning artifact\cr
\link[=servicecatalog_disassociate_tag_option_from_resource]{disassociate_tag_option_from_resource} \tab Disassociates the specified TagOption from the specified resource\cr
\link[=servicecatalog_enable_aws_organizations_access]{enable_aws_organizations_access} \tab Enable portfolio sharing feature through AWS Organizations\cr
\link[=servicecatalog_execute_provisioned_product_plan]{execute_provisioned_product_plan} \tab Provisions or modifies a product based on the resource changes for the specified plan\cr
\link[=servicecatalog_execute_provisioned_product_service_action]{execute_provisioned_product_service_action} \tab Executes a self-service action against a provisioned product\cr
\link[=servicecatalog_get_aws_organizations_access_status]{get_aws_organizations_access_status} \tab Get the Access Status for AWS Organization portfolio share feature\cr
\link[=servicecatalog_get_provisioned_product_outputs]{get_provisioned_product_outputs} \tab This API takes either a ProvisonedProductId or a ProvisionedProductName, along with a list of one or more output keys, and responds with the key/value pairs of those outputs\cr
\link[=servicecatalog_import_as_provisioned_product]{import_as_provisioned_product} \tab Requests the import of a resource as a Service Catalog provisioned product that is associated to a Service Catalog product and provisioning artifact\cr
\link[=servicecatalog_list_accepted_portfolio_shares]{list_accepted_portfolio_shares} \tab Lists all portfolios for which sharing was accepted by this account\cr
\link[=servicecatalog_list_budgets_for_resource]{list_budgets_for_resource} \tab Lists all the budgets associated to the specified resource\cr
\link[=servicecatalog_list_constraints_for_portfolio]{list_constraints_for_portfolio} \tab Lists the constraints for the specified portfolio and product\cr
\link[=servicecatalog_list_launch_paths]{list_launch_paths} \tab Lists the paths to the specified product\cr
\link[=servicecatalog_list_organization_portfolio_access]{list_organization_portfolio_access} \tab Lists the organization nodes that have access to the specified portfolio\cr
\link[=servicecatalog_list_portfolio_access]{list_portfolio_access} \tab Lists the account IDs that have access to the specified portfolio\cr
\link[=servicecatalog_list_portfolios]{list_portfolios} \tab Lists all portfolios in the catalog\cr
\link[=servicecatalog_list_portfolios_for_product]{list_portfolios_for_product} \tab Lists all portfolios that the specified product is associated with\cr
\link[=servicecatalog_list_principals_for_portfolio]{list_principals_for_portfolio} \tab Lists all principal ARNs associated with the specified portfolio\cr
\link[=servicecatalog_list_provisioned_product_plans]{list_provisioned_product_plans} \tab Lists the plans for the specified provisioned product or all plans to which the user has access\cr
\link[=servicecatalog_list_provisioning_artifacts]{list_provisioning_artifacts} \tab Lists all provisioning artifacts (also known as versions) for the specified product\cr
\link[=servicecatalog_list_provisioning_artifacts_for_service_action]{list_provisioning_artifacts_for_service_action} \tab Lists all provisioning artifacts (also known as versions) for the specified self-service action\cr
\link[=servicecatalog_list_record_history]{list_record_history} \tab Lists the specified requests or all performed requests\cr
\link[=servicecatalog_list_resources_for_tag_option]{list_resources_for_tag_option} \tab Lists the resources associated with the specified TagOption\cr
\link[=servicecatalog_list_service_actions]{list_service_actions} \tab Lists all self-service actions\cr
\link[=servicecatalog_list_service_actions_for_provisioning_artifact]{list_service_actions_for_provisioning_artifact} \tab Returns a paginated list of self-service actions associated with the specified Product ID and Provisioning Artifact ID\cr
\link[=servicecatalog_list_stack_instances_for_provisioned_product]{list_stack_instances_for_provisioned_product} \tab Returns summary information about stack instances that are associated with the specified CFN_STACKSET type provisioned product\cr
\link[=servicecatalog_list_tag_options]{list_tag_options} \tab Lists the specified TagOptions or all TagOptions\cr
\link[=servicecatalog_provision_product]{provision_product} \tab Provisions the specified product\cr
\link[=servicecatalog_reject_portfolio_share]{reject_portfolio_share} \tab Rejects an offer to share the specified portfolio\cr
\link[=servicecatalog_scan_provisioned_products]{scan_provisioned_products} \tab Lists the provisioned products that are available (not terminated)\cr
\link[=servicecatalog_search_products]{search_products} \tab Gets information about the products to which the caller has access\cr
\link[=servicecatalog_search_products_as_admin]{search_products_as_admin} \tab Gets information about the products for the specified portfolio or all products\cr
\link[=servicecatalog_search_provisioned_products]{search_provisioned_products} \tab Gets information about the provisioned products that meet the specified criteria\cr
\link[=servicecatalog_terminate_provisioned_product]{terminate_provisioned_product} \tab Terminates the specified provisioned product\cr
\link[=servicecatalog_update_constraint]{update_constraint} \tab Updates the specified constraint\cr
\link[=servicecatalog_update_portfolio]{update_portfolio} \tab Updates the specified portfolio\cr
\link[=servicecatalog_update_portfolio_share]{update_portfolio_share} \tab Updates the specified portfolio share\cr
\link[=servicecatalog_update_product]{update_product} \tab Updates the specified product\cr
\link[=servicecatalog_update_provisioned_product]{update_provisioned_product} \tab Requests updates to the configuration of the specified provisioned product\cr
\link[=servicecatalog_update_provisioned_product_properties]{update_provisioned_product_properties} \tab Requests updates to the properties of the specified provisioned product\cr
\link[=servicecatalog_update_provisioning_artifact]{update_provisioning_artifact} \tab Updates the specified provisioning artifact (also known as a version) for the specified product\cr
\link[=servicecatalog_update_service_action]{update_service_action} \tab Updates a self-service action\cr
\link[=servicecatalog_update_tag_option]{update_tag_option} \tab Updates the specified TagOption
}
}

\examples{
\dontrun{
svc <- servicecatalog()
svc$accept_portfolio_share(
  Foo = 123
)
}

}
