# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include servicequotas_service.R
NULL

#' Associates the Service Quotas template with your organization so that
#' when new accounts are created in your organization, the template submits
#' increase requests for the specified service quotas
#'
#' Associates the Service Quotas template with your organization so that
#' when new accounts are created in your organization, the template submits
#' increase requests for the specified service quotas. Use the Service
#' Quotas template to request an increase for any adjustable quota value.
#' After you define the Service Quotas template, use this operation to
#' associate, or enable, the template.
#'
#' @usage
#' servicequotas_associate_service_quota_template()
#'
#' @section Request syntax:
#' ```
#' svc$associate_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_associate_service_quota_template
servicequotas_associate_service_quota_template <- function() {
  op <- new_operation(
    name = "AssociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$associate_service_quota_template_input()
  output <- .servicequotas$associate_service_quota_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$associate_service_quota_template <- servicequotas_associate_service_quota_template

#' Removes a service quota increase request from the Service Quotas
#' template
#'
#' Removes a service quota increase request from the Service Quotas
#' template.
#'
#' @usage
#' servicequotas_delete_service_quota_increase_request_from_template(
#'   ServiceCode, QuotaCode, AwsRegion)
#'
#' @param ServiceCode &#91;required&#93; Specifies the code for the service that you want to delete.
#' @param QuotaCode &#91;required&#93; Specifies the code for the quota that you want to delete.
#' @param AwsRegion &#91;required&#93; Specifies the AWS Region for the quota that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service_quota_increase_request_from_template(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   AwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_delete_service_quota_increase_request_from_template
servicequotas_delete_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "DeleteServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$delete_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$delete_service_quota_increase_request_from_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$delete_service_quota_increase_request_from_template <- servicequotas_delete_service_quota_increase_request_from_template

#' Disables the Service Quotas template
#'
#' Disables the Service Quotas template. Once the template is disabled, it
#' does not request quota increases for new accounts in your organization.
#' Disabling the quota template does not apply the quota increase requests
#' from the template.
#' 
#' **Related operations**
#' 
#' -   To enable the quota template, call AssociateServiceQuotaTemplate.
#' 
#' -   To delete a specific service quota from the template, use
#'     DeleteServiceQuotaIncreaseRequestFromTemplate.
#'
#' @usage
#' servicequotas_disassociate_service_quota_template()
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_disassociate_service_quota_template
servicequotas_disassociate_service_quota_template <- function() {
  op <- new_operation(
    name = "DisassociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$disassociate_service_quota_template_input()
  output <- .servicequotas$disassociate_service_quota_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$disassociate_service_quota_template <- servicequotas_disassociate_service_quota_template

#' Retrieves the default service quotas values
#'
#' Retrieves the default service quotas values. The Value returned for each
#' quota is the AWS default value, even if the quotas have been increased..
#'
#' @usage
#' servicequotas_get_aws_default_service_quota(ServiceCode, QuotaCode)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param QuotaCode &#91;required&#93; Identifies the service quota you want to select.
#'
#' @section Request syntax:
#' ```
#' svc$get_aws_default_service_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_aws_default_service_quota
servicequotas_get_aws_default_service_quota <- function(ServiceCode, QuotaCode) {
  op <- new_operation(
    name = "GetAWSDefaultServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_aws_default_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode)
  output <- .servicequotas$get_aws_default_service_quota_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_aws_default_service_quota <- servicequotas_get_aws_default_service_quota

#' Retrieves the ServiceQuotaTemplateAssociationStatus value from the
#' service
#'
#' Retrieves the `ServiceQuotaTemplateAssociationStatus` value from the
#' service. Use this action to determine if the Service Quota template is
#' associated, or enabled.
#'
#' @usage
#' servicequotas_get_association_for_service_quota_template()
#'
#' @section Request syntax:
#' ```
#' svc$get_association_for_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_association_for_service_quota_template
servicequotas_get_association_for_service_quota_template <- function() {
  op <- new_operation(
    name = "GetAssociationForServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_association_for_service_quota_template_input()
  output <- .servicequotas$get_association_for_service_quota_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_association_for_service_quota_template <- servicequotas_get_association_for_service_quota_template

#' Retrieves the details for a particular increase request
#'
#' Retrieves the details for a particular increase request.
#'
#' @usage
#' servicequotas_get_requested_service_quota_change(RequestId)
#'
#' @param RequestId &#91;required&#93; Identifies the quota increase request.
#'
#' @section Request syntax:
#' ```
#' svc$get_requested_service_quota_change(
#'   RequestId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_requested_service_quota_change
servicequotas_get_requested_service_quota_change <- function(RequestId) {
  op <- new_operation(
    name = "GetRequestedServiceQuotaChange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_requested_service_quota_change_input(RequestId = RequestId)
  output <- .servicequotas$get_requested_service_quota_change_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_requested_service_quota_change <- servicequotas_get_requested_service_quota_change

#' Returns the details for the specified service quota
#'
#' Returns the details for the specified service quota. This operation
#' provides a different Value than the `GetAWSDefaultServiceQuota`
#' operation. This operation returns the applied value for each quota.
#' `GetAWSDefaultServiceQuota` returns the default AWS value for each
#' quota.
#'
#' @usage
#' servicequotas_get_service_quota(ServiceCode, QuotaCode)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param QuotaCode &#91;required&#93; Identifies the service quota you want to select.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_service_quota
servicequotas_get_service_quota <- function(ServiceCode, QuotaCode) {
  op <- new_operation(
    name = "GetServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode)
  output <- .servicequotas$get_service_quota_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota <- servicequotas_get_service_quota

#' Returns the details of the service quota increase request in your
#' template
#'
#' Returns the details of the service quota increase request in your
#' template.
#'
#' @usage
#' servicequotas_get_service_quota_increase_request_from_template(
#'   ServiceCode, QuotaCode, AwsRegion)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param QuotaCode &#91;required&#93; Specifies the quota you want.
#' @param AwsRegion &#91;required&#93; Specifies the AWS Region for the quota that you want to use.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_quota_increase_request_from_template(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   AwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_service_quota_increase_request_from_template
servicequotas_get_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "GetServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$get_service_quota_increase_request_from_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota_increase_request_from_template <- servicequotas_get_service_quota_increase_request_from_template

#' Lists all default service quotas for the specified AWS service or all
#' AWS services
#'
#' Lists all default service quotas for the specified AWS service or all
#' AWS services. ListAWSDefaultServiceQuotas is similar to
#' ListServiceQuotas except for the Value object. The Value object returned
#' by `ListAWSDefaultServiceQuotas` is the default value assigned by AWS.
#' This request returns a list of all service quotas for the specified
#' service. The listing of each you\'ll see the default values are the
#' values that AWS provides for the quotas.
#' 
#' Always check the `NextToken` response parameter when calling any of the
#' `List*` operations. These operations can return an unexpected list of
#' results, even when there are more results available. When this happens,
#' the `NextToken` response parameter contains a value to pass the next
#' call to the same API to request the next part of the list.
#'
#' @usage
#' servicequotas_list_aws_default_service_quotas(ServiceCode, NextToken,
#'   MaxResults)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from. If additional items exist beyond the specified maximum,
#' the `NextToken` element is present and has a value (isn\'t null).
#' Include that value as the `NextToken` request parameter in the call to
#' the operation to get the next part of the results. You should check
#' `NextToken` after every operation to ensure that you receive all of the
#' results.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_aws_default_service_quotas(
#'   ServiceCode = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_aws_default_service_quotas
servicequotas_list_aws_default_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAWSDefaultServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_aws_default_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_aws_default_service_quotas_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_aws_default_service_quotas <- servicequotas_list_aws_default_service_quotas

#' Requests a list of the changes to quotas for a service
#'
#' Requests a list of the changes to quotas for a service.
#'
#' @usage
#' servicequotas_list_requested_service_quota_change_history(ServiceCode,
#'   Status, NextToken, MaxResults)
#'
#' @param ServiceCode Specifies the service that you want to use.
#' @param Status Specifies the status value of the quota increase request.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_requested_service_quota_change_history(
#'   ServiceCode = "string",
#'   Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_requested_service_quota_change_history
servicequotas_list_requested_service_quota_change_history <- function(ServiceCode = NULL, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_requested_service_quota_change_history_input(ServiceCode = ServiceCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_requested_service_quota_change_history_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history <- servicequotas_list_requested_service_quota_change_history

#' Requests a list of the changes to specific service quotas
#'
#' Requests a list of the changes to specific service quotas. This command
#' provides additional granularity over the
#' `ListRequestedServiceQuotaChangeHistory` command. Once a quota change
#' request has reached `CASE_CLOSED, APPROVED,` or `DENIED`, the history
#' has been kept for 90 days.
#'
#' @usage
#' servicequotas_list_requested_service_quota_change_history_by_quota(
#'   ServiceCode, QuotaCode, Status, NextToken, MaxResults)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param QuotaCode &#91;required&#93; Specifies the service quota that you want to use
#' @param Status Specifies the status value of the quota increase request.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_requested_service_quota_change_history_by_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_requested_service_quota_change_history_by_quota
servicequotas_list_requested_service_quota_change_history_by_quota <- function(ServiceCode, QuotaCode, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistoryByQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_requested_service_quota_change_history_by_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_requested_service_quota_change_history_by_quota_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history_by_quota <- servicequotas_list_requested_service_quota_change_history_by_quota

#' Returns a list of the quota increase requests in the template
#'
#' Returns a list of the quota increase requests in the template.
#'
#' @usage
#' servicequotas_list_service_quota_increase_requests_in_template(
#'   ServiceCode, AwsRegion, NextToken, MaxResults)
#'
#' @param ServiceCode The identifier for a service. When performing an operation, use the
#' `ServiceCode` to specify a particular service.
#' @param AwsRegion Specifies the AWS Region for the quota that you want to use.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_service_quota_increase_requests_in_template(
#'   ServiceCode = "string",
#'   AwsRegion = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_service_quota_increase_requests_in_template
servicequotas_list_service_quota_increase_requests_in_template <- function(ServiceCode = NULL, AwsRegion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServiceQuotaIncreaseRequestsInTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_service_quota_increase_requests_in_template_input(ServiceCode = ServiceCode, AwsRegion = AwsRegion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_service_quota_increase_requests_in_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quota_increase_requests_in_template <- servicequotas_list_service_quota_increase_requests_in_template

#' Lists all service quotas for the specified AWS service
#'
#' Lists all service quotas for the specified AWS service. This request
#' returns a list of the service quotas for the specified service. you\'ll
#' see the default values are the values that AWS provides for the quotas.
#' 
#' Always check the `NextToken` response parameter when calling any of the
#' `List*` operations. These operations can return an unexpected list of
#' results, even when there are more results available. When this happens,
#' the `NextToken` response parameter contains a value to pass the next
#' call to the same API to request the next part of the list.
#'
#' @usage
#' servicequotas_list_service_quotas(ServiceCode, NextToken, MaxResults)
#'
#' @param ServiceCode &#91;required&#93; The identifier for a service. When performing an operation, use the
#' `ServiceCode` to specify a particular service.
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_service_quotas(
#'   ServiceCode = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_service_quotas
servicequotas_list_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_service_quotas_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quotas <- servicequotas_list_service_quotas

#' Lists the AWS services available in Service Quotas
#'
#' Lists the AWS services available in Service Quotas. Not all AWS services
#' are available in Service Quotas. To list the see the list of the service
#' quotas for a specific service, use ListServiceQuotas.
#'
#' @usage
#' servicequotas_list_services(NextToken, MaxResults)
#'
#' @param NextToken (Optional) Use this parameter in a request if you receive a `NextToken`
#' response in a previous request that indicates that there\'s more output
#' available. In a subsequent call, set it to the value of the previous
#' call\'s `NextToken` response to indicate where the output should
#' continue from.
#' @param MaxResults (Optional) Limits the number of results that you want to include in the
#' response. If you don\'t include this parameter, the response defaults to
#' a value that\'s specific to the operation. If additional items exist
#' beyond the specified maximum, the `NextToken` element is present and has
#' a value (isn\'t null). Include that value as the `NextToken` request
#' parameter in the call to the operation to get the next part of the
#' results. You should check `NextToken` after every operation to ensure
#' that you receive all of the results.
#'
#' @section Request syntax:
#' ```
#' svc$list_services(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_services
servicequotas_list_services <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_services_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_services_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_services <- servicequotas_list_services

#' Defines and adds a quota to the service quota template
#'
#' Defines and adds a quota to the service quota template. To add a quota
#' to the template, you must provide the `ServiceCode`, `QuotaCode`,
#' `AwsRegion`, and `DesiredValue`. Once you add a quota to the template,
#' use ListServiceQuotaIncreaseRequestsInTemplate to see the list of quotas
#' in the template.
#'
#' @usage
#' servicequotas_put_service_quota_increase_request_into_template(
#'   QuotaCode, ServiceCode, AwsRegion, DesiredValue)
#'
#' @param QuotaCode &#91;required&#93; Specifies the service quota that you want to use.
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param AwsRegion &#91;required&#93; Specifies the AWS Region for the quota.
#' @param DesiredValue &#91;required&#93; Specifies the new, increased value for the quota.
#'
#' @section Request syntax:
#' ```
#' svc$put_service_quota_increase_request_into_template(
#'   QuotaCode = "string",
#'   ServiceCode = "string",
#'   AwsRegion = "string",
#'   DesiredValue = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_put_service_quota_increase_request_into_template
servicequotas_put_service_quota_increase_request_into_template <- function(QuotaCode, ServiceCode, AwsRegion, DesiredValue) {
  op <- new_operation(
    name = "PutServiceQuotaIncreaseRequestIntoTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$put_service_quota_increase_request_into_template_input(QuotaCode = QuotaCode, ServiceCode = ServiceCode, AwsRegion = AwsRegion, DesiredValue = DesiredValue)
  output <- .servicequotas$put_service_quota_increase_request_into_template_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$put_service_quota_increase_request_into_template <- servicequotas_put_service_quota_increase_request_into_template

#' Retrieves the details of a service quota increase request
#'
#' Retrieves the details of a service quota increase request. The response
#' to this command provides the details in the RequestedServiceQuotaChange
#' object.
#'
#' @usage
#' servicequotas_request_service_quota_increase(ServiceCode, QuotaCode,
#'   DesiredValue)
#'
#' @param ServiceCode &#91;required&#93; Specifies the service that you want to use.
#' @param QuotaCode &#91;required&#93; Specifies the service quota that you want to use.
#' @param DesiredValue &#91;required&#93; Specifies the value submitted in the service quota increase request.
#'
#' @section Request syntax:
#' ```
#' svc$request_service_quota_increase(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   DesiredValue = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_request_service_quota_increase
servicequotas_request_service_quota_increase <- function(ServiceCode, QuotaCode, DesiredValue) {
  op <- new_operation(
    name = "RequestServiceQuotaIncrease",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$request_service_quota_increase_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, DesiredValue = DesiredValue)
  output <- .servicequotas$request_service_quota_increase_output()
  svc <- .servicequotas$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$request_service_quota_increase <- servicequotas_request_service_quota_increase
