% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_enable_policy_type}
\alias{organizations_enable_policy_type}
\title{Enables a policy type in a root}
\usage{
organizations_enable_policy_type(RootId, PolicyType)
}
\arguments{
\item{RootId}{[required] The unique identifier (ID) of the root in which you want to enable a
policy type. You can get the ID from the ListRoots operation.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a root ID
string requires "r-" followed by from 4 to 32 lower-case letters or
digits.}

\item{PolicyType}{[required] The policy type that you want to enable.}
}
\description{
Enables a policy type in a root. After you enable a policy type in a
root, you can attach policies of that type to the root, any
organizational unit (OU), or account in that root. You can undo this by
using the DisablePolicyType operation.
}
\details{
This operation can be called only from the organization's master
account.

You can enable a policy type in a root only if that policy type is
available in the organization. Use DescribeOrganization to view the
status of available policy types in the organization.

To view the status of policy type in a root, use ListRoots.
}
\section{Request syntax}{
\preformatted{svc$enable_policy_type(
  RootId = "string",
  PolicyType = "SERVICE_CONTROL_POLICY"
)
}
}

\examples{
# The following example shows how to enable the service control policy
# (SCP) policy type in a root. The output shows a root object with a
# PolicyTypes response element showing that SCPs are now enabled:/n/n
\donttest{svc$enable_policy_type(
  PolicyType = "SERVICE_CONTROL_POLICY",
  RootId = "r-examplerootid111"
)}

}
\keyword{internal}
