% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_list_inventory_entries}
\alias{ssm_list_inventory_entries}
\title{A list of inventory items returned by the request}
\usage{
ssm_list_inventory_entries(InstanceId, TypeName, Filters, NextToken,
  MaxResults)
}
\arguments{
\item{InstanceId}{[required] The instance ID for which you want inventory information.}

\item{TypeName}{[required] The type of inventory item for which you want information.}

\item{Filters}{One or more filters. Use a filter to return a more specific list of
results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}
}
\description{
A list of inventory items returned by the request.
}
\section{Request syntax}{
\preformatted{svc$list_inventory_entries(
  InstanceId = "string",
  TypeName = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      ),
      Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
