% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_put_event_selectors}
\alias{cloudtrail_put_event_selectors}
\title{Configures an event selector for your trail}
\usage{
cloudtrail_put_event_selectors(TrailName, EventSelectors)
}
\arguments{
\item{TrailName}{[required] Specifies the name of the trail or trail ARN. If you specify a trail
name, the string must meet the following requirements:
\itemize{
\item Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.),
underscores (\\_), or dashes (-)
\item Start with a letter or number, and end with a letter or number
\item Be between 3 and 128 characters
\item Have no adjacent periods, underscores or dashes. Names like
\verb{my-_namespace} and \code{my--namespace} are invalid.
\item Not be in IP address format (for example, 192.168.5.4)
}

If you specify a trail ARN, it must be in the format:

\code{arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail}}

\item{EventSelectors}{[required] Specifies the settings for your event selectors. You can configure up to
five event selectors for a trail.}
}
\description{
Configures an event selector for your trail. Use event selectors to
further specify the management and data event settings for your trail.
By default, trails created without specific event selectors will be
configured to log all read and write management events, and no data
events.
}
\details{
When an event occurs in your account, CloudTrail evaluates the event
selectors in all trails. For each trail, if the event matches any event
selector, the trail processes and logs the event. If the event doesn\'t
match any event selector, the trail doesn\'t log the event.

Example
\enumerate{
\item You create an event selector for a trail and specify that you want
write-only events.
\item The EC2 \code{GetConsoleOutput} and \code{RunInstances} API operations occur
in your account.
\item CloudTrail evaluates whether the events match your event selectors.
\item The \code{RunInstances} is a write-only event and it matches your event
selector. The trail logs the event.
\item The \code{GetConsoleOutput} is a read-only event but it doesn\'t match
your event selector. The trail doesn\'t log the event.
}

The \code{PutEventSelectors} operation must be called from the region in
which the trail was created; otherwise, an \code{InvalidHomeRegionException}
is thrown.

You can configure up to five event selectors for each trail. For more
information, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-and-data-events-with-cloudtrail.html}{Logging Data and Management Events for Trails}
and \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html}{Limits in AWS CloudTrail}
in the \emph{AWS CloudTrail User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_event_selectors(
  TrailName = "string",
  EventSelectors = list(
    list(
      ReadWriteType = "ReadOnly"|"WriteOnly"|"All",
      IncludeManagementEvents = TRUE|FALSE,
      DataResources = list(
        list(
          Type = "string",
          Values = list(
            "string"
          )
        )
      ),
      ExcludeManagementEventSources = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
