% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioned_product}
\alias{servicecatalog_update_provisioned_product}
\title{Requests updates to the configuration of the specified provisioned
product}
\usage{
servicecatalog_update_provisioned_product(AcceptLanguage,
  ProvisionedProductName, ProvisionedProductId, ProductId,
  ProvisioningArtifactId, PathId, ProvisioningParameters,
  ProvisioningPreferences, Tags, UpdateToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProvisionedProductName}{The name of the provisioned product. You cannot specify both
\code{ProvisionedProductName} and \code{ProvisionedProductId}.}

\item{ProvisionedProductId}{The identifier of the provisioned product. You cannot specify both
\code{ProvisionedProductName} and \code{ProvisionedProductId}.}

\item{ProductId}{The identifier of the product.}

\item{ProvisioningArtifactId}{The identifier of the provisioning artifact.}

\item{PathId}{The new path identifier. This value is optional if the product has a
default path, and required if the product has more than one path.}

\item{ProvisioningParameters}{The new parameters.}

\item{ProvisioningPreferences}{An object that contains information about the provisioning preferences
for a stack set.}

\item{Tags}{One or more tags. Requires the product to have \code{RESOURCE_UPDATE}
constraint with \code{TagUpdatesOnProvisionedProduct} set to \code{ALLOWED} to
allow tag updates.}

\item{UpdateToken}{[required] The idempotency token that uniquely identifies the provisioning update
request.}
}
\description{
Requests updates to the configuration of the specified provisioned
product.
}
\details{
If there are tags associated with the object, they cannot be updated or
added. Depending on the specific updates requested, this operation can
update with no interruption, with some interruption, or replace the
provisioned product entirely.

You can check the status of this request using DescribeRecord.
}
\section{Request syntax}{
\preformatted{svc$update_provisioned_product(
  AcceptLanguage = "string",
  ProvisionedProductName = "string",
  ProvisionedProductId = "string",
  ProductId = "string",
  ProvisioningArtifactId = "string",
  PathId = "string",
  ProvisioningParameters = list(
    list(
      Key = "string",
      Value = "string",
      UsePreviousValue = TRUE|FALSE
    )
  ),
  ProvisioningPreferences = list(
    StackSetAccounts = list(
      "string"
    ),
    StackSetRegions = list(
      "string"
    ),
    StackSetFailureToleranceCount = 123,
    StackSetFailureTolerancePercentage = 123,
    StackSetMaxConcurrencyCount = 123,
    StackSetMaxConcurrencyPercentage = 123,
    StackSetOperationType = "CREATE"|"UPDATE"|"DELETE"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  UpdateToken = "string"
)
}
}

\keyword{internal}
