% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationautoscaling_operations.R
\name{applicationautoscaling_put_scaling_policy}
\alias{applicationautoscaling_put_scaling_policy}
\title{Creates or updates a policy for an Application Auto Scaling scalable
target}
\usage{
applicationautoscaling_put_scaling_policy(PolicyName, ServiceNamespace,
  ResourceId, ScalableDimension, PolicyType,
  StepScalingPolicyConfiguration,
  TargetTrackingScalingPolicyConfiguration)
}
\arguments{
\item{PolicyName}{[required] The name of the scaling policy.}

\item{ServiceNamespace}{[required] The namespace of the AWS service that provides the resource or
\code{custom-resource} for a resource provided by your own application or
service. For more information, see \href{http://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#genref-aws-service-namespaces}{AWS Service Namespaces}
in the \emph{Amazon Web Services General Reference}.}

\item{ResourceId}{[required] The identifier of the resource associated with the scaling policy. This
string consists of the resource type and unique identifier.
\itemize{
\item ECS service - The resource type is \code{service} and the unique
identifier is the cluster name and service name. Example:
\code{service/default/sample-webapp}.
\item Spot Fleet request - The resource type is \code{spot-fleet-request} and
the unique identifier is the Spot Fleet request ID. Example:
\verb{spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE}.
\item EMR cluster - The resource type is \code{instancegroup} and the unique
identifier is the cluster ID and instance group ID. Example:
\verb{instancegroup/j-2EEZNYKUA1NTV/ig-1791Y4E1L8YI0}.
\item AppStream 2.0 fleet - The resource type is \code{fleet} and the unique
identifier is the fleet name. Example: \code{fleet/sample-fleet}.
\item DynamoDB table - The resource type is \code{table} and the unique
identifier is the table name. Example: \code{table/my-table}.
\item DynamoDB global secondary index - The resource type is \code{index} and
the unique identifier is the index name. Example:
\code{table/my-table/index/my-table-index}.
\item Aurora DB cluster - The resource type is \code{cluster} and the unique
identifier is the cluster name. Example: \code{cluster:my-db-cluster}.
\item Amazon SageMaker endpoint variant - The resource type is \code{variant}
and the unique identifier is the resource ID. Example:
\code{endpoint/my-end-point/variant/KMeansClustering}.
\item Custom resources are not supported with a resource type. This
parameter must specify the \code{OutputValue} from the CloudFormation
template stack used to access the resources. The unique identifier
is defined by the service provider. More information is available in
our \href{https://github.com/aws/aws-auto-scaling-custom-resource}{GitHub repository}.
\item Amazon Comprehend document classification endpoint - The resource
type and unique identifier are specified using the endpoint ARN.
Example:
\code{arn:aws:comprehend:us-west-2:123456789012:document-classifier-endpoint/EXAMPLE}.
\item Lambda provisioned concurrency - The resource type is \code{function} and
the unique identifier is the function name with a function version
or alias name suffix that is not \verb{$LATEST}. Example:
\verb{function:my-function:prod} or \verb{function:my-function:1}.
}}

\item{ScalableDimension}{[required] The scalable dimension. This string consists of the service namespace,
resource type, and scaling property.
\itemize{
\item \code{ecs:service:DesiredCount} - The desired task count of an ECS
service.
\item \code{ec2:spot-fleet-request:TargetCapacity} - The target capacity of a
Spot Fleet request.
\item \code{elasticmapreduce:instancegroup:InstanceCount} - The instance count
of an EMR Instance Group.
\item \code{appstream:fleet:DesiredCapacity} - The desired capacity of an
AppStream 2.0 fleet.
\item \code{dynamodb:table:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB table.
\item \code{dynamodb:table:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB table.
\item \code{dynamodb:index:ReadCapacityUnits} - The provisioned read capacity
for a DynamoDB global secondary index.
\item \code{dynamodb:index:WriteCapacityUnits} - The provisioned write capacity
for a DynamoDB global secondary index.
\item \code{rds:cluster:ReadReplicaCount} - The count of Aurora Replicas in an
Aurora DB cluster. Available for Aurora MySQL-compatible edition and
Aurora PostgreSQL-compatible edition.
\item \code{sagemaker:variant:DesiredInstanceCount} - The number of EC2
instances for an Amazon SageMaker model endpoint variant.
\item \code{custom-resource:ResourceType:Property} - The scalable dimension for
a custom resource provided by your own application or service.
\item \code{comprehend:document-classifier-endpoint:DesiredInferenceUnits} -
The number of inference units for an Amazon Comprehend document
classification endpoint.
\item \verb{lambda:function:ProvisionedConcurrency} - The provisioned
concurrency for a Lambda function.
}}

\item{PolicyType}{The policy type. This parameter is required if you are creating a
scaling policy.

The following policy types are supported:

\code{TargetTrackingScaling}---Not supported for Amazon EMR

\code{StepScaling}---Not supported for DynamoDB, Amazon Comprehend, or AWS
Lambda

For more information, see \href{https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-target-tracking.html}{Target Tracking Scaling Policies}
and \href{https://docs.aws.amazon.com/autoscaling/application/userguide/application-auto-scaling-step-scaling-policies.html}{Step Scaling Policies}
in the \emph{Application Auto Scaling User Guide}.}

\item{StepScalingPolicyConfiguration}{A step scaling policy.

This parameter is required if you are creating a policy and the policy
type is \code{StepScaling}.}

\item{TargetTrackingScalingPolicyConfiguration}{A target tracking scaling policy. Includes support for predefined or
customized metrics.

This parameter is required if you are creating a policy and the policy
type is \code{TargetTrackingScaling}.}
}
\description{
Creates or updates a policy for an Application Auto Scaling scalable
target.
}
\details{
Each scalable target is identified by a service namespace, resource ID,
and scalable dimension. A scaling policy applies to the scalable target
identified by those three attributes. You cannot create a scaling policy
until you have registered the resource as a scalable target using
RegisterScalableTarget.

To update a policy, specify its policy name and the parameters that you
want to change. Any parameters that you don\'t specify are not changed
by this update request.

You can view the scaling policies for a service namespace using
DescribeScalingPolicies. If you are no longer using a scaling policy,
you can delete it using DeleteScalingPolicy.

Multiple scaling policies can be in force at the same time for the same
scalable target. You can have one or more target tracking scaling
policies, one or more step scaling policies, or both. However, there is
a chance that multiple policies could conflict, instructing the scalable
target to scale out or in at the same time. Application Auto Scaling
gives precedence to the policy that provides the largest capacity for
both scale out and scale in. For example, if one policy increases
capacity by 3, another policy increases capacity by 200 percent, and the
current capacity is 10, Application Auto Scaling uses the policy with
the highest calculated capacity (200\% of 10 = 20) and scales out to 30.

Learn more about how to work with scaling policies in the \href{https://docs.aws.amazon.com/autoscaling/application/userguide/what-is-application-auto-scaling.html}{Application Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$put_scaling_policy(
  PolicyName = "string",
  ServiceNamespace = "ecs"|"elasticmapreduce"|"ec2"|"appstream"|"dynamodb"|"rds"|"sagemaker"|"custom-resource"|"comprehend"|"lambda",
  ResourceId = "string",
  ScalableDimension = "ecs:service:DesiredCount"|"ec2:spot-fleet-request:TargetCapacity"|"elasticmapreduce:instancegroup:InstanceCount"|"appstream:fleet:DesiredCapacity"|"dynamodb:table:ReadCapacityUnits"|"dynamodb:table:WriteCapacityUnits"|"dynamodb:index:ReadCapacityUnits"|"dynamodb:index:WriteCapacityUnits"|"rds:cluster:ReadReplicaCount"|"sagemaker:variant:DesiredInstanceCount"|"custom-resource:ResourceType:Property"|"comprehend:document-classifier-endpoint:DesiredInferenceUnits"|"lambda:function:ProvisionedConcurrency",
  PolicyType = "StepScaling"|"TargetTrackingScaling",
  StepScalingPolicyConfiguration = list(
    AdjustmentType = "ChangeInCapacity"|"PercentChangeInCapacity"|"ExactCapacity",
    StepAdjustments = list(
      list(
        MetricIntervalLowerBound = 123.0,
        MetricIntervalUpperBound = 123.0,
        ScalingAdjustment = 123
      )
    ),
    MinAdjustmentMagnitude = 123,
    Cooldown = 123,
    MetricAggregationType = "Average"|"Minimum"|"Maximum"
  ),
  TargetTrackingScalingPolicyConfiguration = list(
    TargetValue = 123.0,
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "DynamoDBReadCapacityUtilization"|"DynamoDBWriteCapacityUtilization"|"ALBRequestCountPerTarget"|"RDSReaderAverageCPUUtilization"|"RDSReaderAverageDatabaseConnections"|"EC2SpotFleetRequestAverageCPUUtilization"|"EC2SpotFleetRequestAverageNetworkIn"|"EC2SpotFleetRequestAverageNetworkOut"|"SageMakerVariantInvocationsPerInstance"|"ECSServiceAverageCPUUtilization"|"ECSServiceAverageMemoryUtilization"|"AppStreamAverageCapacityUtilization"|"ComprehendInferenceUtilization"|"LambdaProvisionedConcurrencyUtilization",
      ResourceLabel = "string"
    ),
    CustomizedMetricSpecification = list(
      MetricName = "string",
      Namespace = "string",
      Dimensions = list(
        list(
          Name = "string",
          Value = "string"
        )
      ),
      Statistic = "Average"|"Minimum"|"Maximum"|"SampleCount"|"Sum",
      Unit = "string"
    ),
    ScaleOutCooldown = 123,
    ScaleInCooldown = 123,
    DisableScaleIn = TRUE|FALSE
  )
)
}
}

\examples{
\dontrun{
# The following example applies a target tracking scaling policy with a
# predefined metric specification to an Amazon ECS service called web-app
# in the default cluster. The policy keeps the average CPU utilization of
# the service at 75 percent, with scale-out and scale-in cooldown periods
# of 60 seconds.
svc$put_scaling_policy(
  PolicyName = "cpu75-target-tracking-scaling-policy",
  PolicyType = "TargetTrackingScaling",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs",
  TargetTrackingScalingPolicyConfiguration = list(
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ECSServiceAverageCPUUtilization"
    ),
    ScaleInCooldown = 60L,
    ScaleOutCooldown = 60L,
    TargetValue = 75L
  )
)

# The following example applies a target tracking scaling policy with a
# customized metric specification to an Amazon ECS service called web-app
# in the default cluster. The policy keeps the average utilization of the
# service at 75 percent, with scale-out and scale-in cooldown periods of
# 60 seconds.
svc$put_scaling_policy(
  PolicyName = "cms75-target-tracking-scaling-policy",
  PolicyType = "TargetTrackingScaling",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs",
  TargetTrackingScalingPolicyConfiguration = list(
    CustomizedMetricSpecification = list(
      Dimensions = list(
        list(
          Name = "MyOptionalMetricDimensionName",
          Value = "MyOptionalMetricDimensionValue"
        )
      ),
      MetricName = "MyUtilizationMetric",
      Namespace = "MyNamespace",
      Statistic = "Average",
      Unit = "Percent"
    ),
    ScaleInCooldown = 60L,
    ScaleOutCooldown = 60L,
    TargetValue = 75L
  )
)

# The following example applies a target tracking scaling policy to an
# Amazon ECS service called web-app in the default cluster. The policy is
# used to scale out the ECS service when the RequestCountPerTarget metric
# from the Application Load Balancer exceeds the threshold.
svc$put_scaling_policy(
  PolicyName = "alb-scale-out-target-tracking-scaling-policy",
  PolicyType = "TargetTrackingScaling",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs",
  TargetTrackingScalingPolicyConfiguration = list(
    DisableScaleIn = TRUE,
    PredefinedMetricSpecification = list(
      PredefinedMetricType = "ALBRequestCountPerTarget",
      ResourceLabel = "app/EC2Co-EcsEl-1TKLTMITMM0EO/f37c06a68c1748aa/targetgroup/EC2Co-Defa..."
    ),
    ScaleInCooldown = 60L,
    ScaleOutCooldown = 60L,
    TargetValue = 1000L
  )
)

# This example applies a step scaling policy to an Amazon ECS service
# called web-app in the default cluster. The policy increases the desired
# count of the service by 200\%, with a cool down period of 60 seconds.
svc$put_scaling_policy(
  PolicyName = "web-app-cpu-gt-75",
  PolicyType = "StepScaling",
  ResourceId = "service/default/web-app",
  ScalableDimension = "ecs:service:DesiredCount",
  ServiceNamespace = "ecs",
  StepScalingPolicyConfiguration = list(
    AdjustmentType = "PercentChangeInCapacity",
    Cooldown = 60L,
    StepAdjustments = list(
      list(
        MetricIntervalLowerBound = 0L,
        ScalingAdjustment = 200L
      )
    )
  )
)

# This example applies a step scaling policy to an Amazon EC2 Spot fleet.
# The policy increases the target capacity of the spot fleet by 200\%, with
# a cool down period of 180 seconds.",
# 
svc$put_scaling_policy(
  PolicyName = "fleet-cpu-gt-75",
  PolicyType = "StepScaling",
  ResourceId = "spot-fleet-request/sfr-45e69d8a-be48-4539-bbf3-3464e99c50c3",
  ScalableDimension = "ec2:spot-fleet-request:TargetCapacity",
  ServiceNamespace = "ec2",
  StepScalingPolicyConfiguration = list(
    AdjustmentType = "PercentChangeInCapacity",
    Cooldown = 180L,
    StepAdjustments = list(
      list(
        MetricIntervalLowerBound = 0L,
        ScalingAdjustment = 200L
      )
    )
  )
)
}

}
\keyword{internal}
