% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_complete_lifecycle_action}
\alias{autoscaling_complete_lifecycle_action}
\title{Completes the lifecycle action for the specified token or instance with
the specified result}
\usage{
autoscaling_complete_lifecycle_action(
  LifecycleHookName,
  AutoScalingGroupName,
  LifecycleActionToken = NULL,
  LifecycleActionResult,
  InstanceId = NULL
)
}
\arguments{
\item{LifecycleHookName}{[required] The name of the lifecycle hook.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LifecycleActionToken}{A universally unique identifier (UUID) that identifies a specific
lifecycle action associated with an instance. Amazon EC2 Auto Scaling
sends this token to the notification target you specified when you
created the lifecycle hook.}

\item{LifecycleActionResult}{[required] The action for the group to take. You can specify either \code{CONTINUE} or
\code{ABANDON}.}

\item{InstanceId}{The ID of the instance.}
}
\description{
Completes the lifecycle action for the specified token or instance with the specified result.

See \url{https://paws-r.github.io/docs/autoscaling/complete_lifecycle_action.html} for full documentation.
}
\keyword{internal}
