% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_set_instance_health}
\alias{autoscaling_set_instance_health}
\title{Sets the health status of the specified instance}
\usage{
autoscaling_set_instance_health(
  InstanceId,
  HealthStatus,
  ShouldRespectGracePeriod = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the instance.}

\item{HealthStatus}{[required] The health status of the instance. Set to \code{Healthy} to have the instance
remain in service. Set to \code{Unhealthy} to have the instance be out of
service. Amazon EC2 Auto Scaling terminates and replaces the unhealthy
instance.}

\item{ShouldRespectGracePeriod}{If the Auto Scaling group of the specified instance has a
\code{HealthCheckGracePeriod} specified for the group, by default, this call
respects the grace period. Set this to \code{False}, to have the call not
respect the grace period associated with the group.

For more information about the health check grace period, see
\code{\link[=autoscaling_create_auto_scaling_group]{create_auto_scaling_group}} in
the \emph{Amazon EC2 Auto Scaling API Reference}.}
}
\description{
Sets the health status of the specified instance.

See \url{https://paws-r.github.io/docs/autoscaling/set_instance_health.html} for full documentation.
}
\keyword{internal}
