% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_describe_alarms}
\alias{cloudwatch_describe_alarms}
\title{Retrieves the specified alarms}
\usage{
cloudwatch_describe_alarms(
  AlarmNames = NULL,
  AlarmNamePrefix = NULL,
  AlarmTypes = NULL,
  ChildrenOfAlarmName = NULL,
  ParentsOfAlarmName = NULL,
  StateValue = NULL,
  ActionPrefix = NULL,
  MaxRecords = NULL,
  NextToken = NULL
)
}
\arguments{
\item{AlarmNames}{The names of the alarms to retrieve information about.}

\item{AlarmNamePrefix}{An alarm name prefix. If you specify this parameter, you receive
information about all alarms that have names that start with this
prefix.

If this parameter is specified, you cannot specify \code{AlarmNames}.}

\item{AlarmTypes}{Use this parameter to specify whether you want the operation to return
metric alarms or composite alarms. If you omit this parameter, only
metric alarms are returned.}

\item{ChildrenOfAlarmName}{If you use this parameter and specify the name of a composite alarm, the
operation returns information about the "children" alarms of the alarm
you specify. These are the metric alarms and composite alarms referenced
in the \code{AlarmRule} field of the composite alarm that you specify in
\code{ChildrenOfAlarmName}. Information about the composite alarm that you
name in \code{ChildrenOfAlarmName} is not returned.

If you specify \code{ChildrenOfAlarmName}, you cannot specify any other
parameters in the request except for \code{MaxRecords} and \code{NextToken}. If
you do so, you receive a validation error.

Only the \verb{Alarm Name}, \code{ARN}, \code{StateValue} (OK/ALARM/INSUFFICIENT_DATA),
and \code{StateUpdatedTimestamp} information are returned by this operation
when you use this parameter. To get complete information about these
alarms, perform another \code{\link[=cloudwatch_describe_alarms]{describe_alarms}}
operation and specify the parent alarm names in the \code{AlarmNames}
parameter.}

\item{ParentsOfAlarmName}{If you use this parameter and specify the name of a metric or composite
alarm, the operation returns information about the "parent" alarms of
the alarm you specify. These are the composite alarms that have
\code{AlarmRule} parameters that reference the alarm named in
\code{ParentsOfAlarmName}. Information about the alarm that you specify in
\code{ParentsOfAlarmName} is not returned.

If you specify \code{ParentsOfAlarmName}, you cannot specify any other
parameters in the request except for \code{MaxRecords} and \code{NextToken}. If
you do so, you receive a validation error.

Only the Alarm Name and ARN are returned by this operation when you use
this parameter. To get complete information about these alarms, perform
another \code{\link[=cloudwatch_describe_alarms]{describe_alarms}} operation and
specify the parent alarm names in the \code{AlarmNames} parameter.}

\item{StateValue}{Specify this parameter to receive information only about alarms that are
currently in the state that you specify.}

\item{ActionPrefix}{Use this parameter to filter the results of the operation to only those
alarms that use a certain alarm action. For example, you could specify
the ARN of an SNS topic to find all alarms that send notifications to
that topic.}

\item{MaxRecords}{The maximum number of alarm descriptions to retrieve.}

\item{NextToken}{The token returned by a previous call to indicate that there is more
data available.}
}
\description{
Retrieves the specified alarms. You can filter the results by specifying a prefix for the alarm name, the alarm state, or a prefix for any action.

See \url{https://paws-r.github.io/docs/cloudwatch/describe_alarms.html} for full documentation.
}
\keyword{internal}
