% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_create_archive}
\alias{cloudwatchevents_create_archive}
\title{Creates an archive of events with the specified settings}
\usage{
cloudwatchevents_create_archive(
  ArchiveName,
  EventSourceArn,
  Description = NULL,
  EventPattern = NULL,
  RetentionDays = NULL
)
}
\arguments{
\item{ArchiveName}{[required] The name for the archive to create.}

\item{EventSourceArn}{[required] The ARN of the event bus that sends events to the archive.}

\item{Description}{A description for the archive.}

\item{EventPattern}{An event pattern to use to filter events sent to the archive.}

\item{RetentionDays}{The number of days to retain events for. Default value is 0. If set to
0, events are retained indefinitely}
}
\description{
Creates an archive of events with the specified settings. When you create an archive, incoming events might not immediately start being sent to the archive. Allow a short period of time for changes to take effect. If you do not specify a pattern to filter events sent to the archive, all events are sent to the archive except replayed events. Replayed events are not sent to an archive.

See \url{https://paws-r.github.io/docs/cloudwatchevents/create_archive.html} for full documentation.
}
\keyword{internal}
