% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_create_app}
\alias{resiliencehub_create_app}
\title{Creates a Resilience Hub application}
\usage{
resiliencehub_create_app(
  assessmentSchedule = NULL,
  clientToken = NULL,
  description = NULL,
  name,
  policyArn = NULL,
  tags = NULL
)
}
\arguments{
\item{assessmentSchedule}{Assessment execution schedule with 'Daily' or 'Disabled' values.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{description}{The optional description for an app.}

\item{name}{[required] The name for the application.}

\item{policyArn}{The Amazon Resource Name (ARN) of the resiliency policy. The format for
this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference}.}

\item{tags}{The tags assigned to the resource. A tag is a label that you assign to
an Amazon Web Services resource. Each tag consists of a key/value pair.}
}
\description{
Creates a Resilience Hub application. A Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more–up to five–CloudFormation stacks, and an appropriate resiliency policy.

See \url{https://paws-r.github.io/docs/resiliencehub/create_app.html} for full documentation.
}
\keyword{internal}
