% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_search_resources}
\alias{resourcegroups_search_resources}
\title{Returns a list of AWS resource identifiers that matches the specified
query}
\usage{
resourcegroups_search_resources(
  ResourceQuery,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ResourceQuery}{[required] The search query, using the same formats that are supported for resource
group definition. For more information, see
\code{\link[=resourcegroups_create_group]{create_group}}.}

\item{MaxResults}{The total number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
that is specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (is not null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that the service might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
provided by a previous call's \code{NextToken} response to indicate where the
output should continue from.}
}
\description{
Returns a list of AWS resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.

See \url{https://paws-r.github.io/docs/resourcegroups/search_resources.html} for full documentation.
}
\keyword{internal}
