% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_maintenance_window_execution_tasks}
\alias{ssm_describe_maintenance_window_execution_tasks}
\title{For a given maintenance window execution, lists the tasks that were run}
\usage{
ssm_describe_maintenance_window_execution_tasks(
  WindowExecutionId,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{WindowExecutionId}{[required] The ID of the maintenance window execution whose task executions should
be retrieved.}

\item{Filters}{Optional filters used to scope down the returned tasks. The supported
filter key is \code{STATUS} with the corresponding values \code{PENDING},
\code{IN_PROGRESS}, \code{SUCCESS}, \code{FAILED}, \code{TIMED_OUT}, \code{CANCELLING}, and
\code{CANCELLED}.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
For a given maintenance window execution, lists the tasks that were run.

See \url{https://paws-r.github.io/docs/ssm/describe_maintenance_window_execution_tasks.html} for full documentation.
}
\keyword{internal}
