% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_create_timeline_event}
\alias{ssmincidents_create_timeline_event}
\title{Creates a custom timeline event on the incident details page of an
incident record}
\usage{
ssmincidents_create_timeline_event(
  clientToken = NULL,
  eventData,
  eventTime,
  eventType,
  incidentRecordArn
)
}
\arguments{
\item{clientToken}{A token ensuring that the action is called only once with the specified
details.}

\item{eventData}{[required] A short description of the event.}

\item{eventTime}{[required] The time that the event occurred.}

\item{eventType}{[required] The type of the event. You can create timeline events of type
\verb{Custom Event}.}

\item{incidentRecordArn}{[required] The Amazon Resource Name (ARN) of the incident record to which the event
will be added.}
}
\description{
Creates a custom timeline event on the incident details page of an incident record. Timeline events are automatically created by Incident Manager, marking key moment during an incident. You can create custom timeline events to mark important events that are automatically detected by Incident Manager.

See \url{https://paws-r.github.io/docs/ssmincidents/create_timeline_event.html} for full documentation.
}
\keyword{internal}
