% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_operations.R
\name{ssmincidents_start_incident}
\alias{ssmincidents_start_incident}
\title{Used to start an incident from CloudWatch alarms, EventBridge events, or
manually}
\usage{
ssmincidents_start_incident(
  clientToken = NULL,
  impact = NULL,
  relatedItems = NULL,
  responsePlanArn,
  title = NULL,
  triggerDetails = NULL
)
}
\arguments{
\item{clientToken}{A token ensuring that the operation is called only once with the
specified details.}

\item{impact}{Defines the impact to the customers. Providing an impact overwrites the
impact provided by a response plan.

\strong{Possible impacts:}
\itemize{
\item \code{1} - Critical impact, this typically relates to full application
failure that impacts many to all customers.
\item \code{2} - High impact, partial application failure with impact to many
customers.
\item \code{3} - Medium impact, the application is providing reduced service to
customers.
\item \code{4} - Low impact, customer might aren't impacted by the problem yet.
\item \code{5} - No impact, customers aren't currently impacted but urgent
action is needed to avoid impact.
}}

\item{relatedItems}{Add related items to the incident for other responders to use. Related
items are AWS resources, external links, or files uploaded to an Amazon
S3 bucket.}

\item{responsePlanArn}{[required] The Amazon Resource Name (ARN) of the response plan that pre-defines
summary, chat channels, Amazon SNS topics, runbooks, title, and impact
of the incident.}

\item{title}{Provide a title for the incident. Providing a title overwrites the title
provided by the response plan.}

\item{triggerDetails}{Details of what created the incident record in Incident Manager.}
}
\description{
Used to start an incident from CloudWatch alarms, EventBridge events, or manually.

See \url{https://paws-r.github.io/docs/ssmincidents/start_incident.html} for full documentation.
}
\keyword{internal}
