# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Prometheus Service
#'
#' @description
#' Amazon Managed Service for Prometheus
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- prometheusservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- prometheusservice()
#' svc$create_alert_manager_definition(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=prometheusservice_create_alert_manager_definition]{create_alert_manager_definition} \tab Create an alert manager definition\cr
#'  \link[=prometheusservice_create_logging_configuration]{create_logging_configuration} \tab Create logging configuration\cr
#'  \link[=prometheusservice_create_rule_groups_namespace]{create_rule_groups_namespace} \tab Create a rule group namespace\cr
#'  \link[=prometheusservice_create_workspace]{create_workspace} \tab Creates a new AMP workspace\cr
#'  \link[=prometheusservice_delete_alert_manager_definition]{delete_alert_manager_definition} \tab Deletes an alert manager definition\cr
#'  \link[=prometheusservice_delete_logging_configuration]{delete_logging_configuration} \tab Delete logging configuration\cr
#'  \link[=prometheusservice_delete_rule_groups_namespace]{delete_rule_groups_namespace} \tab Delete a rule groups namespace\cr
#'  \link[=prometheusservice_delete_workspace]{delete_workspace} \tab Deletes an AMP workspace\cr
#'  \link[=prometheusservice_describe_alert_manager_definition]{describe_alert_manager_definition} \tab Describes an alert manager definition\cr
#'  \link[=prometheusservice_describe_logging_configuration]{describe_logging_configuration} \tab Describes logging configuration\cr
#'  \link[=prometheusservice_describe_rule_groups_namespace]{describe_rule_groups_namespace} \tab Describe a rule groups namespace\cr
#'  \link[=prometheusservice_describe_workspace]{describe_workspace} \tab Describes an existing AMP workspace\cr
#'  \link[=prometheusservice_list_rule_groups_namespaces]{list_rule_groups_namespaces} \tab Lists rule groups namespaces\cr
#'  \link[=prometheusservice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags you have assigned to the resource\cr
#'  \link[=prometheusservice_list_workspaces]{list_workspaces} \tab Lists all AMP workspaces, including workspaces being created or deleted\cr
#'  \link[=prometheusservice_put_alert_manager_definition]{put_alert_manager_definition} \tab Update an alert manager definition\cr
#'  \link[=prometheusservice_put_rule_groups_namespace]{put_rule_groups_namespace} \tab Update a rule groups namespace\cr
#'  \link[=prometheusservice_tag_resource]{tag_resource} \tab Creates tags for the specified resource\cr
#'  \link[=prometheusservice_untag_resource]{untag_resource} \tab Deletes tags from the specified resource\cr
#'  \link[=prometheusservice_update_logging_configuration]{update_logging_configuration} \tab Update logging configuration\cr
#'  \link[=prometheusservice_update_workspace_alias]{update_workspace_alias} \tab Updates an AMP workspace alias
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname prometheusservice
#' @export
prometheusservice <- function(config = list()) {
  svc <- .prometheusservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.prometheusservice <- list()

.prometheusservice$operations <- list()

.prometheusservice$metadata <- list(
  service_name = "prometheusservice",
  endpoints = list("*" = list(endpoint = "aps.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "aps.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "aps.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "aps.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "amp",
  api_version = "2020-08-01",
  signing_name = "aps",
  json_version = "1.1",
  target_prefix = ""
)

.prometheusservice$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.prometheusservice$metadata, handlers, config)
}
