# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include synthetics_service.R
NULL

#' Associates a canary with a group
#'
#' @description
#' Associates a canary with a group. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_associate_resource/](https://www.paws-r-sdk.com/docs/synthetics_associate_resource/) for full documentation.
#'
#' @param GroupIdentifier &#91;required&#93; Specifies the group. You can specify the group name, the ARN, or the
#' group ID as the `GroupIdentifier`.
#' @param ResourceArn &#91;required&#93; The ARN of the canary that you want to associate with the specified
#' group.
#'
#' @keywords internal
#'
#' @rdname synthetics_associate_resource
synthetics_associate_resource <- function(GroupIdentifier, ResourceArn) {
  op <- new_operation(
    name = "AssociateResource",
    http_method = "PATCH",
    http_path = "/group/{groupIdentifier}/associate",
    paginator = list()
  )
  input <- .synthetics$associate_resource_input(GroupIdentifier = GroupIdentifier, ResourceArn = ResourceArn)
  output <- .synthetics$associate_resource_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$associate_resource <- synthetics_associate_resource

#' Creates a canary
#'
#' @description
#' Creates a canary. Canaries are scripts that monitor your endpoints and APIs from the outside-in. Canaries help you check the availability and latency of your web services and troubleshoot anomalies by investigating load time data, screenshots of the UI, logs, and metrics. You can set up a canary to run continuously or just once.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_create_canary/](https://www.paws-r-sdk.com/docs/synthetics_create_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for this canary. Be sure to give it a descriptive name that
#' distinguishes it from other canaries in your account.
#' 
#' Do not include secrets or proprietary information in your canary names.
#' The canary name makes up part of the canary ARN, and the ARN is included
#' in outbound calls over the internet. For more information, see [Security
#' Considerations for Synthetics
#' Canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
#' @param Code &#91;required&#93; A structure that includes the entry point from which the canary should
#' start running your script. If the script is stored in an S3 bucket, the
#' bucket name, key, and version are also included.
#' @param ArtifactS3Location &#91;required&#93; The location in Amazon S3 where Synthetics stores artifacts from the
#' test runs of this canary. Artifacts include the log file, screenshots,
#' and HAR files. The name of the S3 bucket can't include a period (.).
#' @param ExecutionRoleArn &#91;required&#93; The ARN of the IAM role to be used to run the canary. This role must
#' already exist, and must include `lambda.amazonaws.com` as a principal in
#' the trust policy. The role must also have the following permissions:
#' 
#' -   `s3:PutObject`
#' 
#' -   `s3:GetBucketLocation`
#' 
#' -   `s3:ListAllMyBuckets`
#' 
#' -   `cloudwatch:PutMetricData`
#' 
#' -   `logs:CreateLogGroup`
#' 
#' -   `logs:CreateLogStream`
#' 
#' -   `logs:PutLogEvents`
#' @param Schedule &#91;required&#93; A structure that contains information about how often the canary is to
#' run and when these test runs are to stop.
#' @param RunConfig A structure that contains the configuration for individual canary runs,
#' such as timeout value and environment variables.
#' 
#' The environment variables keys and values are not encrypted. Do not
#' store sensitive information in this field.
#' @param SuccessRetentionPeriodInDays The number of days to retain data about successful runs of this canary.
#' If you omit this field, the default of 31 days is used. The valid range
#' is 1 to 455 days.
#' @param FailureRetentionPeriodInDays The number of days to retain data about failed runs of this canary. If
#' you omit this field, the default of 31 days is used. The valid range is
#' 1 to 455 days.
#' @param RuntimeVersion &#91;required&#93; Specifies the runtime version to use for the canary. For a list of valid
#' runtime versions and more information about runtime versions, see
#' [Canary Runtime
#' Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
#' @param VpcConfig If this canary is to test an endpoint in a VPC, this structure contains
#' information about the subnet and security groups of the VPC endpoint.
#' For more information, see [Running a Canary in a
#' VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
#' @param Tags A list of key-value pairs to associate with the canary. You can
#' associate as many as 50 tags with a canary.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions, by granting a user permission to
#' access or change only the resources that have certain tag values.
#' @param ArtifactConfig A structure that contains the configuration for canary artifacts,
#' including the encryption-at-rest settings for artifacts that the canary
#' uploads to Amazon S3.
#'
#' @keywords internal
#'
#' @rdname synthetics_create_canary
synthetics_create_canary <- function(Name, Code, ArtifactS3Location, ExecutionRoleArn, Schedule, RunConfig = NULL, SuccessRetentionPeriodInDays = NULL, FailureRetentionPeriodInDays = NULL, RuntimeVersion, VpcConfig = NULL, Tags = NULL, ArtifactConfig = NULL) {
  op <- new_operation(
    name = "CreateCanary",
    http_method = "POST",
    http_path = "/canary",
    paginator = list()
  )
  input <- .synthetics$create_canary_input(Name = Name, Code = Code, ArtifactS3Location = ArtifactS3Location, ExecutionRoleArn = ExecutionRoleArn, Schedule = Schedule, RunConfig = RunConfig, SuccessRetentionPeriodInDays = SuccessRetentionPeriodInDays, FailureRetentionPeriodInDays = FailureRetentionPeriodInDays, RuntimeVersion = RuntimeVersion, VpcConfig = VpcConfig, Tags = Tags, ArtifactConfig = ArtifactConfig)
  output <- .synthetics$create_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$create_canary <- synthetics_create_canary

#' Creates a group which you can use to associate canaries with each other,
#' including cross-Region canaries
#'
#' @description
#' Creates a group which you can use to associate canaries with each other, including cross-Region canaries. Using groups can help you with managing and automating your canaries, and you can also view aggregated run results and statistics for all canaries in a group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_create_group/](https://www.paws-r-sdk.com/docs/synthetics_create_group/) for full documentation.
#'
#' @param Name &#91;required&#93; The name for the group. It can include any Unicode characters.
#' 
#' The names for all groups in your account, across all Regions, must be
#' unique.
#' @param Tags A list of key-value pairs to associate with the group. You can associate
#' as many as 50 tags with a group.
#' 
#' Tags can help you organize and categorize your resources. You can also
#' use them to scope user permissions, by granting a user permission to
#' access or change only the resources that have certain tag values.
#'
#' @keywords internal
#'
#' @rdname synthetics_create_group
synthetics_create_group <- function(Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/group",
    paginator = list()
  )
  input <- .synthetics$create_group_input(Name = Name, Tags = Tags)
  output <- .synthetics$create_group_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$create_group <- synthetics_create_group

#' Permanently deletes the specified canary
#'
#' @description
#' Permanently deletes the specified canary.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_delete_canary/](https://www.paws-r-sdk.com/docs/synthetics_delete_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want to delete. To find the names of
#' your canaries, use [`describe_canaries`][synthetics_describe_canaries].
#' @param DeleteLambda Specifies whether to also delete the Lambda functions and layers used by
#' this canary. The default is false.
#' 
#' Type: Boolean
#'
#' @keywords internal
#'
#' @rdname synthetics_delete_canary
synthetics_delete_canary <- function(Name, DeleteLambda = NULL) {
  op <- new_operation(
    name = "DeleteCanary",
    http_method = "DELETE",
    http_path = "/canary/{name}",
    paginator = list()
  )
  input <- .synthetics$delete_canary_input(Name = Name, DeleteLambda = DeleteLambda)
  output <- .synthetics$delete_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$delete_canary <- synthetics_delete_canary

#' Deletes a group
#'
#' @description
#' Deletes a group. The group doesn't need to be empty to be deleted. If there are canaries in the group, they are not deleted when you delete the group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_delete_group/](https://www.paws-r-sdk.com/docs/synthetics_delete_group/) for full documentation.
#'
#' @param GroupIdentifier &#91;required&#93; Specifies which group to delete. You can specify the group name, the
#' ARN, or the group ID as the `GroupIdentifier`.
#'
#' @keywords internal
#'
#' @rdname synthetics_delete_group
synthetics_delete_group <- function(GroupIdentifier) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "DELETE",
    http_path = "/group/{groupIdentifier}",
    paginator = list()
  )
  input <- .synthetics$delete_group_input(GroupIdentifier = GroupIdentifier)
  output <- .synthetics$delete_group_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$delete_group <- synthetics_delete_group

#' This operation returns a list of the canaries in your account, along
#' with full details about each canary
#'
#' @description
#' This operation returns a list of the canaries in your account, along with full details about each canary.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_describe_canaries/](https://www.paws-r-sdk.com/docs/synthetics_describe_canaries/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent operation to retrieve the next set of
#' results.
#' @param MaxResults Specify this parameter to limit how many canaries are returned each time
#' you use the [`describe_canaries`][synthetics_describe_canaries]
#' operation. If you omit this parameter, the default of 100 is used.
#' @param Names Use this parameter to return only canaries that match the names that you
#' specify here. You can specify as many as five canary names.
#' 
#' If you specify this parameter, the operation is successful only if you
#' have authorization to view all the canaries that you specify in your
#' request. If you do not have permission to view any of the canaries, the
#' request fails with a 403 response.
#' 
#' You are required to use this parameter if you are logged on to a user or
#' role that has an IAM policy that restricts which canaries that you are
#' allowed to view. For more information, see [Limiting a user to viewing
#' specific
#' canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
#'
#' @keywords internal
#'
#' @rdname synthetics_describe_canaries
synthetics_describe_canaries <- function(NextToken = NULL, MaxResults = NULL, Names = NULL) {
  op <- new_operation(
    name = "DescribeCanaries",
    http_method = "POST",
    http_path = "/canaries",
    paginator = list()
  )
  input <- .synthetics$describe_canaries_input(NextToken = NextToken, MaxResults = MaxResults, Names = Names)
  output <- .synthetics$describe_canaries_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$describe_canaries <- synthetics_describe_canaries

#' Use this operation to see information from the most recent run of each
#' canary that you have created
#'
#' @description
#' Use this operation to see information from the most recent run of each canary that you have created.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_describe_canaries_last_run/](https://www.paws-r-sdk.com/docs/synthetics_describe_canaries_last_run/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent
#' [`describe_canaries_last_run`][synthetics_describe_canaries_last_run]
#' operation to retrieve the next set of results.
#' @param MaxResults Specify this parameter to limit how many runs are returned each time you
#' use the `DescribeLastRun` operation. If you omit this parameter, the
#' default of 100 is used.
#' @param Names Use this parameter to return only canaries that match the names that you
#' specify here. You can specify as many as five canary names.
#' 
#' If you specify this parameter, the operation is successful only if you
#' have authorization to view all the canaries that you specify in your
#' request. If you do not have permission to view any of the canaries, the
#' request fails with a 403 response.
#' 
#' You are required to use the `Names` parameter if you are logged on to a
#' user or role that has an IAM policy that restricts which canaries that
#' you are allowed to view. For more information, see [Limiting a user to
#' viewing specific
#' canaries](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Restricted.html).
#'
#' @keywords internal
#'
#' @rdname synthetics_describe_canaries_last_run
synthetics_describe_canaries_last_run <- function(NextToken = NULL, MaxResults = NULL, Names = NULL) {
  op <- new_operation(
    name = "DescribeCanariesLastRun",
    http_method = "POST",
    http_path = "/canaries/last-run",
    paginator = list()
  )
  input <- .synthetics$describe_canaries_last_run_input(NextToken = NextToken, MaxResults = MaxResults, Names = Names)
  output <- .synthetics$describe_canaries_last_run_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$describe_canaries_last_run <- synthetics_describe_canaries_last_run

#' Returns a list of Synthetics canary runtime versions
#'
#' @description
#' Returns a list of Synthetics canary runtime versions. For more information, see [Canary Runtime Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_describe_runtime_versions/](https://www.paws-r-sdk.com/docs/synthetics_describe_runtime_versions/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent
#' [`describe_runtime_versions`][synthetics_describe_runtime_versions]
#' operation to retrieve the next set of results.
#' @param MaxResults Specify this parameter to limit how many runs are returned each time you
#' use the
#' [`describe_runtime_versions`][synthetics_describe_runtime_versions]
#' operation. If you omit this parameter, the default of 100 is used.
#'
#' @keywords internal
#'
#' @rdname synthetics_describe_runtime_versions
synthetics_describe_runtime_versions <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRuntimeVersions",
    http_method = "POST",
    http_path = "/runtime-versions",
    paginator = list()
  )
  input <- .synthetics$describe_runtime_versions_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .synthetics$describe_runtime_versions_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$describe_runtime_versions <- synthetics_describe_runtime_versions

#' Removes a canary from a group
#'
#' @description
#' Removes a canary from a group. You must run this operation in the Region where the canary exists.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_disassociate_resource/](https://www.paws-r-sdk.com/docs/synthetics_disassociate_resource/) for full documentation.
#'
#' @param GroupIdentifier &#91;required&#93; Specifies the group. You can specify the group name, the ARN, or the
#' group ID as the `GroupIdentifier`.
#' @param ResourceArn &#91;required&#93; The ARN of the canary that you want to remove from the specified group.
#'
#' @keywords internal
#'
#' @rdname synthetics_disassociate_resource
synthetics_disassociate_resource <- function(GroupIdentifier, ResourceArn) {
  op <- new_operation(
    name = "DisassociateResource",
    http_method = "PATCH",
    http_path = "/group/{groupIdentifier}/disassociate",
    paginator = list()
  )
  input <- .synthetics$disassociate_resource_input(GroupIdentifier = GroupIdentifier, ResourceArn = ResourceArn)
  output <- .synthetics$disassociate_resource_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$disassociate_resource <- synthetics_disassociate_resource

#' Retrieves complete information about one canary
#'
#' @description
#' Retrieves complete information about one canary. You must specify the name of the canary that you want. To get a list of canaries and their names, use [`describe_canaries`][synthetics_describe_canaries].
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_get_canary/](https://www.paws-r-sdk.com/docs/synthetics_get_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want details for.
#'
#' @keywords internal
#'
#' @rdname synthetics_get_canary
synthetics_get_canary <- function(Name) {
  op <- new_operation(
    name = "GetCanary",
    http_method = "GET",
    http_path = "/canary/{name}",
    paginator = list()
  )
  input <- .synthetics$get_canary_input(Name = Name)
  output <- .synthetics$get_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$get_canary <- synthetics_get_canary

#' Retrieves a list of runs for a specified canary
#'
#' @description
#' Retrieves a list of runs for a specified canary.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_get_canary_runs/](https://www.paws-r-sdk.com/docs/synthetics_get_canary_runs/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want to see runs for.
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent
#' [`get_canary_runs`][synthetics_get_canary_runs] operation to retrieve
#' the next set of results.
#' @param MaxResults Specify this parameter to limit how many runs are returned each time you
#' use the [`get_canary_runs`][synthetics_get_canary_runs] operation. If
#' you omit this parameter, the default of 100 is used.
#'
#' @keywords internal
#'
#' @rdname synthetics_get_canary_runs
synthetics_get_canary_runs <- function(Name, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetCanaryRuns",
    http_method = "POST",
    http_path = "/canary/{name}/runs",
    paginator = list()
  )
  input <- .synthetics$get_canary_runs_input(Name = Name, NextToken = NextToken, MaxResults = MaxResults)
  output <- .synthetics$get_canary_runs_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$get_canary_runs <- synthetics_get_canary_runs

#' Returns information about one group
#'
#' @description
#' Returns information about one group. Groups are a global resource, so you can use this operation from any Region.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_get_group/](https://www.paws-r-sdk.com/docs/synthetics_get_group/) for full documentation.
#'
#' @param GroupIdentifier &#91;required&#93; Specifies the group to return information for. You can specify the group
#' name, the ARN, or the group ID as the `GroupIdentifier`.
#'
#' @keywords internal
#'
#' @rdname synthetics_get_group
synthetics_get_group <- function(GroupIdentifier) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "GET",
    http_path = "/group/{groupIdentifier}",
    paginator = list()
  )
  input <- .synthetics$get_group_input(GroupIdentifier = GroupIdentifier)
  output <- .synthetics$get_group_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$get_group <- synthetics_get_group

#' Returns a list of the groups that the specified canary is associated
#' with
#'
#' @description
#' Returns a list of the groups that the specified canary is associated with. The canary that you specify must be in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_list_associated_groups/](https://www.paws-r-sdk.com/docs/synthetics_list_associated_groups/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent operation to retrieve the next set of
#' results.
#' @param MaxResults Specify this parameter to limit how many groups are returned each time
#' you use the
#' [`list_associated_groups`][synthetics_list_associated_groups] operation.
#' If you omit this parameter, the default of 20 is used.
#' @param ResourceArn &#91;required&#93; The ARN of the canary that you want to view groups for.
#'
#' @keywords internal
#'
#' @rdname synthetics_list_associated_groups
synthetics_list_associated_groups <- function(NextToken = NULL, MaxResults = NULL, ResourceArn) {
  op <- new_operation(
    name = "ListAssociatedGroups",
    http_method = "POST",
    http_path = "/resource/{resourceArn}/groups",
    paginator = list()
  )
  input <- .synthetics$list_associated_groups_input(NextToken = NextToken, MaxResults = MaxResults, ResourceArn = ResourceArn)
  output <- .synthetics$list_associated_groups_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$list_associated_groups <- synthetics_list_associated_groups

#' This operation returns a list of the ARNs of the canaries that are
#' associated with the specified group
#'
#' @description
#' This operation returns a list of the ARNs of the canaries that are associated with the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_list_group_resources/](https://www.paws-r-sdk.com/docs/synthetics_list_group_resources/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent operation to retrieve the next set of
#' results.
#' @param MaxResults Specify this parameter to limit how many canary ARNs are returned each
#' time you use the
#' [`list_group_resources`][synthetics_list_group_resources] operation. If
#' you omit this parameter, the default of 20 is used.
#' @param GroupIdentifier &#91;required&#93; Specifies the group to return information for. You can specify the group
#' name, the ARN, or the group ID as the `GroupIdentifier`.
#'
#' @keywords internal
#'
#' @rdname synthetics_list_group_resources
synthetics_list_group_resources <- function(NextToken = NULL, MaxResults = NULL, GroupIdentifier) {
  op <- new_operation(
    name = "ListGroupResources",
    http_method = "POST",
    http_path = "/group/{groupIdentifier}/resources",
    paginator = list()
  )
  input <- .synthetics$list_group_resources_input(NextToken = NextToken, MaxResults = MaxResults, GroupIdentifier = GroupIdentifier)
  output <- .synthetics$list_group_resources_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$list_group_resources <- synthetics_list_group_resources

#' Returns a list of all groups in the account, displaying their names,
#' unique IDs, and ARNs
#'
#' @description
#' Returns a list of all groups in the account, displaying their names, unique IDs, and ARNs. The groups from all Regions are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_list_groups/](https://www.paws-r-sdk.com/docs/synthetics_list_groups/) for full documentation.
#'
#' @param NextToken A token that indicates that there is more data available. You can use
#' this token in a subsequent operation to retrieve the next set of
#' results.
#' @param MaxResults Specify this parameter to limit how many groups are returned each time
#' you use the [`list_groups`][synthetics_list_groups] operation. If you
#' omit this parameter, the default of 20 is used.
#'
#' @keywords internal
#'
#' @rdname synthetics_list_groups
synthetics_list_groups <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/groups",
    paginator = list()
  )
  input <- .synthetics$list_groups_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .synthetics$list_groups_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$list_groups <- synthetics_list_groups

#' Displays the tags associated with a canary or group
#'
#' @description
#' Displays the tags associated with a canary or group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/synthetics_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the canary or group that you want to view tags for.
#' 
#' The ARN format of a canary is
#' `arn:aws:synthetics:Region:account-id:canary:canary-name `.
#' 
#' The ARN format of a group is
#' `arn:aws:synthetics:Region:account-id:group:group-name `
#'
#' @keywords internal
#'
#' @rdname synthetics_list_tags_for_resource
synthetics_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .synthetics$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .synthetics$list_tags_for_resource_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$list_tags_for_resource <- synthetics_list_tags_for_resource

#' Use this operation to run a canary that has already been created
#'
#' @description
#' Use this operation to run a canary that has already been created. The frequency of the canary runs is determined by the value of the canary's `Schedule`. To see a canary's schedule, use [`get_canary`][synthetics_get_canary].
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_start_canary/](https://www.paws-r-sdk.com/docs/synthetics_start_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want to run. To find canary names, use
#' [`describe_canaries`][synthetics_describe_canaries].
#'
#' @keywords internal
#'
#' @rdname synthetics_start_canary
synthetics_start_canary <- function(Name) {
  op <- new_operation(
    name = "StartCanary",
    http_method = "POST",
    http_path = "/canary/{name}/start",
    paginator = list()
  )
  input <- .synthetics$start_canary_input(Name = Name)
  output <- .synthetics$start_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$start_canary <- synthetics_start_canary

#' Stops the canary to prevent all future runs
#'
#' @description
#' Stops the canary to prevent all future runs. If the canary is currently running,the run that is in progress completes on its own, publishes metrics, and uploads artifacts, but it is not recorded in Synthetics as a completed run.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_stop_canary/](https://www.paws-r-sdk.com/docs/synthetics_stop_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want to stop. To find the names of your
#' canaries, use
#' [ListCanaries](https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
#'
#' @keywords internal
#'
#' @rdname synthetics_stop_canary
synthetics_stop_canary <- function(Name) {
  op <- new_operation(
    name = "StopCanary",
    http_method = "POST",
    http_path = "/canary/{name}/stop",
    paginator = list()
  )
  input <- .synthetics$stop_canary_input(Name = Name)
  output <- .synthetics$stop_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$stop_canary <- synthetics_stop_canary

#' Assigns one or more tags (key-value pairs) to the specified canary or
#' group
#'
#' @description
#' Assigns one or more tags (key-value pairs) to the specified canary or group.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_tag_resource/](https://www.paws-r-sdk.com/docs/synthetics_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the canary or group that you're adding tags to.
#' 
#' The ARN format of a canary is
#' `arn:aws:synthetics:Region:account-id:canary:canary-name `.
#' 
#' The ARN format of a group is
#' `arn:aws:synthetics:Region:account-id:group:group-name `
#' @param Tags &#91;required&#93; The list of key-value pairs to associate with the resource.
#'
#' @keywords internal
#'
#' @rdname synthetics_tag_resource
synthetics_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .synthetics$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .synthetics$tag_resource_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$tag_resource <- synthetics_tag_resource

#' Removes one or more tags from the specified resource
#'
#' @description
#' Removes one or more tags from the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_untag_resource/](https://www.paws-r-sdk.com/docs/synthetics_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The ARN of the canary or group that you're removing tags from.
#' 
#' The ARN format of a canary is
#' `arn:aws:synthetics:Region:account-id:canary:canary-name `.
#' 
#' The ARN format of a group is
#' `arn:aws:synthetics:Region:account-id:group:group-name `
#' @param TagKeys &#91;required&#93; The list of tag keys to remove from the resource.
#'
#' @keywords internal
#'
#' @rdname synthetics_untag_resource
synthetics_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .synthetics$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .synthetics$untag_resource_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$untag_resource <- synthetics_untag_resource

#' Updates the configuration of a canary that has already been created
#'
#' @description
#' Updates the configuration of a canary that has already been created.
#'
#' See [https://www.paws-r-sdk.com/docs/synthetics_update_canary/](https://www.paws-r-sdk.com/docs/synthetics_update_canary/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the canary that you want to update. To find the names of
#' your canaries, use [`describe_canaries`][synthetics_describe_canaries].
#' 
#' You cannot change the name of a canary that has already been created.
#' @param Code A structure that includes the entry point from which the canary should
#' start running your script. If the script is stored in an S3 bucket, the
#' bucket name, key, and version are also included.
#' @param ExecutionRoleArn The ARN of the IAM role to be used to run the canary. This role must
#' already exist, and must include `lambda.amazonaws.com` as a principal in
#' the trust policy. The role must also have the following permissions:
#' 
#' -   `s3:PutObject`
#' 
#' -   `s3:GetBucketLocation`
#' 
#' -   `s3:ListAllMyBuckets`
#' 
#' -   `cloudwatch:PutMetricData`
#' 
#' -   `logs:CreateLogGroup`
#' 
#' -   `logs:CreateLogStream`
#' 
#' -   `logs:CreateLogStream`
#' @param RuntimeVersion Specifies the runtime version to use for the canary. For a list of valid
#' runtime versions and for more information about runtime versions, see
#' [Canary Runtime
#' Versions](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
#' @param Schedule A structure that contains information about how often the canary is to
#' run, and when these runs are to stop.
#' @param RunConfig A structure that contains the timeout value that is used for each
#' individual run of the canary.
#' 
#' The environment variables keys and values are not encrypted. Do not
#' store sensitive information in this field.
#' @param SuccessRetentionPeriodInDays The number of days to retain data about successful runs of this canary.
#' @param FailureRetentionPeriodInDays The number of days to retain data about failed runs of this canary.
#' @param VpcConfig If this canary is to test an endpoint in a VPC, this structure contains
#' information about the subnet and security groups of the VPC endpoint.
#' For more information, see [Running a Canary in a
#' VPC](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
#' @param VisualReference Defines the screenshots to use as the baseline for comparisons during
#' visual monitoring comparisons during future runs of this canary. If you
#' omit this parameter, no changes are made to any baseline screenshots
#' that the canary might be using already.
#' 
#' Visual monitoring is supported only on canaries running the
#' **syn-puppeteer-node-3.2** runtime or later. For more information, see
#' [Visual
#' monitoring](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/)
#' and [Visual monitoring
#' blueprint](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/)
#' @param ArtifactS3Location The location in Amazon S3 where Synthetics stores artifacts from the
#' test runs of this canary. Artifacts include the log file, screenshots,
#' and HAR files. The name of the S3 bucket can't include a period (.).
#' @param ArtifactConfig A structure that contains the configuration for canary artifacts,
#' including the encryption-at-rest settings for artifacts that the canary
#' uploads to Amazon S3.
#'
#' @keywords internal
#'
#' @rdname synthetics_update_canary
synthetics_update_canary <- function(Name, Code = NULL, ExecutionRoleArn = NULL, RuntimeVersion = NULL, Schedule = NULL, RunConfig = NULL, SuccessRetentionPeriodInDays = NULL, FailureRetentionPeriodInDays = NULL, VpcConfig = NULL, VisualReference = NULL, ArtifactS3Location = NULL, ArtifactConfig = NULL) {
  op <- new_operation(
    name = "UpdateCanary",
    http_method = "PATCH",
    http_path = "/canary/{name}",
    paginator = list()
  )
  input <- .synthetics$update_canary_input(Name = Name, Code = Code, ExecutionRoleArn = ExecutionRoleArn, RuntimeVersion = RuntimeVersion, Schedule = Schedule, RunConfig = RunConfig, SuccessRetentionPeriodInDays = SuccessRetentionPeriodInDays, FailureRetentionPeriodInDays = FailureRetentionPeriodInDays, VpcConfig = VpcConfig, VisualReference = VisualReference, ArtifactS3Location = ArtifactS3Location, ArtifactConfig = ArtifactConfig)
  output <- .synthetics$update_canary_output()
  config <- get_config()
  svc <- .synthetics$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.synthetics$operations$update_canary <- synthetics_update_canary
