% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_tag_resource}
\alias{cloudwatch_tag_resource}
\title{Assigns one or more tags (key-value pairs) to the specified CloudWatch
resource}
\usage{
cloudwatch_tag_resource(ResourceARN, Tags)
}
\arguments{
\item{ResourceARN}{[required] The ARN of the CloudWatch resource that you're adding tags to.

The ARN format of an alarm is
\code{arn:aws:cloudwatch:Region:account-id:alarm:alarm-name }

The ARN format of a Contributor Insights rule is
\code{arn:aws:cloudwatch:Region:account-id:insight-rule:insight-rule-name }

For more information about ARN format, see \href{https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazoncloudwatch.html#amazoncloudwatch-resources-for-iam-policies}{Resource Types Defined by Amazon CloudWatch}
in the \emph{Amazon Web Services General Reference}.}

\item{Tags}{[required] The list of key-value pairs to associate with the alarm.}
}
\description{
Assigns one or more tags (key-value pairs) to the specified CloudWatch resource. Currently, the only CloudWatch resources that can be tagged are alarms and Contributor Insights rules.

See \url{https://www.paws-r-sdk.com/docs/cloudwatch_tag_resource/} for full documentation.
}
\keyword{internal}
