% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_create_organization}
\alias{organizations_create_organization}
\title{Creates an Amazon Web Services organization}
\usage{
organizations_create_organization(FeatureSet = NULL)
}
\arguments{
\item{FeatureSet}{Specifies the feature set supported by the new organization. Each
feature set supports different levels of functionality.
\itemize{
\item \code{CONSOLIDATED_BILLING}: All member accounts have their bills
consolidated to and paid by the management account. For more
information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only}{Consolidated billing}
in the \emph{Organizations User Guide.}

The consolidated billing feature subset isn't available for
organizations in the Amazon Web Services GovCloud (US) Region.
\item \code{ALL}: In addition to all the features supported by the consolidated
billing feature set, the management account can also apply any
policy type to any member account in the organization. For more
information, see \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all}{All features}
in the \emph{Organizations User Guide.}
}}
}
\description{
Creates an Amazon Web Services organization. The account whose user is calling the \code{\link[=organizations_create_organization]{create_organization}} operation automatically becomes the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account}{management account} of the new organization.

See \url{https://www.paws-r-sdk.com/docs/organizations_create_organization/} for full documentation.
}
\keyword{internal}
