% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_list_accepted_portfolio_shares}
\alias{servicecatalog_list_accepted_portfolio_shares}
\title{Lists all imported portfolios for which account-to-account shares were
accepted by this account}
\usage{
servicecatalog_list_accepted_portfolio_shares(
  AcceptLanguage = NULL,
  PageToken = NULL,
  PageSize = NULL,
  PortfolioShareType = NULL
)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PageToken}{The page token for the next set of results. To retrieve the first set of
results, use null.}

\item{PageSize}{The maximum number of items to return with this call.}

\item{PortfolioShareType}{The type of shared portfolios to list. The default is to list imported
portfolios.
\itemize{
\item \code{AWS_ORGANIZATIONS} - List portfolios accepted and shared via
organizational sharing by the management account or delegated
administrator of your organization.
\item \code{AWS_SERVICECATALOG} - Deprecated type.
\item \code{IMPORTED} - List imported portfolios that have been accepted and
shared through account-to-account sharing.
}}
}
\description{
Lists all imported portfolios for which account-to-account shares were accepted by this account. By specifying the \code{PortfolioShareType}, you can list portfolios for which organizational shares were accepted by this account.

See \url{https://www.paws-r-sdk.com/docs/servicecatalog_list_accepted_portfolio_shares/} for full documentation.
}
\keyword{internal}
