% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_list_aggregate_discovered_resources}
\alias{configservice_list_aggregate_discovered_resources}
\title{Accepts a resource type and returns a list of resource identifiers that
are aggregated for a specific resource type across accounts and regions}
\usage{
configservice_list_aggregate_discovered_resources(
  ConfigurationAggregatorName,
  ResourceType,
  Filters = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{ResourceType}{[required] The type of resources that you want Config to list in the response.}

\item{Filters}{Filters the results based on the \code{ResourceFilters} object.}

\item{Limit}{The maximum number of resource identifiers returned on each page. You
cannot specify a number greater than 100. If you specify 0, Config uses
the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Accepts a resource type and returns a list of resource identifiers that are aggregated for a specific resource type across accounts and regions. A resource identifier includes the resource type, ID, (if available) the custom resource name, source account, and source region. You can narrow the results to include only resources that have specific resource IDs, or a resource name, or source account ID, or source region.

See \url{https://www.paws-r-sdk.com/docs/configservice_list_aggregate_discovered_resources/} for full documentation.
}
\keyword{internal}
