% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_operations.R
\name{applicationinsights_list_configuration_history}
\alias{applicationinsights_list_configuration_history}
\title{Lists the INFO, WARN, and ERROR events for periodic configuration
updates performed by Application Insights}
\usage{
applicationinsights_list_configuration_history(
  ResourceGroupName = NULL,
  StartTime = NULL,
  EndTime = NULL,
  EventStatus = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  AccountId = NULL
)
}
\arguments{
\item{ResourceGroupName}{Resource group to which the application belongs.}

\item{StartTime}{The start time of the event.}

\item{EndTime}{The end time of the event.}

\item{EventStatus}{The status of the configuration update event. Possible values include
INFO, WARN, and ERROR.}

\item{MaxResults}{The maximum number of results returned by
\code{\link[=applicationinsights_list_configuration_history]{list_configuration_history}}
in paginated output. When this parameter is used,
\code{\link[=applicationinsights_list_configuration_history]{list_configuration_history}}
returns only \code{MaxResults} in a single page along with a \code{NextToken}
response element. The remaining results of the initial request can be
seen by sending another
\code{\link[=applicationinsights_list_configuration_history]{list_configuration_history}}
request with the returned \code{NextToken} value. If this parameter is not
used, then
\code{\link[=applicationinsights_list_configuration_history]{list_configuration_history}}
returns all results.}

\item{NextToken}{The \code{NextToken} value returned from a previous paginated
\code{\link[=applicationinsights_list_configuration_history]{list_configuration_history}}
request where \code{MaxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{NextToken} value. This value is \code{null} when
there are no more results to return.}

\item{AccountId}{The AWS account ID for the resource group owner.}
}
\description{
Lists the INFO, WARN, and ERROR events for periodic configuration updates performed by Application Insights. Examples of events represented are:

See \url{https://www.paws-r-sdk.com/docs/applicationinsights_list_configuration_history/} for full documentation.
}
\keyword{internal}
