# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include licensemanagerlinuxsubscriptions_service.R
NULL

#' Lists the Linux subscriptions service settings
#'
#' @description
#' Lists the Linux subscriptions service settings.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_get_service_settings/](https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_get_service_settings/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname licensemanagerlinuxsubscriptions_get_service_settings
licensemanagerlinuxsubscriptions_get_service_settings <- function() {
  op <- new_operation(
    name = "GetServiceSettings",
    http_method = "POST",
    http_path = "/subscription/GetServiceSettings",
    paginator = list()
  )
  input <- .licensemanagerlinuxsubscriptions$get_service_settings_input()
  output <- .licensemanagerlinuxsubscriptions$get_service_settings_output()
  config <- get_config()
  svc <- .licensemanagerlinuxsubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerlinuxsubscriptions$operations$get_service_settings <- licensemanagerlinuxsubscriptions_get_service_settings

#' Lists the running Amazon EC2 instances that were discovered with
#' commercial Linux subscriptions
#'
#' @description
#' Lists the running Amazon EC2 instances that were discovered with commercial Linux subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_list_linux_subscription_instances/](https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_list_linux_subscription_instances/) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify. For
#' example, you can filter by the name of `AmiID` with an optional operator
#' to see subscriptions that match, partially match, or don't match a
#' certain Amazon Machine Image (AMI) ID.
#' 
#' The valid names for this filter are:
#' 
#' -   `AmiID`
#' 
#' -   `InstanceID`
#' 
#' -   `AccountID`
#' 
#' -   `Status`
#' 
#' -   `Region`
#' 
#' -   `UsageOperation`
#' 
#' -   `ProductCode`
#' 
#' -   `InstanceType`
#' 
#' The valid Operators for this filter are:
#' 
#' -   `contains`
#' 
#' -   `equals`
#' 
#' -   `Notequal`
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanagerlinuxsubscriptions_lis_lin_sub_ins
licensemanagerlinuxsubscriptions_list_linux_subscription_instances <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLinuxSubscriptionInstances",
    http_method = "POST",
    http_path = "/subscription/ListLinuxSubscriptionInstances",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Instances")
  )
  input <- .licensemanagerlinuxsubscriptions$list_linux_subscription_instances_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerlinuxsubscriptions$list_linux_subscription_instances_output()
  config <- get_config()
  svc <- .licensemanagerlinuxsubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerlinuxsubscriptions$operations$list_linux_subscription_instances <- licensemanagerlinuxsubscriptions_list_linux_subscription_instances

#' Lists the Linux subscriptions that have been discovered
#'
#' @description
#' Lists the Linux subscriptions that have been discovered. If you have linked your organization, the returned results will include data aggregated across your accounts in Organizations.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_list_linux_subscriptions/](https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_list_linux_subscriptions/) for full documentation.
#'
#' @param Filters An array of structures that you can use to filter the results to those
#' that match one or more sets of key-value pairs that you specify. For
#' example, you can filter by the name of `Subscription` with an optional
#' operator to see subscriptions that match, partially match, or don't
#' match a certain subscription's name.
#' 
#' The valid names for this filter are:
#' 
#' -   `Subscription`
#' 
#' The valid Operators for this filter are:
#' 
#' -   `contains`
#' 
#' -   `equals`
#' 
#' -   `Notequal`
#' @param MaxResults Maximum number of results to return in a single call.
#' @param NextToken Token for the next set of results.
#'
#' @keywords internal
#'
#' @rdname licensemanagerlinuxsubscriptions_list_linux_subscriptions
licensemanagerlinuxsubscriptions_list_linux_subscriptions <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLinuxSubscriptions",
    http_method = "POST",
    http_path = "/subscription/ListLinuxSubscriptions",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Subscriptions")
  )
  input <- .licensemanagerlinuxsubscriptions$list_linux_subscriptions_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanagerlinuxsubscriptions$list_linux_subscriptions_output()
  config <- get_config()
  svc <- .licensemanagerlinuxsubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerlinuxsubscriptions$operations$list_linux_subscriptions <- licensemanagerlinuxsubscriptions_list_linux_subscriptions

#' Updates the service settings for Linux subscriptions
#'
#' @description
#' Updates the service settings for Linux subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_update_service_settings/](https://www.paws-r-sdk.com/docs/licensemanagerlinuxsubscriptions_update_service_settings/) for full documentation.
#'
#' @param AllowUpdate Describes if updates are allowed to the service settings for Linux
#' subscriptions. If you allow updates, you can aggregate Linux
#' subscription data in more than one home Region.
#' @param LinuxSubscriptionsDiscovery &#91;required&#93; Describes if the discovery of Linux subscriptions is enabled.
#' @param LinuxSubscriptionsDiscoverySettings &#91;required&#93; The settings defined for Linux subscriptions discovery. The settings
#' include if Organizations integration has been enabled, and which Regions
#' data will be aggregated from.
#'
#' @keywords internal
#'
#' @rdname licensemanagerlinuxsubscriptions_update_service_settings
licensemanagerlinuxsubscriptions_update_service_settings <- function(AllowUpdate = NULL, LinuxSubscriptionsDiscovery, LinuxSubscriptionsDiscoverySettings) {
  op <- new_operation(
    name = "UpdateServiceSettings",
    http_method = "POST",
    http_path = "/subscription/UpdateServiceSettings",
    paginator = list()
  )
  input <- .licensemanagerlinuxsubscriptions$update_service_settings_input(AllowUpdate = AllowUpdate, LinuxSubscriptionsDiscovery = LinuxSubscriptionsDiscovery, LinuxSubscriptionsDiscoverySettings = LinuxSubscriptionsDiscoverySettings)
  output <- .licensemanagerlinuxsubscriptions$update_service_settings_output()
  config <- get_config()
  svc <- .licensemanagerlinuxsubscriptions$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanagerlinuxsubscriptions$operations$update_service_settings <- licensemanagerlinuxsubscriptions_update_service_settings
