% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_validate_template}
\alias{cloudformation_validate_template}
\title{Validates a specified template}
\usage{
cloudformation_validate_template(TemplateBody = NULL, TemplateURL = NULL)
}
\arguments{
\item{TemplateBody}{Structure containing the template body with a minimum length of 1 byte
and a maximum length of 51,200 bytes. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the \emph{CloudFormation User Guide}.

Conditional: You must pass \code{TemplateURL} or \code{TemplateBody}. If both are
passed, only \code{TemplateBody} is used.}

\item{TemplateURL}{Location of file containing the template body. The URL must point to a
template (max size: 460,800 bytes) that is located in an Amazon S3
bucket or a Systems Manager document. For more information, go to
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html}{Template Anatomy}
in the \emph{CloudFormation User Guide}. The location for an Amazon S3 bucket
must start with \verb{https://}.

Conditional: You must pass \code{TemplateURL} or \code{TemplateBody}. If both are
passed, only \code{TemplateBody} is used.}
}
\description{
Validates a specified template. CloudFormation first checks if the template is valid JSON. If it isn't, CloudFormation checks if the template is valid YAML. If both these checks fail, CloudFormation returns a template validation error.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_validate_template/} for full documentation.
}
\keyword{internal}
