% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_register_task_with_maintenance_window}
\alias{ssm_register_task_with_maintenance_window}
\title{Adds a new task to a maintenance window}
\usage{
ssm_register_task_with_maintenance_window(
  WindowId,
  Targets = NULL,
  TaskArn,
  ServiceRoleArn = NULL,
  TaskType,
  TaskParameters = NULL,
  TaskInvocationParameters = NULL,
  Priority = NULL,
  MaxConcurrency = NULL,
  MaxErrors = NULL,
  LoggingInfo = NULL,
  Name = NULL,
  Description = NULL,
  ClientToken = NULL,
  CutoffBehavior = NULL,
  AlarmConfiguration = NULL
)
}
\arguments{
\item{WindowId}{[required] The ID of the maintenance window the task should be added to.}

\item{Targets}{The targets (either managed nodes or maintenance window targets).

One or more targets must be specified for maintenance window Run
Command-type tasks. Depending on the task, targets are optional for
other maintenance window task types (Automation, Lambda, and Step
Functions). For more information about running tasks that don't specify
targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{Registering maintenance window tasks without targets}
in the \emph{Amazon Web Services Systems Manager User Guide}.

Specify managed nodes using the following format:

\verb{Key=InstanceIds,Values=<instance-id-1>,<instance-id-2>}

Specify maintenance window targets using the following format:

\verb{Key=WindowTargetIds,Values=<window-target-id-1>,<window-target-id-2>}}

\item{TaskArn}{[required] The ARN of the task to run.}

\item{ServiceRoleArn}{The Amazon Resource Name (ARN) of the IAM service role for Amazon Web
Services Systems Manager to assume when running a maintenance window
task. If you do not specify a service role ARN, Systems Manager uses a
service-linked role in your account. If no appropriate service-linked
role for Systems Manager exists in your account, it is created when you
run
\code{\link[=ssm_register_task_with_maintenance_window]{register_task_with_maintenance_window}}.

However, for an improved security posture, we strongly recommend
creating a custom policy and custom service role for running your
maintenance window tasks. The policy can be crafted to provide only the
permissions needed for your particular maintenance window tasks. For
more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html}{Setting up maintenance windows}
in the in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{TaskType}{[required] The type of task being registered.}

\item{TaskParameters}{The parameters that should be passed to the task when it is run.

\code{TaskParameters} has been deprecated. To specify parameters to pass to a
task when it runs, instead use the \code{Parameters} option in the
\code{TaskInvocationParameters} structure. For information about how Systems
Manager handles these options for the supported maintenance window task
types, see MaintenanceWindowTaskInvocationParameters.}

\item{TaskInvocationParameters}{The parameters that the task should use during execution. Populate only
the fields that match the task type. All other fields should be empty.}

\item{Priority}{The priority of the task in the maintenance window, the lower the number
the higher the priority. Tasks in a maintenance window are scheduled in
priority order with tasks that have the same priority scheduled in
parallel.}

\item{MaxConcurrency}{The maximum number of targets this task can be run for, in parallel.

Although this element is listed as "Required: No", a value can be
omitted only when you are registering or updating a \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{targetless task}
You must provide a value in all other cases.

For maintenance window tasks without a target specified, you can't
supply a value for this option. Instead, the system inserts a
placeholder value of \code{1}. This value doesn't affect the running of your
task.}

\item{MaxErrors}{The maximum number of errors allowed before this task stops being
scheduled.

Although this element is listed as "Required: No", a value can be
omitted only when you are registering or updating a \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html}{targetless task}
You must provide a value in all other cases.

For maintenance window tasks without a target specified, you can't
supply a value for this option. Instead, the system inserts a
placeholder value of \code{1}. This value doesn't affect the running of your
task.}

\item{LoggingInfo}{A structure containing information about an Amazon Simple Storage
Service (Amazon S3) bucket to write managed node-level logs to.

\code{LoggingInfo} has been deprecated. To specify an Amazon Simple Storage
Service (Amazon S3) bucket to contain logs, instead use the
\code{OutputS3BucketName} and \code{OutputS3KeyPrefix} options in the
\code{TaskInvocationParameters} structure. For information about how Amazon
Web Services Systems Manager handles these options for the supported
maintenance window task types, see
MaintenanceWindowTaskInvocationParameters.}

\item{Name}{An optional name for the task.}

\item{Description}{An optional description for the task.}

\item{ClientToken}{User-provided idempotency token.}

\item{CutoffBehavior}{Indicates whether tasks should continue to run after the cutoff time
specified in the maintenance windows is reached.
\itemize{
\item \code{CONTINUE_TASK}: When the cutoff time is reached, any tasks that are
running continue. The default value.
\item \code{CANCEL_TASK}:
\itemize{
\item For Automation, Lambda, Step Functions tasks: When the cutoff
time is reached, any task invocations that are already running
continue, but no new task invocations are started.
\item For Run Command tasks: When the cutoff time is reached, the
system sends a \code{\link[=ssm_cancel_command]{cancel_command}} operation
that attempts to cancel the command associated with the task.
However, there is no guarantee that the command will be
terminated and the underlying process stopped.
}

The status for tasks that are not completed is \code{TIMED_OUT}.
}}

\item{AlarmConfiguration}{The CloudWatch alarm you want to apply to your maintenance window task.}
}
\description{
Adds a new task to a maintenance window.

See \url{https://www.paws-r-sdk.com/docs/ssm_register_task_with_maintenance_window/} for full documentation.
}
\keyword{internal}
