# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Health APIs and Notifications
#'
#' @description
#' Health
#' 
#' The Health API provides access to the Health information that appears in
#' the Health Dashboard. You can use the API operations to get information
#' about events that might affect your Amazon Web Services services and
#' resources.
#' 
#' You must have a Business, Enterprise On-Ramp, or Enterprise Support plan
#' from [Amazon Web Services
#' Support](https://aws.amazon.com/premiumsupport/) to use the Health API.
#' If you call the Health API from an Amazon Web Services account that
#' doesn't have a Business, Enterprise On-Ramp, or Enterprise Support plan,
#' you receive a `SubscriptionRequiredException` error.
#' 
#' For API access, you need an access key ID and a secret access key. Use
#' temporary credentials instead of long-term access keys when possible.
#' Temporary credentials include an access key ID, a secret access key, and
#' a security token that indicates when the credentials expire. For more
#' information, see [Best practices for managing Amazon Web Services access
#' keys](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_access-keys.html#securing_access-keys)
#' in the *Amazon Web Services General Reference*.
#' 
#' You can use the Health endpoint health.us-east-1.amazonaws.com (HTTPS)
#' to call the Health API operations. Health supports a multi-Region
#' application architecture and has two regional endpoints in an
#' active-passive configuration. You can use the high availability endpoint
#' example to determine which Amazon Web Services Region is active, so that
#' you can get the latest information from the API. For more information,
#' see [Accessing the Health
#' API](https://docs.aws.amazon.com/health/latest/ug/health-api.html) in
#' the *Health User Guide*.
#' 
#' For authentication of requests, Health uses the [Signature Version 4
#' Signing
#' Process](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_sigv.html).
#' 
#' If your Amazon Web Services account is part of Organizations, you can
#' use the Health organizational view feature. This feature provides a
#' centralized view of Health events across all accounts in your
#' organization. You can aggregate Health events in real time to identify
#' accounts in your organization that are affected by an operational event
#' or get notified of security vulnerabilities. Use the organizational view
#' API operations to enable this feature and return event information. For
#' more information, see [Aggregating Health
#' events](https://docs.aws.amazon.com/health/latest/ug/aggregate-events.html)
#' in the *Health User Guide*.
#' 
#' When you use the Health API operations to return Health events, see the
#' following recommendations:
#' 
#' -   Use the
#'     [eventScopeCode](https://docs.aws.amazon.com/health/latest/APIReference/API_Event.html#AWSHealth-Type-Event-eventScopeCode)
#'     parameter to specify whether to return Health events that are public
#'     or account-specific.
#' 
#' -   Use pagination to view all events from the response. For example, if
#'     you call the
#'     [`describe_events_for_organization`][health_describe_events_for_organization]
#'     operation to get all events in your organization, you might receive
#'     several page results. Specify the `nextToken` in the next request to
#'     return more results.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- health(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- health()
#' svc$describe_affected_accounts_for_organization(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=health_describe_affected_accounts_for_organization]{describe_affected_accounts_for_organization} \tab Returns a list of accounts in the organization from Organizations that are affected by the provided event\cr
#'  \link[=health_describe_affected_entities]{describe_affected_entities} \tab Returns a list of entities that have been affected by the specified events, based on the specified filter criteria\cr
#'  \link[=health_describe_affected_entities_for_organization]{describe_affected_entities_for_organization} \tab Returns a list of entities that have been affected by one or more events for one or more accounts in your organization in Organizations, based on the filter criteria\cr
#'  \link[=health_describe_entity_aggregates]{describe_entity_aggregates} \tab Returns the number of entities that are affected by each of the specified events\cr
#'  \link[=health_describe_entity_aggregates_for_organization]{describe_entity_aggregates_for_organization} \tab Returns a list of entity aggregates for your Organizations that are affected by each of the specified events\cr
#'  \link[=health_describe_event_aggregates]{describe_event_aggregates} \tab Returns the number of events of each event type (issue, scheduled change, and account notification)\cr
#'  \link[=health_describe_event_details]{describe_event_details} \tab Returns detailed information about one or more specified events\cr
#'  \link[=health_describe_event_details_for_organization]{describe_event_details_for_organization} \tab Returns detailed information about one or more specified events for one or more Amazon Web Services accounts in your organization\cr
#'  \link[=health_describe_events]{describe_events} \tab Returns information about events that meet the specified filter criteria\cr
#'  \link[=health_describe_events_for_organization]{describe_events_for_organization} \tab Returns information about events across your organization in Organizations\cr
#'  \link[=health_describe_event_types]{describe_event_types} \tab Returns the event types that meet the specified filter criteria\cr
#'  \link[=health_describe_health_service_status_for_organization]{describe_health_service_status_for_organization} \tab This operation provides status information on enabling or disabling Health to work with your organization\cr
#'  \link[=health_disable_health_service_access_for_organization]{disable_health_service_access_for_organization} \tab Disables Health from working with Organizations\cr
#'  \link[=health_enable_health_service_access_for_organization]{enable_health_service_access_for_organization} \tab Enables Health to work with Organizations
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname health
#' @export
health <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .health$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.health <- list()

.health$operations <- list()

.health$metadata <- list(
  service_name = "health",
  endpoints = list("aws-global" = list(endpoint = "global.health.amazonaws.com", global = TRUE), "us-east-1" = list(endpoint = "global.health.amazonaws.com", global = TRUE), "^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "health.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Health",
  api_version = "2016-08-04",
  signing_name = "health",
  json_version = "1.1",
  target_prefix = "AWSHealth_20160804"
)

.health$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.health$metadata, handlers, config, op)
}
